/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.function.gpsies.GpsiesTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetWikipediaXmlHandler
extends DefaultHandler {
    private String _value = null;
    private ArrayList<GpsiesTrack> _trackList = null;
    private GpsiesTrack _track = null;
    private String _lat = null;
    private String _lon = null;
    private String _errorMessage = null;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("geonames")) {
            this._trackList = new ArrayList();
        } else if (string3.equals("entry")) {
            this._track = new GpsiesTrack();
            this._lat = null;
            this._lon = null;
        } else if (string3.equals("status")) {
            this._errorMessage = attributes.getValue("message");
        } else {
            this._value = null;
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("entry")) {
            this._track.setDownloadLink(String.valueOf(this._lat) + "," + this._lon);
            this._trackList.add(this._track);
        } else if (string3.equals("title")) {
            this._track.setTrackName(this._value);
        } else if (string3.equals("summary")) {
            this._track.setDescription(this._value);
        } else if (string3.equals("lat")) {
            this._lat = this._value;
        } else if (string3.equals("lng")) {
            this._lon = this._value;
        } else if (string3.equals("distance")) {
            try {
                this._track.setLength(Double.parseDouble(this._value) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string3.equals("wikipediaUrl")) {
            this._track.setWebUrl(this._value);
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this._value = this._value == null ? string : String.valueOf(this._value) + string;
        super.characters(cArray, n, n2);
    }

    public ArrayList<GpsiesTrack> getTrackList() {
        return this._trackList;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }
}

