/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;

public abstract class UnitSetLibrary {
    public static final Unit UNITS_FEET = new Unit("feet", 3.2808);
    public static final Unit UNITS_METRES = new Unit("metres");
    public static final Unit UNITS_KILOMETRES = new Unit("kilometres", 0.001);
    public static final Unit UNITS_MILES = new Unit("miles", 6.213881811967936E-4);
    public static final Unit UNITS_NAUTICAL_MILES = new Unit("nauticalmiles", 5.399568034557236E-4);
    private static UnitSet[] _sets = new UnitSet[]{new UnitSet("unitset.kilometres", UNITS_KILOMETRES, UNITS_METRES, Altitude.Format.METRES), new UnitSet("unitset.miles", UNITS_MILES, UNITS_FEET, Altitude.Format.FEET), new UnitSet("unitset.nautical", UNITS_NAUTICAL_MILES, UNITS_FEET, Altitude.Format.FEET)};

    public static int getNumUnitSets() {
        return _sets.length;
    }

    public static UnitSet getUnitSet(int n) {
        if (n >= 0 && n < UnitSetLibrary.getNumUnitSets()) {
            return _sets[n];
        }
        return _sets[0];
    }

    public static UnitSet getUnitSet(String string) {
        int n = 0;
        while (n < UnitSetLibrary.getNumUnitSets()) {
            UnitSet unitSet = UnitSetLibrary.getUnitSet(n);
            if (unitSet.getNameKey().equals(string)) {
                return unitSet;
            }
            ++n;
        }
        return UnitSetLibrary.getUnitSet(0);
    }
}

