/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import tim.prune.data.MediaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MediaList {
    protected ArrayList<MediaObject> _media = null;

    public MediaList() {
        this(null);
    }

    protected MediaList(ArrayList<MediaObject> arrayList) {
        this._media = arrayList;
        if (this._media == null) {
            this._media = new ArrayList();
        }
    }

    public int getNumMedia() {
        return this._media.size();
    }

    public void addMedia(MediaObject mediaObject) {
        if (mediaObject != null) {
            this._media.add(mediaObject);
        }
    }

    public void addMedia(MediaObject mediaObject, int n) {
        if (mediaObject != null) {
            this._media.add(n, mediaObject);
        }
    }

    public void deleteMedia(int n) {
        this._media.remove(n);
    }

    public boolean contains(MediaObject mediaObject) {
        return this.getMediaIndex(mediaObject) > -1;
    }

    public int getMediaIndex(MediaObject mediaObject) {
        int n = this.getNumMedia();
        if (n <= 0 || mediaObject == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < n) {
            MediaObject mediaObject2 = this._media.get(n2);
            if (mediaObject2 != null && mediaObject2.equals(mediaObject)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public MediaObject getMedia(int n) {
        if (n < 0 || n >= this.getNumMedia()) {
            return null;
        }
        return this._media.get(n);
    }

    /*
     * Unable to fully structure code
     */
    public void cropTo(int var1_1) {
        block1: {
            if (var1_1 > 0) ** GOTO lbl6
            this._media.clear();
            break block1;
lbl-1000:
            // 1 sources

            {
                this._media.remove(this._media.size() - 1);
lbl6:
                // 2 sources

                ** while (this._media.size() > var1_1)
            }
        }
    }

    public String[] getNameList() {
        int n = this.getNumMedia();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getMedia(n2).getName();
            ++n2;
        }
        return stringArray;
    }

    public boolean hasCorrelatedMedia() {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject.getDataPoint() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasUncorrelatedMedia() {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject.getDataPoint() != null || !mediaObject.hasTimestamp()) continue;
            return true;
        }
        return false;
    }

    public void removeCorrelatedMedia() {
        if (this.getNumMedia() > 0) {
            ArrayList<MediaObject> arrayList = new ArrayList<MediaObject>();
            for (MediaObject mediaObject : this._media) {
                if (mediaObject == null) continue;
                if (mediaObject.getDataPoint() == null) {
                    arrayList.add(mediaObject);
                    continue;
                }
                mediaObject.resetCachedData();
            }
            this._media = arrayList;
        }
    }

    public boolean hasMediaWithFile() {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject.getFile() == null) continue;
            return true;
        }
        return false;
    }

    public abstract MediaList cloneList();

    public void restore(MediaList mediaList) {
        this._media.clear();
        if (mediaList != null && mediaList.getNumMedia() > 0) {
            this._media.addAll(mediaList._media);
        }
    }
}

