/*
==========================================================================

Project:   gpctool - a graphical user interface and development 
           environment for the gpc generic polygon clipper library.

File:      main.c
Author:    Alan Murta (email: gpc@cs.man.ac.uk)
Version:   1.01
Date:      11th April 1999

Copyright: (C) 1997-1999, Advanced Interfaces Group,
           University of Manchester.

           This software is free for non-commercial use. It may be copied,
           modified, and redistributed provided that this copyright notice
           is preserved on all copies. The intellectual property rights of
           the algorithms used reside with the University of Manchester
           Advanced Interfaces Group.

           You may not use this software, in whole or in part, in support
           of any commercial product without the express consent of the
           author.

           There is no warranty or other guarantee of fitness of this
           software for any purpose. It is provided solely "as is".

==========================================================================
*/


#include "forms.h"
#include "gpc.h"
#include "gpctool.h"
#include "appl.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>


/* Global variables */

gpc_op       op= GPC_DIFF;
int          clip_type = 1;
int          sketch_poly;
gpc_polygon  poly[3];
gpc_tristrip tri;
layout_info  layout;

FD_gpctool *fd_gpctool;
FL_FORM *quit_form;
FL_FORM *version_form;
FL_FORM *opengl_form;
FL_OBJECT *min_label_obj, *max_label_obj;
FL_OBJECT *opengl_canvas;
char min_label[40], max_label[40];


/* External functions */

extern void quit_yes(FL_OBJECT *, long);
extern void quit_no(FL_OBJECT *, long);
extern void version_dismiss(FL_OBJECT *, long);
extern int  canvas_expose(FL_OBJECT *, Window, int, int, XEvent *, void *);
extern int  canvas_button(FL_OBJECT *, Window, int, int, XEvent *, void *);


int main(int argc, char *argv[])
{
  int i;

  FL_OBJECT *object;

  fl_initialize(&argc, argv, 0, 0, 0);

  /* Create primary form using fdesign code */
  fd_gpctool = create_form_gpctool();

  /* Create other forms */

  opengl_form=
  fl_bgn_form(FL_FLAT_BOX, 860, 880);
    opengl_canvas= fl_add_glcanvas(FL_NORMAL_CANVAS, 14, 24, 832, 832, "");
    fl_add_canvas_handler(opengl_canvas, Expose, canvas_expose, 0);
    fl_add_canvas_handler(opengl_canvas, ButtonPress, canvas_button, 0);

    sprintf(min_label, "(%lf, %lf)", DEFAULT_XL, DEFAULT_YB);
    min_label_obj= fl_add_text(FL_NORMAL_TEXT, 10, 860, 400, 20, min_label); 
    fl_set_object_lsize(min_label_obj, FL_NORMAL_SIZE);
    fl_set_object_lalign(min_label_obj, FL_ALIGN_LEFT);

    sprintf(max_label, "(%lf, %lf)", DEFAULT_XR, DEFAULT_YT);
    max_label_obj= fl_add_text(FL_NORMAL_TEXT, 450, 0, 400, 20, max_label); 
    fl_set_object_lsize(max_label_obj, FL_NORMAL_SIZE);
    fl_set_object_lalign(max_label_obj, FL_ALIGN_RIGHT);
  fl_end_form();

  version_form=
  fl_bgn_form(FL_NO_BOX, 170, 300);
    object= fl_add_box(FL_UP_BOX,0,0,170,300,"");
    object= fl_add_labelframe(FL_ENGRAVED_FRAME,20,150,130,80,"Author");
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lstyle(object,FL_BOLD_STYLE);
    object= fl_add_text(FL_NORMAL_TEXT,60,10,90,30,"gpctool");
    fl_set_object_lcolor(object,FL_INACTIVE);
    fl_set_object_lsize(object,FL_HUGE_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(object,FL_TIMESBOLDITALIC_STYLE+FL_ENGRAVED_STYLE);
    object= fl_add_button(FL_NORMAL_BUTTON,30,250,110,30,"Dismiss");
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_callback(object,version_dismiss,0);
    object= fl_add_text(FL_NORMAL_TEXT,100,60,40,30,GPCTOOL_VERSION);
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    object= fl_add_text(FL_NORMAL_TEXT,100,90,40,30,GPC_VERSION);
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    object= fl_add_text(FL_NORMAL_TEXT,30,160,110,30,"Alan Murta");
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    object= fl_add_labelframe(FL_ENGRAVED_FRAME,20,50,130,80,"Version");
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lstyle(object,FL_BOLD_STYLE);
    object= fl_add_text(FL_NORMAL_TEXT,30,60,60,30,"gpctool");
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    object= fl_add_text(FL_NORMAL_TEXT,30,90,60,30,"gpc");
    fl_set_object_lsize(object,FL_NORMAL_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    object= fl_add_text(FL_NORMAL_TEXT,30,190,110,20,"Advanced Interfaces Group");
    fl_set_object_lsize(object,FL_TINY_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    object= fl_add_text(FL_NORMAL_TEXT,30,205,110,20,"University of Manchester");
    fl_set_object_lsize(object,FL_TINY_SIZE);
    fl_set_object_lalign(object,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fl_end_form();

  quit_form=
  fl_bgn_form(FL_UP_BOX, 220, 100);
    object= fl_add_box(FL_NO_BOX, 110, 30, 0, 0, "Quit gpctool?");
    fl_set_object_lsize(object, FL_NORMAL_SIZE);
    object= fl_add_button(FL_NORMAL_BUTTON,  15, 55, 80, 30, "Yes");
    fl_set_object_lsize(object, FL_NORMAL_SIZE);
    fl_set_object_callback(object, quit_yes, 0);
    object= fl_add_button(FL_NORMAL_BUTTON, 125, 55, 80, 30, "No" );
    fl_set_object_lsize(object, FL_NORMAL_SIZE);
    fl_set_object_callback(object, quit_no, 0);
  fl_end_form();
  fl_set_form_hotspot(quit_form, 110, 95);

  
  /* Application initialization */
  
  for (i= 0; i < 3; i++)
  {
    poly[i].num_contours= 0;
    poly[i].contour= NULL;
  }
  tri.num_strips= 0;
  tri.strip= NULL;

  /*
  switch(op)
  {
    case GPC_DIFF:
      fl_set_button(fd_gpctool->op_difference, 1);
      break;
    case GPC_INT:
      fl_set_button(fd_gpctool->op_intersection, 1);
      break;
    case GPC_XOR:
      fl_set_button(fd_gpctool->op_intersection, 1);
      break;
    case GPC_UNION:
      fl_set_button(fd_gpctool->op_union, 1);
      break;
  }
  */
  switch(clip_type)
  {
    case 1: 
      fl_set_button(fd_gpctool->clip_polygon, 1);
      break;
    case 2: 
      fl_set_button(fd_gpctool->clip_tristrip, 1);
      break;
    case 3: 
      fl_set_button(fd_gpctool->clip_both, 1);
      break;
  }

  /* Show the startup forms */

  fl_set_form_position(fd_gpctool->gpctool, 1098, 84);
  /* fl_set_form_position(fd_gpctool->gpctool, 1038, 84); */
  fl_show_form(fd_gpctool->gpctool, FL_PLACE_GEOMETRY, FL_FULLBORDER,
               "gpctool");

  fl_set_form_position(opengl_form, 230, 85);
  /* fl_set_form_position(opengl_form, 170, 85); */
  fl_show_form(opengl_form, FL_PLACE_GEOMETRY, FL_TRANSIENT,
               "gpctool canvas");

  fl_deactivate_form(opengl_form);

  fl_do_forms();

  return 0;
}
