/*
===========================================================================

Project:   Generic Polygon Clipper

           A new algorithm for calculating the difference, intersection,
           exclusive-or or union of arbitrary polygon sets.

File:      gpctool.h
Author:    Alan Murta (email: gpc@cs.man.ac.uk)
Version:   1.01
Date:      11th April 1999

Copyright: (C) 1997-1999, Advanced Interfaces Group,
           University of Manchester.

           This software is free for non-commercial use. It may be copied,
           modified, and redistributed provided that this copyright notice
           is preserved on all copies. The intellectual property rights of
           the algorithms used reside with the University of Manchester
           Advanced Interfaces Group.

           You may not use this software, in whole or in part, in support
           of any commercial product without the express consent of the
           author.

           There is no warranty or other guarantee of fitness of this
           software for any purpose. It is provided solely "as is".

===========================================================================
*/

/** Header file generated with fdesign on Sun May 17 20:36:52 1998.**/

#ifndef FD_gpctool_h_
#define FD_gpctool_h_

/** Callbacks, globals and object handlers **/
extern void quit_request(FL_OBJECT *, long);
extern void reset_request(FL_OBJECT *, long);
extern void sketch_polygon(FL_OBJECT *, long);
extern void load_polygon(FL_OBJECT *, long);
extern void save_polygon(FL_OBJECT *, long);
extern void dump_psfile(FL_OBJECT *, long);
extern void version_request(FL_OBJECT *, long);
extern void set_clip_type(FL_OBJECT *, long);
extern void set_op(FL_OBJECT *, long);


/**** Forms and Objects ****/
typedef struct {
	FL_FORM *gpctool;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *clip_type;
	FL_OBJECT *clip_polygon;
	FL_OBJECT *clip_tristrip;
	FL_OBJECT *clip_both;
	FL_OBJECT *op_type;
	FL_OBJECT *op_difference;
	FL_OBJECT *op_intersection;
	FL_OBJECT *op_xor;
	FL_OBJECT *op_union;
} FD_gpctool;

extern FD_gpctool * create_form_gpctool(void);

#endif /* FD_gpctool_h_ */
