<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/memcache/memcache_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/base/memcache_sharding_strategy_pb.php';
}
namespace google\appengine\MemcacheServiceError {
  class ErrorCode {
    const OK = 0;
    const UNSPECIFIED_ERROR = 1;
    const NAMESPACE_NOT_SET = 2;
    const PERMISSION_DENIED = 3;
    const INVALID_VALUE = 6;
  }
}
namespace google\appengine {
  class MemcacheServiceError extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class AppOverride extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getNumMemcachegBackends() {
      if (!isset($this->num_memcacheg_backends)) {
        return 0;
      }
      return $this->num_memcacheg_backends;
    }
    public function setNumMemcachegBackends($val) {
      $this->num_memcacheg_backends = $val;
      return $this;
    }
    public function clearNumMemcachegBackends() {
      unset($this->num_memcacheg_backends);
      return $this;
    }
    public function hasNumMemcachegBackends() {
      return isset($this->num_memcacheg_backends);
    }
    public function getIgnoreShardlock() {
      if (!isset($this->ignore_shardlock)) {
        return false;
      }
      return $this->ignore_shardlock;
    }
    public function setIgnoreShardlock($val) {
      $this->ignore_shardlock = $val;
      return $this;
    }
    public function clearIgnoreShardlock() {
      unset($this->ignore_shardlock);
      return $this;
    }
    public function hasIgnoreShardlock() {
      return isset($this->ignore_shardlock);
    }
    public function getMemcachePoolHint() {
      if (!isset($this->memcache_pool_hint)) {
        return '';
      }
      return $this->memcache_pool_hint;
    }
    public function setMemcachePoolHint($val) {
      $this->memcache_pool_hint = $val;
      return $this;
    }
    public function clearMemcachePoolHint() {
      unset($this->memcache_pool_hint);
      return $this;
    }
    public function hasMemcachePoolHint() {
      return isset($this->memcache_pool_hint);
    }
    public function getMemcacheShardingStrategy() {
      if (!isset($this->memcache_sharding_strategy)) {
        return 0;
      }
      return $this->memcache_sharding_strategy;
    }
    public function setMemcacheShardingStrategy($val) {
      $this->memcache_sharding_strategy = $val;
      return $this;
    }
    public function clearMemcacheShardingStrategy() {
      unset($this->memcache_sharding_strategy);
      return $this;
    }
    public function hasMemcacheShardingStrategy() {
      return isset($this->memcache_sharding_strategy);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearNumMemcachegBackends();
      $this->clearIgnoreShardlock();
      $this->clearMemcachePoolHint();
      $this->clearMemcacheShardingStrategy();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->num_memcacheg_backends)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->num_memcacheg_backends);
      }
      if (isset($this->ignore_shardlock)) {
        $res += 2;
      }
      if (isset($this->memcache_pool_hint)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->memcache_pool_hint));
      }
      if (isset($this->memcache_sharding_strategy)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->memcache_sharding_strategy);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->num_memcacheg_backends)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->num_memcacheg_backends);
      }
      if (isset($this->ignore_shardlock)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->ignore_shardlock);
      }
      if (isset($this->memcache_pool_hint)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->memcache_pool_hint);
      }
      if (isset($this->memcache_sharding_strategy)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->memcache_sharding_strategy);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setNumMemcachegBackends($d->getVarInt32());
            break;
          case 24:
            $this->setIgnoreShardlock($d->getBoolean());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setMemcachePoolHint(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 40:
            $this->setMemcacheShardingStrategy($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasNumMemcachegBackends()) {
        $this->setNumMemcachegBackends($x->getNumMemcachegBackends());
      }
      if ($x->hasIgnoreShardlock()) {
        $this->setIgnoreShardlock($x->getIgnoreShardlock());
      }
      if ($x->hasMemcachePoolHint()) {
        $this->setMemcachePoolHint($x->getMemcachePoolHint());
      }
      if ($x->hasMemcacheShardingStrategy()) {
        $this->setMemcacheShardingStrategy($x->getMemcacheShardingStrategy());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->num_memcacheg_backends) !== isset($x->num_memcacheg_backends)) return false;
      if (isset($this->num_memcacheg_backends) && !$this->integerEquals($this->num_memcacheg_backends, $x->num_memcacheg_backends)) return false;
      if (isset($this->ignore_shardlock) !== isset($x->ignore_shardlock)) return false;
      if (isset($this->ignore_shardlock) && $this->ignore_shardlock !== $x->ignore_shardlock) return false;
      if (isset($this->memcache_pool_hint) !== isset($x->memcache_pool_hint)) return false;
      if (isset($this->memcache_pool_hint) && $this->memcache_pool_hint !== $x->memcache_pool_hint) return false;
      if (isset($this->memcache_sharding_strategy) !== isset($x->memcache_sharding_strategy)) return false;
      if (isset($this->memcache_sharding_strategy) && $this->memcache_sharding_strategy !== $x->memcache_sharding_strategy) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->num_memcacheg_backends)) {
        $res .= $prefix . "num_memcacheg_backends: " . $this->debugFormatInt32($this->num_memcacheg_backends) . "\n";
      }
      if (isset($this->ignore_shardlock)) {
        $res .= $prefix . "ignore_shardlock: " . $this->debugFormatBool($this->ignore_shardlock) . "\n";
      }
      if (isset($this->memcache_pool_hint)) {
        $res .= $prefix . "memcache_pool_hint: " . $this->debugFormatString($this->memcache_pool_hint) . "\n";
      }
      if (isset($this->memcache_sharding_strategy)) {
        $res .= $prefix . "memcache_sharding_strategy: " . ($this->memcache_sharding_strategy) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheGetRequest extends \google\net\ProtocolMessage {
    private $key = array();
    public function getKeySize() {
      return sizeof($this->key);
    }
    public function getKeyList() {
      return $this->key;
    }
    public function getKey($idx) {
      return $this->key[$idx];
    }
    public function setKey($idx, $val) {
      $this->key[$idx] = $val;
      return $this;
    }
    public function addKey($val) {
      $this->key[] = $val;
      return $this;
    }
    public function clearKey() {
      $this->key = array();
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getForCas() {
      if (!isset($this->for_cas)) {
        return false;
      }
      return $this->for_cas;
    }
    public function setForCas($val) {
      $this->for_cas = $val;
      return $this;
    }
    public function clearForCas() {
      unset($this->for_cas);
      return $this;
    }
    public function hasForCas() {
      return isset($this->for_cas);
    }
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearKey();
      $this->clearNameSpace();
      $this->clearForCas();
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->key);
      $res += 1 * sizeof($this->key);
      foreach ($this->key as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->name_space)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name_space));
      }
      if (isset($this->for_cas)) {
        $res += 2;
      }
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->key);
      foreach ($this->key as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->name_space);
      }
      if (isset($this->for_cas)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->for_cas);
      }
      if (isset($this->override)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 32:
            $this->setForCas($d->getBoolean());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getKeyList() as $v) {
        $this->addKey($v);
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      if ($x->hasForCas()) {
        $this->setForCas($x->getForCas());
      }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->key) !== sizeof($x->key)) return false;
      foreach (array_map(null, $this->key, $x->key) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (isset($this->for_cas) !== isset($x->for_cas)) return false;
      if (isset($this->for_cas) && $this->for_cas !== $x->for_cas) return false;
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->key as $value) {
        $res .= $prefix . "key: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      if (isset($this->for_cas)) {
        $res .= $prefix . "for_cas: " . $this->debugFormatBool($this->for_cas) . "\n";
      }
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheGetResponse {
  class Item extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function getFlags() {
      if (!isset($this->flags)) {
        return "0";
      }
      return $this->flags;
    }
    public function setFlags($val) {
      $this->flags = $val;
      return $this;
    }
    public function clearFlags() {
      unset($this->flags);
      return $this;
    }
    public function hasFlags() {
      return isset($this->flags);
    }
    public function getCasId() {
      if (!isset($this->cas_id)) {
        return "0";
      }
      return $this->cas_id;
    }
    public function setCasId($val) {
      if (is_double($val)) {
        $this->cas_id = sprintf('%0.0F', $val);
      } else {
        $this->cas_id = $val;
      }
      return $this;
    }
    public function clearCasId() {
      unset($this->cas_id);
      return $this;
    }
    public function hasCasId() {
      return isset($this->cas_id);
    }
    public function getExpiresInSeconds() {
      if (!isset($this->expires_in_seconds)) {
        return 0;
      }
      return $this->expires_in_seconds;
    }
    public function setExpiresInSeconds($val) {
      $this->expires_in_seconds = $val;
      return $this;
    }
    public function clearExpiresInSeconds() {
      unset($this->expires_in_seconds);
      return $this;
    }
    public function hasExpiresInSeconds() {
      return isset($this->expires_in_seconds);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
      $this->clearFlags();
      $this->clearCasId();
      $this->clearExpiresInSeconds();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      if (isset($this->flags)) {
        $res += 5;
      }
      if (isset($this->cas_id)) {
        $res += 9;
      }
      if (isset($this->expires_in_seconds)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->expires_in_seconds);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->value);
      }
      if (isset($this->flags)) {
        $out->putVarInt32(37);
        $out->put32($this->flags);
      }
      if (isset($this->cas_id)) {
        $out->putVarInt32(41);
        $out->put64($this->cas_id);
      }
      if (isset($this->expires_in_seconds)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->expires_in_seconds);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 37:
            $this->setFlags($d->getFixed32());
            break;
          case 41:
            $this->setCasId($d->getFixed64());
            break;
          case 48:
            $this->setExpiresInSeconds($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
      if ($x->hasFlags()) {
        $this->setFlags($x->getFlags());
      }
      if ($x->hasCasId()) {
        $this->setCasId($x->getCasId());
      }
      if ($x->hasExpiresInSeconds()) {
        $this->setExpiresInSeconds($x->getExpiresInSeconds());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      if (isset($this->flags) !== isset($x->flags)) return false;
      if (isset($this->flags) && !$this->integerEquals($this->flags, $x->flags)) return false;
      if (isset($this->cas_id) !== isset($x->cas_id)) return false;
      if (isset($this->cas_id) && !$this->integerEquals($this->cas_id, $x->cas_id)) return false;
      if (isset($this->expires_in_seconds) !== isset($x->expires_in_seconds)) return false;
      if (isset($this->expires_in_seconds) && !$this->integerEquals($this->expires_in_seconds, $x->expires_in_seconds)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      if (isset($this->flags)) {
        $res .= $prefix . "flags: " . $this->debugFormatFixed32($this->flags) . "\n";
      }
      if (isset($this->cas_id)) {
        $res .= $prefix . "cas_id: " . $this->debugFormatFixed64($this->cas_id) . "\n";
      }
      if (isset($this->expires_in_seconds)) {
        $res .= $prefix . "expires_in_seconds: " . $this->debugFormatInt32($this->expires_in_seconds) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheGetResponse extends \google\net\ProtocolMessage {
    private $item = array();
    public function getItemSize() {
      return sizeof($this->item);
    }
    public function getItemList() {
      return $this->item;
    }
    public function mutableItem($idx) {
      if (!isset($this->item[$idx])) {
        $val = new \google\appengine\MemcacheGetResponse\Item();
        $this->item[$idx] = $val;
        return $val;
      }
      return $this->item[$idx];
    }
    public function getItem($idx) {
      if (isset($this->item[$idx])) {
        return $this->item[$idx];
      }
      if ($idx >= end(array_keys($this->item))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\MemcacheGetResponse\Item();
    }
    public function addItem() {
      $val = new \google\appengine\MemcacheGetResponse\Item();
      $this->item[] = $val;
      return $val;
    }
    public function clearItem() {
      $this->item = array();
    }
    public function clear() {
      $this->clearItem();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->item);
      $res += 2 * sizeof($this->item);
      foreach ($this->item as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->item);
      foreach ($this->item as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addItem()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->item as $value) {
        if (!$value->isInitialized()) return 'item';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getItemList() as $v) {
        $this->addItem()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->item) !== sizeof($x->item)) return false;
      foreach (array_map(null, $this->item, $x->item) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->item as $value) {
        $res .= $prefix . "Item {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheSetRequest {
  class SetPolicy {
    const SET = 1;
    const ADD = 2;
    const REPLACE = 3;
    const CAS = 4;
  }
}
namespace google\appengine\MemcacheSetRequest {
  class Item extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function getFlags() {
      if (!isset($this->flags)) {
        return "0";
      }
      return $this->flags;
    }
    public function setFlags($val) {
      $this->flags = $val;
      return $this;
    }
    public function clearFlags() {
      unset($this->flags);
      return $this;
    }
    public function hasFlags() {
      return isset($this->flags);
    }
    public function getSetPolicy() {
      if (!isset($this->set_policy)) {
        return 1;
      }
      return $this->set_policy;
    }
    public function setSetPolicy($val) {
      $this->set_policy = $val;
      return $this;
    }
    public function clearSetPolicy() {
      unset($this->set_policy);
      return $this;
    }
    public function hasSetPolicy() {
      return isset($this->set_policy);
    }
    public function getExpirationTime() {
      if (!isset($this->expiration_time)) {
        return '0';
      }
      return $this->expiration_time;
    }
    public function setExpirationTime($val) {
      $this->expiration_time = $val;
      return $this;
    }
    public function clearExpirationTime() {
      unset($this->expiration_time);
      return $this;
    }
    public function hasExpirationTime() {
      return isset($this->expiration_time);
    }
    public function getCasId() {
      if (!isset($this->cas_id)) {
        return "0";
      }
      return $this->cas_id;
    }
    public function setCasId($val) {
      if (is_double($val)) {
        $this->cas_id = sprintf('%0.0F', $val);
      } else {
        $this->cas_id = $val;
      }
      return $this;
    }
    public function clearCasId() {
      unset($this->cas_id);
      return $this;
    }
    public function hasCasId() {
      return isset($this->cas_id);
    }
    public function getForCas() {
      if (!isset($this->for_cas)) {
        return false;
      }
      return $this->for_cas;
    }
    public function setForCas($val) {
      $this->for_cas = $val;
      return $this;
    }
    public function clearForCas() {
      unset($this->for_cas);
      return $this;
    }
    public function hasForCas() {
      return isset($this->for_cas);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
      $this->clearFlags();
      $this->clearSetPolicy();
      $this->clearExpirationTime();
      $this->clearCasId();
      $this->clearForCas();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      if (isset($this->flags)) {
        $res += 5;
      }
      if (isset($this->set_policy)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->set_policy);
      }
      if (isset($this->expiration_time)) {
        $res += 5;
      }
      if (isset($this->cas_id)) {
        $res += 9;
      }
      if (isset($this->for_cas)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->value);
      }
      if (isset($this->flags)) {
        $out->putVarInt32(37);
        $out->put32($this->flags);
      }
      if (isset($this->set_policy)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->set_policy);
      }
      if (isset($this->expiration_time)) {
        $out->putVarInt32(53);
        $out->put32($this->expiration_time);
      }
      if (isset($this->cas_id)) {
        $out->putVarInt32(65);
        $out->put64($this->cas_id);
      }
      if (isset($this->for_cas)) {
        $out->putVarInt32(72);
        $out->putBoolean($this->for_cas);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 37:
            $this->setFlags($d->getFixed32());
            break;
          case 40:
            $this->setSetPolicy($d->getVarInt32());
            break;
          case 53:
            $this->setExpirationTime($d->getFixed32());
            break;
          case 65:
            $this->setCasId($d->getFixed64());
            break;
          case 72:
            $this->setForCas($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
      if ($x->hasFlags()) {
        $this->setFlags($x->getFlags());
      }
      if ($x->hasSetPolicy()) {
        $this->setSetPolicy($x->getSetPolicy());
      }
      if ($x->hasExpirationTime()) {
        $this->setExpirationTime($x->getExpirationTime());
      }
      if ($x->hasCasId()) {
        $this->setCasId($x->getCasId());
      }
      if ($x->hasForCas()) {
        $this->setForCas($x->getForCas());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      if (isset($this->flags) !== isset($x->flags)) return false;
      if (isset($this->flags) && !$this->integerEquals($this->flags, $x->flags)) return false;
      if (isset($this->set_policy) !== isset($x->set_policy)) return false;
      if (isset($this->set_policy) && $this->set_policy !== $x->set_policy) return false;
      if (isset($this->expiration_time) !== isset($x->expiration_time)) return false;
      if (isset($this->expiration_time) && !$this->integerEquals($this->expiration_time, $x->expiration_time)) return false;
      if (isset($this->cas_id) !== isset($x->cas_id)) return false;
      if (isset($this->cas_id) && !$this->integerEquals($this->cas_id, $x->cas_id)) return false;
      if (isset($this->for_cas) !== isset($x->for_cas)) return false;
      if (isset($this->for_cas) && $this->for_cas !== $x->for_cas) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      if (isset($this->flags)) {
        $res .= $prefix . "flags: " . $this->debugFormatFixed32($this->flags) . "\n";
      }
      if (isset($this->set_policy)) {
        $res .= $prefix . "set_policy: " . ($this->set_policy) . "\n";
      }
      if (isset($this->expiration_time)) {
        $res .= $prefix . "expiration_time: " . $this->debugFormatFixed32($this->expiration_time) . "\n";
      }
      if (isset($this->cas_id)) {
        $res .= $prefix . "cas_id: " . $this->debugFormatFixed64($this->cas_id) . "\n";
      }
      if (isset($this->for_cas)) {
        $res .= $prefix . "for_cas: " . $this->debugFormatBool($this->for_cas) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheSetRequest extends \google\net\ProtocolMessage {
    private $item = array();
    public function getItemSize() {
      return sizeof($this->item);
    }
    public function getItemList() {
      return $this->item;
    }
    public function mutableItem($idx) {
      if (!isset($this->item[$idx])) {
        $val = new \google\appengine\MemcacheSetRequest\Item();
        $this->item[$idx] = $val;
        return $val;
      }
      return $this->item[$idx];
    }
    public function getItem($idx) {
      if (isset($this->item[$idx])) {
        return $this->item[$idx];
      }
      if ($idx >= end(array_keys($this->item))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\MemcacheSetRequest\Item();
    }
    public function addItem() {
      $val = new \google\appengine\MemcacheSetRequest\Item();
      $this->item[] = $val;
      return $val;
    }
    public function clearItem() {
      $this->item = array();
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearItem();
      $this->clearNameSpace();
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->item);
      $res += 2 * sizeof($this->item);
      foreach ($this->item as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->name_space)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name_space));
      }
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->item);
      foreach ($this->item as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(58);
        $out->putPrefixedString($this->name_space);
      }
      if (isset($this->override)) {
        $out->putVarInt32(82);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addItem()->tryMerge($d);
            break;
          case 58:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 82:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->item as $value) {
        if (!$value->isInitialized()) return 'item';
      }
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getItemList() as $v) {
        $this->addItem()->copyFrom($v);
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->item) !== sizeof($x->item)) return false;
      foreach (array_map(null, $this->item, $x->item) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->item as $value) {
        $res .= $prefix . "Item {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheSetResponse {
  class SetStatusCode {
    const STORED = 1;
    const NOT_STORED = 2;
    const ERROR = 3;
    const EXISTS = 4;
  }
}
namespace google\appengine {
  class MemcacheSetResponse extends \google\net\ProtocolMessage {
    private $set_status = array();
    public function getSetStatusSize() {
      return sizeof($this->set_status);
    }
    public function getSetStatusList() {
      return $this->set_status;
    }
    public function getSetStatus($idx) {
      return $this->set_status[$idx];
    }
    public function setSetStatus($idx, $val) {
      $this->set_status[$idx] = $val;
      return $this;
    }
    public function addSetStatus($val) {
      $this->set_status[] = $val;
      return $this;
    }
    public function clearSetStatus() {
      $this->set_status = array();
    }
    public function clear() {
      $this->clearSetStatus();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->set_status);
      $res += 1 * sizeof($this->set_status);
      foreach ($this->set_status as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->set_status);
      foreach ($this->set_status as $value) {
        $out->putVarInt32(8);
        $out->putVarInt32($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->addSetStatus($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getSetStatusList() as $v) {
        $this->addSetStatus($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->set_status) !== sizeof($x->set_status)) return false;
      foreach (array_map(null, $this->set_status, $x->set_status) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->set_status as $value) {
        $res .= $prefix . "set_status: " . ($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheDeleteRequest {
  class Item extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getDeleteTime() {
      if (!isset($this->delete_time)) {
        return '0';
      }
      return $this->delete_time;
    }
    public function setDeleteTime($val) {
      $this->delete_time = $val;
      return $this;
    }
    public function clearDeleteTime() {
      unset($this->delete_time);
      return $this;
    }
    public function hasDeleteTime() {
      return isset($this->delete_time);
    }
    public function clear() {
      $this->clearKey();
      $this->clearDeleteTime();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->delete_time)) {
        $res += 5;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->delete_time)) {
        $out->putVarInt32(29);
        $out->put32($this->delete_time);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 29:
            $this->setDeleteTime($d->getFixed32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasDeleteTime()) {
        $this->setDeleteTime($x->getDeleteTime());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->delete_time) !== isset($x->delete_time)) return false;
      if (isset($this->delete_time) && !$this->integerEquals($this->delete_time, $x->delete_time)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->delete_time)) {
        $res .= $prefix . "delete_time: " . $this->debugFormatFixed32($this->delete_time) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheDeleteRequest extends \google\net\ProtocolMessage {
    private $item = array();
    public function getItemSize() {
      return sizeof($this->item);
    }
    public function getItemList() {
      return $this->item;
    }
    public function mutableItem($idx) {
      if (!isset($this->item[$idx])) {
        $val = new \google\appengine\MemcacheDeleteRequest\Item();
        $this->item[$idx] = $val;
        return $val;
      }
      return $this->item[$idx];
    }
    public function getItem($idx) {
      if (isset($this->item[$idx])) {
        return $this->item[$idx];
      }
      if ($idx >= end(array_keys($this->item))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\MemcacheDeleteRequest\Item();
    }
    public function addItem() {
      $val = new \google\appengine\MemcacheDeleteRequest\Item();
      $this->item[] = $val;
      return $val;
    }
    public function clearItem() {
      $this->item = array();
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearItem();
      $this->clearNameSpace();
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->item);
      $res += 2 * sizeof($this->item);
      foreach ($this->item as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->name_space)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name_space));
      }
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->item);
      foreach ($this->item as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->name_space);
      }
      if (isset($this->override)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addItem()->tryMerge($d);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->item as $value) {
        if (!$value->isInitialized()) return 'item';
      }
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getItemList() as $v) {
        $this->addItem()->copyFrom($v);
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->item) !== sizeof($x->item)) return false;
      foreach (array_map(null, $this->item, $x->item) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->item as $value) {
        $res .= $prefix . "Item {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheDeleteResponse {
  class DeleteStatusCode {
    const DELETED = 1;
    const NOT_FOUND = 2;
  }
}
namespace google\appengine {
  class MemcacheDeleteResponse extends \google\net\ProtocolMessage {
    private $delete_status = array();
    public function getDeleteStatusSize() {
      return sizeof($this->delete_status);
    }
    public function getDeleteStatusList() {
      return $this->delete_status;
    }
    public function getDeleteStatus($idx) {
      return $this->delete_status[$idx];
    }
    public function setDeleteStatus($idx, $val) {
      $this->delete_status[$idx] = $val;
      return $this;
    }
    public function addDeleteStatus($val) {
      $this->delete_status[] = $val;
      return $this;
    }
    public function clearDeleteStatus() {
      $this->delete_status = array();
    }
    public function clear() {
      $this->clearDeleteStatus();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->delete_status);
      $res += 1 * sizeof($this->delete_status);
      foreach ($this->delete_status as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->delete_status);
      foreach ($this->delete_status as $value) {
        $out->putVarInt32(8);
        $out->putVarInt32($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->addDeleteStatus($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getDeleteStatusList() as $v) {
        $this->addDeleteStatus($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->delete_status) !== sizeof($x->delete_status)) return false;
      foreach (array_map(null, $this->delete_status, $x->delete_status) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->delete_status as $value) {
        $res .= $prefix . "delete_status: " . ($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheIncrementRequest {
  class Direction {
    const INCREMENT = 1;
    const DECREMENT = 2;
  }
}
namespace google\appengine {
  class MemcacheIncrementRequest extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getDelta() {
      if (!isset($this->delta)) {
        return '1';
      }
      return $this->delta;
    }
    public function setDelta($val) {
      if (is_double($val)) {
        $this->delta = sprintf('%0.0F', $val);
      } else {
        $this->delta = $val;
      }
      return $this;
    }
    public function clearDelta() {
      unset($this->delta);
      return $this;
    }
    public function hasDelta() {
      return isset($this->delta);
    }
    public function getDirection() {
      if (!isset($this->direction)) {
        return 1;
      }
      return $this->direction;
    }
    public function setDirection($val) {
      $this->direction = $val;
      return $this;
    }
    public function clearDirection() {
      unset($this->direction);
      return $this;
    }
    public function hasDirection() {
      return isset($this->direction);
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getInitialValue() {
      if (!isset($this->initial_value)) {
        return "0";
      }
      return $this->initial_value;
    }
    public function setInitialValue($val) {
      if (is_double($val)) {
        $this->initial_value = sprintf('%0.0F', $val);
      } else {
        $this->initial_value = $val;
      }
      return $this;
    }
    public function clearInitialValue() {
      unset($this->initial_value);
      return $this;
    }
    public function hasInitialValue() {
      return isset($this->initial_value);
    }
    public function getInitialFlags() {
      if (!isset($this->initial_flags)) {
        return "0";
      }
      return $this->initial_flags;
    }
    public function setInitialFlags($val) {
      $this->initial_flags = $val;
      return $this;
    }
    public function clearInitialFlags() {
      unset($this->initial_flags);
      return $this;
    }
    public function hasInitialFlags() {
      return isset($this->initial_flags);
    }
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearKey();
      $this->clearDelta();
      $this->clearDirection();
      $this->clearNameSpace();
      $this->clearInitialValue();
      $this->clearInitialFlags();
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->delta)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->delta);
      }
      if (isset($this->direction)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->direction);
      }
      if (isset($this->name_space)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name_space));
      }
      if (isset($this->initial_value)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->initial_value);
      }
      if (isset($this->initial_flags)) {
        $res += 5;
      }
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->delta)) {
        $out->putVarInt32(16);
        $out->putVarUint64($this->delta);
      }
      if (isset($this->direction)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->direction);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->name_space);
      }
      if (isset($this->initial_value)) {
        $out->putVarInt32(40);
        $out->putVarUint64($this->initial_value);
      }
      if (isset($this->initial_flags)) {
        $out->putVarInt32(53);
        $out->put32($this->initial_flags);
      }
      if (isset($this->override)) {
        $out->putVarInt32(58);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setDelta($d->getVarUint64());
            break;
          case 24:
            $this->setDirection($d->getVarInt32());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 40:
            $this->setInitialValue($d->getVarUint64());
            break;
          case 53:
            $this->setInitialFlags($d->getFixed32());
            break;
          case 58:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasDelta()) {
        $this->setDelta($x->getDelta());
      }
      if ($x->hasDirection()) {
        $this->setDirection($x->getDirection());
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      if ($x->hasInitialValue()) {
        $this->setInitialValue($x->getInitialValue());
      }
      if ($x->hasInitialFlags()) {
        $this->setInitialFlags($x->getInitialFlags());
      }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->delta) !== isset($x->delta)) return false;
      if (isset($this->delta) && !$this->integerEquals($this->delta, $x->delta)) return false;
      if (isset($this->direction) !== isset($x->direction)) return false;
      if (isset($this->direction) && $this->direction !== $x->direction) return false;
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (isset($this->initial_value) !== isset($x->initial_value)) return false;
      if (isset($this->initial_value) && !$this->integerEquals($this->initial_value, $x->initial_value)) return false;
      if (isset($this->initial_flags) !== isset($x->initial_flags)) return false;
      if (isset($this->initial_flags) && !$this->integerEquals($this->initial_flags, $x->initial_flags)) return false;
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->delta)) {
        $res .= $prefix . "delta: " . $this->debugFormatInt64($this->delta) . "\n";
      }
      if (isset($this->direction)) {
        $res .= $prefix . "direction: " . ($this->direction) . "\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      if (isset($this->initial_value)) {
        $res .= $prefix . "initial_value: " . $this->debugFormatInt64($this->initial_value) . "\n";
      }
      if (isset($this->initial_flags)) {
        $res .= $prefix . "initial_flags: " . $this->debugFormatFixed32($this->initial_flags) . "\n";
      }
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheIncrementResponse {
  class IncrementStatusCode {
    const OK = 1;
    const NOT_CHANGED = 2;
    const ERROR = 3;
  }
}
namespace google\appengine {
  class MemcacheIncrementResponse extends \google\net\ProtocolMessage {
    public function getNewValue() {
      if (!isset($this->new_value)) {
        return "0";
      }
      return $this->new_value;
    }
    public function setNewValue($val) {
      if (is_double($val)) {
        $this->new_value = sprintf('%0.0F', $val);
      } else {
        $this->new_value = $val;
      }
      return $this;
    }
    public function clearNewValue() {
      unset($this->new_value);
      return $this;
    }
    public function hasNewValue() {
      return isset($this->new_value);
    }
    public function getIncrementStatus() {
      if (!isset($this->increment_status)) {
        return 1;
      }
      return $this->increment_status;
    }
    public function setIncrementStatus($val) {
      $this->increment_status = $val;
      return $this;
    }
    public function clearIncrementStatus() {
      unset($this->increment_status);
      return $this;
    }
    public function hasIncrementStatus() {
      return isset($this->increment_status);
    }
    public function clear() {
      $this->clearNewValue();
      $this->clearIncrementStatus();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->new_value)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->new_value);
      }
      if (isset($this->increment_status)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->increment_status);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->new_value)) {
        $out->putVarInt32(8);
        $out->putVarUint64($this->new_value);
      }
      if (isset($this->increment_status)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->increment_status);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setNewValue($d->getVarUint64());
            break;
          case 16:
            $this->setIncrementStatus($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasNewValue()) {
        $this->setNewValue($x->getNewValue());
      }
      if ($x->hasIncrementStatus()) {
        $this->setIncrementStatus($x->getIncrementStatus());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->new_value) !== isset($x->new_value)) return false;
      if (isset($this->new_value) && !$this->integerEquals($this->new_value, $x->new_value)) return false;
      if (isset($this->increment_status) !== isset($x->increment_status)) return false;
      if (isset($this->increment_status) && $this->increment_status !== $x->increment_status) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->new_value)) {
        $res .= $prefix . "new_value: " . $this->debugFormatInt64($this->new_value) . "\n";
      }
      if (isset($this->increment_status)) {
        $res .= $prefix . "increment_status: " . ($this->increment_status) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheBatchIncrementRequest extends \google\net\ProtocolMessage {
    private $item = array();
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getItemSize() {
      return sizeof($this->item);
    }
    public function getItemList() {
      return $this->item;
    }
    public function mutableItem($idx) {
      if (!isset($this->item[$idx])) {
        $val = new \google\appengine\MemcacheIncrementRequest();
        $this->item[$idx] = $val;
        return $val;
      }
      return $this->item[$idx];
    }
    public function getItem($idx) {
      if (isset($this->item[$idx])) {
        return $this->item[$idx];
      }
      if ($idx >= end(array_keys($this->item))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\MemcacheIncrementRequest();
    }
    public function addItem() {
      $val = new \google\appengine\MemcacheIncrementRequest();
      $this->item[] = $val;
      return $val;
    }
    public function clearItem() {
      $this->item = array();
    }
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearNameSpace();
      $this->clearItem();
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name_space)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name_space));
      }
      $this->checkProtoArray($this->item);
      $res += 1 * sizeof($this->item);
      foreach ($this->item as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name_space)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->name_space);
      }
      $this->checkProtoArray($this->item);
      foreach ($this->item as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->override)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addItem()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->item as $value) {
        if (!$value->isInitialized()) return 'item';
      }
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      foreach ($x->getItemList() as $v) {
        $this->addItem()->copyFrom($v);
      }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (sizeof($this->item) !== sizeof($x->item)) return false;
      foreach (array_map(null, $this->item, $x->item) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      foreach ($this->item as $value) {
        $res .= $prefix . "item <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheBatchIncrementResponse extends \google\net\ProtocolMessage {
    private $item = array();
    public function getItemSize() {
      return sizeof($this->item);
    }
    public function getItemList() {
      return $this->item;
    }
    public function mutableItem($idx) {
      if (!isset($this->item[$idx])) {
        $val = new \google\appengine\MemcacheIncrementResponse();
        $this->item[$idx] = $val;
        return $val;
      }
      return $this->item[$idx];
    }
    public function getItem($idx) {
      if (isset($this->item[$idx])) {
        return $this->item[$idx];
      }
      if ($idx >= end(array_keys($this->item))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\MemcacheIncrementResponse();
    }
    public function addItem() {
      $val = new \google\appengine\MemcacheIncrementResponse();
      $this->item[] = $val;
      return $val;
    }
    public function clearItem() {
      $this->item = array();
    }
    public function clear() {
      $this->clearItem();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->item);
      $res += 1 * sizeof($this->item);
      foreach ($this->item as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->item);
      foreach ($this->item as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addItem()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->item as $value) {
        if (!$value->isInitialized()) return 'item';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getItemList() as $v) {
        $this->addItem()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->item) !== sizeof($x->item)) return false;
      foreach (array_map(null, $this->item, $x->item) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->item as $value) {
        $res .= $prefix . "item <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheFlushRequest extends \google\net\ProtocolMessage {
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->override)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheFlushResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheStatsRequest extends \google\net\ProtocolMessage {
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->override)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MergedNamespaceStats extends \google\net\ProtocolMessage {
    public function getHits() {
      if (!isset($this->hits)) {
        return "0";
      }
      return $this->hits;
    }
    public function setHits($val) {
      if (is_double($val)) {
        $this->hits = sprintf('%0.0F', $val);
      } else {
        $this->hits = $val;
      }
      return $this;
    }
    public function clearHits() {
      unset($this->hits);
      return $this;
    }
    public function hasHits() {
      return isset($this->hits);
    }
    public function getMisses() {
      if (!isset($this->misses)) {
        return "0";
      }
      return $this->misses;
    }
    public function setMisses($val) {
      if (is_double($val)) {
        $this->misses = sprintf('%0.0F', $val);
      } else {
        $this->misses = $val;
      }
      return $this;
    }
    public function clearMisses() {
      unset($this->misses);
      return $this;
    }
    public function hasMisses() {
      return isset($this->misses);
    }
    public function getByteHits() {
      if (!isset($this->byte_hits)) {
        return "0";
      }
      return $this->byte_hits;
    }
    public function setByteHits($val) {
      if (is_double($val)) {
        $this->byte_hits = sprintf('%0.0F', $val);
      } else {
        $this->byte_hits = $val;
      }
      return $this;
    }
    public function clearByteHits() {
      unset($this->byte_hits);
      return $this;
    }
    public function hasByteHits() {
      return isset($this->byte_hits);
    }
    public function getItems() {
      if (!isset($this->items)) {
        return "0";
      }
      return $this->items;
    }
    public function setItems($val) {
      if (is_double($val)) {
        $this->items = sprintf('%0.0F', $val);
      } else {
        $this->items = $val;
      }
      return $this;
    }
    public function clearItems() {
      unset($this->items);
      return $this;
    }
    public function hasItems() {
      return isset($this->items);
    }
    public function getBytes() {
      if (!isset($this->bytes)) {
        return "0";
      }
      return $this->bytes;
    }
    public function setBytes($val) {
      if (is_double($val)) {
        $this->bytes = sprintf('%0.0F', $val);
      } else {
        $this->bytes = $val;
      }
      return $this;
    }
    public function clearBytes() {
      unset($this->bytes);
      return $this;
    }
    public function hasBytes() {
      return isset($this->bytes);
    }
    public function getOldestItemAge() {
      if (!isset($this->oldest_item_age)) {
        return "0";
      }
      return $this->oldest_item_age;
    }
    public function setOldestItemAge($val) {
      $this->oldest_item_age = $val;
      return $this;
    }
    public function clearOldestItemAge() {
      unset($this->oldest_item_age);
      return $this;
    }
    public function hasOldestItemAge() {
      return isset($this->oldest_item_age);
    }
    public function clear() {
      $this->clearHits();
      $this->clearMisses();
      $this->clearByteHits();
      $this->clearItems();
      $this->clearBytes();
      $this->clearOldestItemAge();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->hits)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->hits);
      }
      if (isset($this->misses)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->misses);
      }
      if (isset($this->byte_hits)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->byte_hits);
      }
      if (isset($this->items)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->items);
      }
      if (isset($this->bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->bytes);
      }
      if (isset($this->oldest_item_age)) {
        $res += 5;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->hits)) {
        $out->putVarInt32(8);
        $out->putVarUint64($this->hits);
      }
      if (isset($this->misses)) {
        $out->putVarInt32(16);
        $out->putVarUint64($this->misses);
      }
      if (isset($this->byte_hits)) {
        $out->putVarInt32(24);
        $out->putVarUint64($this->byte_hits);
      }
      if (isset($this->items)) {
        $out->putVarInt32(32);
        $out->putVarUint64($this->items);
      }
      if (isset($this->bytes)) {
        $out->putVarInt32(40);
        $out->putVarUint64($this->bytes);
      }
      if (isset($this->oldest_item_age)) {
        $out->putVarInt32(53);
        $out->put32($this->oldest_item_age);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setHits($d->getVarUint64());
            break;
          case 16:
            $this->setMisses($d->getVarUint64());
            break;
          case 24:
            $this->setByteHits($d->getVarUint64());
            break;
          case 32:
            $this->setItems($d->getVarUint64());
            break;
          case 40:
            $this->setBytes($d->getVarUint64());
            break;
          case 53:
            $this->setOldestItemAge($d->getFixed32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->hits)) return 'hits';
      if (!isset($this->misses)) return 'misses';
      if (!isset($this->byte_hits)) return 'byte_hits';
      if (!isset($this->items)) return 'items';
      if (!isset($this->bytes)) return 'bytes';
      if (!isset($this->oldest_item_age)) return 'oldest_item_age';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasHits()) {
        $this->setHits($x->getHits());
      }
      if ($x->hasMisses()) {
        $this->setMisses($x->getMisses());
      }
      if ($x->hasByteHits()) {
        $this->setByteHits($x->getByteHits());
      }
      if ($x->hasItems()) {
        $this->setItems($x->getItems());
      }
      if ($x->hasBytes()) {
        $this->setBytes($x->getBytes());
      }
      if ($x->hasOldestItemAge()) {
        $this->setOldestItemAge($x->getOldestItemAge());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->hits) !== isset($x->hits)) return false;
      if (isset($this->hits) && !$this->integerEquals($this->hits, $x->hits)) return false;
      if (isset($this->misses) !== isset($x->misses)) return false;
      if (isset($this->misses) && !$this->integerEquals($this->misses, $x->misses)) return false;
      if (isset($this->byte_hits) !== isset($x->byte_hits)) return false;
      if (isset($this->byte_hits) && !$this->integerEquals($this->byte_hits, $x->byte_hits)) return false;
      if (isset($this->items) !== isset($x->items)) return false;
      if (isset($this->items) && !$this->integerEquals($this->items, $x->items)) return false;
      if (isset($this->bytes) !== isset($x->bytes)) return false;
      if (isset($this->bytes) && !$this->integerEquals($this->bytes, $x->bytes)) return false;
      if (isset($this->oldest_item_age) !== isset($x->oldest_item_age)) return false;
      if (isset($this->oldest_item_age) && !$this->integerEquals($this->oldest_item_age, $x->oldest_item_age)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->hits)) {
        $res .= $prefix . "hits: " . $this->debugFormatInt64($this->hits) . "\n";
      }
      if (isset($this->misses)) {
        $res .= $prefix . "misses: " . $this->debugFormatInt64($this->misses) . "\n";
      }
      if (isset($this->byte_hits)) {
        $res .= $prefix . "byte_hits: " . $this->debugFormatInt64($this->byte_hits) . "\n";
      }
      if (isset($this->items)) {
        $res .= $prefix . "items: " . $this->debugFormatInt64($this->items) . "\n";
      }
      if (isset($this->bytes)) {
        $res .= $prefix . "bytes: " . $this->debugFormatInt64($this->bytes) . "\n";
      }
      if (isset($this->oldest_item_age)) {
        $res .= $prefix . "oldest_item_age: " . $this->debugFormatFixed32($this->oldest_item_age) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheStatsResponse extends \google\net\ProtocolMessage {
    public function getStats() {
      if (!isset($this->stats)) {
        return new \google\appengine\MergedNamespaceStats();
      }
      return $this->stats;
    }
    public function mutableStats() {
      if (!isset($this->stats)) {
        $res = new \google\appengine\MergedNamespaceStats();
        $this->stats = $res;
        return $res;
      }
      return $this->stats;
    }
    public function clearStats() {
      if (isset($this->stats)) {
        unset($this->stats);
      }
    }
    public function hasStats() {
      return isset($this->stats);
    }
    public function clear() {
      $this->clearStats();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->stats)) {
        $res += 1;
        $res += $this->lengthString($this->stats->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->stats)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->stats->byteSizePartial());
        $this->stats->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableStats()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->stats) && (!$this->stats->isInitialized())) return 'stats';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasStats()) {
        $this->mutableStats()->mergeFrom($x->getStats());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->stats) !== isset($x->stats)) return false;
      if (isset($this->stats) && !$this->stats->equals($x->stats)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->stats)) {
        $res .= $prefix . "stats <\n" . $this->stats->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheGrabTailRequest extends \google\net\ProtocolMessage {
    public function getItemCount() {
      if (!isset($this->item_count)) {
        return 0;
      }
      return $this->item_count;
    }
    public function setItemCount($val) {
      $this->item_count = $val;
      return $this;
    }
    public function clearItemCount() {
      unset($this->item_count);
      return $this;
    }
    public function hasItemCount() {
      return isset($this->item_count);
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getOverride() {
      if (!isset($this->override)) {
        return new \google\appengine\AppOverride();
      }
      return $this->override;
    }
    public function mutableOverride() {
      if (!isset($this->override)) {
        $res = new \google\appengine\AppOverride();
        $this->override = $res;
        return $res;
      }
      return $this->override;
    }
    public function clearOverride() {
      if (isset($this->override)) {
        unset($this->override);
      }
    }
    public function hasOverride() {
      return isset($this->override);
    }
    public function clear() {
      $this->clearItemCount();
      $this->clearNameSpace();
      $this->clearOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->item_count)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->item_count);
      }
      if (isset($this->name_space)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name_space));
      }
      if (isset($this->override)) {
        $res += 1;
        $res += $this->lengthString($this->override->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->item_count)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->item_count);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->name_space);
      }
      if (isset($this->override)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->override->byteSizePartial());
        $this->override->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setItemCount($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->item_count)) return 'item_count';
      if (isset($this->override) && (!$this->override->isInitialized())) return 'override';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasItemCount()) {
        $this->setItemCount($x->getItemCount());
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      if ($x->hasOverride()) {
        $this->mutableOverride()->mergeFrom($x->getOverride());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->item_count) !== isset($x->item_count)) return false;
      if (isset($this->item_count) && !$this->integerEquals($this->item_count, $x->item_count)) return false;
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (isset($this->override) !== isset($x->override)) return false;
      if (isset($this->override) && !$this->override->equals($x->override)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->item_count)) {
        $res .= $prefix . "item_count: " . $this->debugFormatInt32($this->item_count) . "\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      if (isset($this->override)) {
        $res .= $prefix . "override <\n" . $this->override->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\MemcacheGrabTailResponse {
  class Item extends \google\net\ProtocolMessage {
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function getFlags() {
      if (!isset($this->flags)) {
        return "0";
      }
      return $this->flags;
    }
    public function setFlags($val) {
      $this->flags = $val;
      return $this;
    }
    public function clearFlags() {
      unset($this->flags);
      return $this;
    }
    public function hasFlags() {
      return isset($this->flags);
    }
    public function clear() {
      $this->clearValue();
      $this->clearFlags();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      if (isset($this->flags)) {
        $res += 5;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->value);
      }
      if (isset($this->flags)) {
        $out->putVarInt32(29);
        $out->put32($this->flags);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 29:
            $this->setFlags($d->getFixed32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
      if ($x->hasFlags()) {
        $this->setFlags($x->getFlags());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      if (isset($this->flags) !== isset($x->flags)) return false;
      if (isset($this->flags) && !$this->integerEquals($this->flags, $x->flags)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      if (isset($this->flags)) {
        $res .= $prefix . "flags: " . $this->debugFormatFixed32($this->flags) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class MemcacheGrabTailResponse extends \google\net\ProtocolMessage {
    private $item = array();
    public function getItemSize() {
      return sizeof($this->item);
    }
    public function getItemList() {
      return $this->item;
    }
    public function mutableItem($idx) {
      if (!isset($this->item[$idx])) {
        $val = new \google\appengine\MemcacheGrabTailResponse\Item();
        $this->item[$idx] = $val;
        return $val;
      }
      return $this->item[$idx];
    }
    public function getItem($idx) {
      if (isset($this->item[$idx])) {
        return $this->item[$idx];
      }
      if ($idx >= end(array_keys($this->item))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\MemcacheGrabTailResponse\Item();
    }
    public function addItem() {
      $val = new \google\appengine\MemcacheGrabTailResponse\Item();
      $this->item[] = $val;
      return $val;
    }
    public function clearItem() {
      $this->item = array();
    }
    public function clear() {
      $this->clearItem();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->item);
      $res += 2 * sizeof($this->item);
      foreach ($this->item as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->item);
      foreach ($this->item as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addItem()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->item as $value) {
        if (!$value->isInitialized()) return 'item';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getItemList() as $v) {
        $this->addItem()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->item) !== sizeof($x->item)) return false;
      foreach (array_map(null, $this->item, $x->item) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->item as $value) {
        $res .= $prefix . "Item {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
