
 #!/bin/sh
 # the next line restarts using tclsh \
 exec tclsh "$0" "$@"

package require Gnocl

set table [gnocl::table -homogeneous 1]
$table addRow [list [gnocl::button -text "Exit" -onClicked exit] "" [gnocl::button -text "2"]]
$table addColumn [list [gnocl::button -text "3"] "" [gnocl::button -text "4"]]
$table add [gnocl::button -text "5"] 1 0 -rowSpan 3
$table add [gnocl::button \
	-text "Decorate" \
	-onClicked {
		if {[$win cget -decorated] == "1"} {
			$win configure -decorated 0
		} else {
			$win configure -decorated 1
		}
	} ] 2 1 -columnSpan 2


#-backgroundImage {EU_flag.jpg round200a.png}
set win [gnocl::window \
	-onDelete exit \
	-borderWidth 1 \
	-title "Bitmask Test" \
	-defaultWidth 200 \
	-defaultHeight 200 \
	-backgroundImage EU_flag.jpg \
	-mask round200a.png \
	-opacity 1 \
	-decorated 0 \
	-keepAbove 0 \
	-child $table \
	-x 200 \
	-y 200 \
	]

set box2 [gnocl::box]

set img [gnocl::image -image "%/button_play1.png" ]
set lab [gnocl::label -text LABEL ]

set ebut [gnocl::eventBox \
	-backgroundImage metal5.jpg \
	-onButtonPress {puts "Play Button Pressed"} \
	-child $img ]
	#-mask button_play1.png ]


$box2 add $ebut -fill {0 0} -expand 1

#

interp create a

interp eval a set win2 [gnocl::window \
	-backgroundImage {EU_flag.jpg round200a.png} \
	-onDelete exit \
	-borderWidth 0 \
	-title "Round Button" \
	-child $box2 \
	-onRealize  {puts  "%w realized"} \
	-defaultWidth 400 \
	-defaultHeight 100 \
	-keepAbove 0 \
	-x 400 \
	-y 00 \
	]



gnocl::mainLoop
