#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

 ##+##########################################################################
 #
 # xml.tcl -- Simple XML parser
 # by Keith Vetter, March 2004
 #

 namespace eval ::XML { variable XML "" loc 0}

 proc ::XML::Init {xmlData} {
    variable XML
    variable loc

    set XML [string trim $xmlData];
    regsub -all {<!--.*?-->} $XML {} XML	;# Remove all comments
    set loc 0
 }

 # Returns {XML|TXT|EOF|PI value attributes START|END|EMPTY}
 proc ::XML::NextToken {{peek 0}} {
    variable XML
    variable loc

    set n [regexp -start $loc -indices {(.*?)\s*?<(/?)(.*?)(/?)>} \
	       $XML all txt stok tok etok]
    if {! $n} {return [list EOF]}
    foreach {all0 all1} $all {txt0 txt1} $txt \
	{stok0 stok1} $stok {tok0 tok1} $tok {etok0 etok1} $etok break

    if {$txt1 >= $txt0} {		       ;# Got text
	set txt [string range $XML $txt0 $txt1]
	if {! $peek} {set loc [expr {$txt1 + 1}]}
	return [list TXT $txt]
    }

    set token [string range $XML $tok0 $tok1]   ;# Got something in brackets
    if {! $peek} {set loc [expr {$all1 + 1}]}
    if {[regexp {^!\[CDATA\[(.*)\]\]} $token => txt]} { ;# Is it CDATA stuff?
	return [list TXT $txt]
    }

    # Check for Processing Instruction <?...?>
    set type XML
    if {[regexp {^\?(.*)\?$} $token => token]} {
	set type PI
    }
    set attr ""
    regexp {^(.*?)\s+(.*?)$} $token => token attr

    set etype START			     ;# Entity type
    if {$etok0 <= $etok1} {
	if {$stok0 <= $stok1} { set token "/$token"} ;# Bad XML
	set etype EMPTY
    } elseif {$stok0 <= $stok1} {
	set etype END
    }
    return [list $type $token $attr $etype]
 }
 # ::XML::IsWellFormed
 #  checks if the XML is well-formed )http://www.w3.org/TR/1998/REC-xml-19980210)
 #
 # Returns "" if well-formed, error message otherwise
 # missing:
 #  characters: doesn't check valid extended characters
 #  attributes: doesn't check anything: quotes, equals, unique, etc.
 #  text stuff: references, entities, parameters, etc.
 #  doctype internal stuff
 #
 proc ::XML::IsWellFormed {} {
    set result [::XML::_IsWellFormed]
    set ::XML::loc 0
    return $result
 }
 ;proc ::XML::_IsWellFormed {} {
    array set emsg {
	XMLDECLFIRST "The XML declaration must come first"
	MULTIDOCTYPE "Only one DOCTYPE is allowed"
	INVALID "Invalid document structure"
	MISMATCH "Ending tag '$val' doesn't match starting tag"
	BADELEMENT "Bad element name '$val'"
	EOD "Only processing instructions allowed at end of document"
	BADNAME "Bad name '$val'"
	BADPI "No processing instruction starts with 'xml'"
    }

    # [1] document ::= prolog element Misc*
    # [22] prolog ::= XMLDecl? Misc* (doctypedecl Misc*)?
    # [27] Misc ::= Comment | PI | S
    # [28] doctypedecl ::= <!DOCTYPE...>
    # [16] PI ::= <? Name ...?>
    set seen 0				  ;# 1 xml, 2 pi, 4 doctype
    while {1} {
	foreach {type val attr etype} [::XML::NextToken] break
	if {$type eq "PI"} {
	    if {! [regexp {^[a-zA-Z_:][a-zA-Z0-9.-_:\xB7]+$} $val]} {
		#return [subst $emsg(BADNAME)]
	    }
	    if {$val eq "xml"} {		;# XMLDecl
		if {$seen != 0} { return $emsg(XMLDECLFIRST) }
		# TODO: check version number exist and only encoding and
		# standalone attributes are allowed
		incr seen		       ;# Mark as seen XMLDecl
		continue
	    }
	    if {[string equal -nocase "xml" $val]} {return $emsg(BADPI)}
	    set seen [expr {$seen | 2}]	 ;# Mark as seen PI
	    continue
	} elseif {$type eq "XML" && $val eq "!DOCTYPE"} { ;# Doctype
	    if {$seen & 4} { return $emsg(MULTIDOCTYPE) }
	    set seen [expr {$seen | 4}]
	    continue
	}
	break
    }

    # [39] element ::= EmptyElemTag | STag content ETag
    # [40] STag ::= < Name (S Attribute)* S? >
    # [42] ETag ::= </ Name S? >
    # [43] content ::= CharData? ((element | Reference | CDSect | PI | Comment) CharData?)*
    # [44] EmptyElemTag ::= < Name (S Attribute)* S? />
    #

    set stack {}
    set first 1
    while {1} {
	if {! $first} {			 ;# Skip first time in
	    foreach {type val attr etype} [::XML::NextToken] break
	} else {
	    if {$type ne "XML" && $type ne "EOF"} { return $emsg(INVALID) }
	    set first 0
	}

	if {$type eq "EOF"} break
	;# TODO: check attributes: quotes, equals and unique

	if {$type eq "TXT"} continue
	if {! [regexp {^[a-zA-Z_:][a-zA-Z0-9.-_:\xB7]+$} $val]} {
	    #return [subst $emsg(BADNAME)]
	}

	if {$type eq "PI"} {
	    if {[string equal -nocase xml $val]} { return $emsg(BADPI) }
	    continue
	}
	if {$etype eq "START"} {		;# Starting tag
	    lappend stack $val
	} elseif {$etype eq "END"} {	    ;# </tag>
	    if {$val ne [lindex $stack end]} { return [subst $emsg(MISMATCH)] }
	    set stack [lrange $stack 0 end-1]
	    if {[llength $stack] == 0} break    ;# Empty stack
	} elseif {$etype eq "EMPTY"} {	  ;# <tag/>
	}
    }

    # End-of-Document can only contain processing instructions
    while {1} {
	foreach {type val attr etype} [::XML::NextToken] break
	if {$type eq "EOF"} break
	if {$type eq "PI"} {
	    if {[string equal -nocase xml $val]} { return $emsg(BADPI) }
	    continue
	}
	return $emsg(EOD)
    }
    return ""
 }

 ################################################################
 #
 # Demo code
 #

set glade {<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<!DOCTYPE glade-interface SYSTEM "glade-2.0.dtd">
<!--Generated with glade3 3.0.2 on Tue Dec  5 20:08:42 2006 by user@chewy-->
<glade-interface>
  <widget class="GtkWindow" id="window">
    <property name="height_request">500</property>
    <property name="title" translatable="yes">File Browser</property>
    <signal name="destroy" handler="gtk_main_quit"/>
    <child>
      <widget class="GtkVBox" id="vbox">
        <property name="visible">True</property>
        <child>
          <widget class="GtkHandleBox" id="handlebox">
            <property name="visible">True</property>
            <child>
              <widget class="GtkToolbar" id="toolbar">
                <property name="visible">True</property>
                <property name="toolbar_style">GTK_TOOLBAR_BOTH</property>
                <property name="show_arrow">False</property>
                <child>
                  <widget class="GtkMenuToolButton" id="back">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-go-back</property>
                    <signal name="clicked" handler="on_back_clicked"/>
                  </widget>
                </child>
                <child>
                  <widget class="GtkMenuToolButton" id="forward">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-go-forward</property>
                    <signal name="clicked" handler="on_forward_clicked"/>
                  </widget>
                </child>
                <child>
                  <widget class="GtkSeparatorToolItem" id="separator">
                    <property name="visible">True</property>
                  </widget>
                </child>
                <child>
                  <widget class="GtkToolButton" id="up">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-go-up</property>
                    <signal name="clicked" handler="on_up_clicked"/>
                  </widget>
                </child>
                <child>
                  <widget class="GtkToolButton" id="refresh">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-refresh</property>
                    <signal name="clicked" handler="on_refresh_clicked"/>
                  </widget>
                </child>
                <child>
                  <widget class="GtkToolButton" id="home">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-home</property>
                    <signal name="clicked" handler="on_home_clicked"/>
                  </widget>
                </child>
                <child>
                  <widget class="GtkSeparatorToolItem" id="separator2">
                    <property name="visible">True</property>
                  </widget>
                </child>
                <child>
                  <widget class="GtkToolButton" id="delete">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-delete</property>
                    <signal name="clicked" handler="on_delete_clicked"/>
                  </widget>
                </child>
                <child>
                  <widget class="GtkToolButton" id="info">
                    <property name="visible">True</property>
                    <property name="stock_id">gtk-dialog-info</property>
                    <signal name="clicked" handler="on_info_clicked"/>
                  </widget>
                </child>
              </widget>
            </child>
          </widget>
          <packing>
            <property name="expand">False</property>
          </packing>
        </child>
        <child>
          <widget class="GtkHBox" id="hbox">
            <property name="visible">True</property>
            <property name="border_width">5</property>
            <property name="spacing">5</property>
            <child>
              <widget class="GtkLabel" id="label_location">
                <property name="visible">True</property>
                <property name="label" translatable="yes">&lt;b&gt;Current Location:&lt;/b&gt;</property>
                <property name="use_markup">True</property>
              </widget>
              <packing>
                <property name="expand">False</property>
              </packing>
            </child>
            <child>
              <widget class="GtkEntry" id="location">
                <property name="visible">True</property>
                <signal name="activate" handler="on_location_activate"/>
              </widget>
              <packing>
                <property name="position">1</property>
              </packing>
            </child>
            <child>
              <widget class="GtkButton" id="go">
                <property name="visible">True</property>
                <property name="relief">GTK_RELIEF_NONE</property>
                <signal name="clicked" handler="on_go_clicked"/>
                <child>
                  <widget class="GtkHBox" id="hbox2">
                    <property name="visible">True</property>
                    <property name="spacing">3</property>
                    <child>
                      <widget class="GtkImage" id="image">
                        <property name="visible">True</property>
                        <property name="stock">gtk-jump-to</property>
                      </widget>
                    </child>
                    <child>
                      <widget class="GtkLabel" id="label">
                        <property name="visible">True</property>
                        <property name="label" translatable="yes">Go</property>
                      </widget>
                      <packing>
                        <property name="position">1</property>
                      </packing>
                    </child>
                  </widget>
                </child>
              </widget>
              <packing>
                <property name="expand">False</property>
                <property name="position">2</property>
              </packing>
            </child>
          </widget>
          <packing>
            <property name="expand">False</property>
            <property name="position">1</property>
          </packing>
        </child>
        <child>
          <widget class="GtkScrolledWindow" id="scrolledwindow">
            <property name="visible">True</property>
            <property name="hscrollbar_policy">GTK_POLICY_AUTOMATIC</property>
            <property name="vscrollbar_policy">GTK_POLICY_AUTOMATIC</property>
            <child>
              <widget class="GtkTreeView" id="treeview">
                <property name="visible">True</property>
                <signal name="row_activated" handler="on_row_activated"/>
              </widget>
            </child>
          </widget>
          <packing>
            <property name="position">2</property>
          </packing>
        </child>
        <child>
          <widget class="GtkStatusbar" id="statusbar">
            <property name="visible">True</property>
          </widget>
          <packing>
            <property name="expand">False</property>
            <property name="position">3</property>
          </packing>
        </child>
      </widget>
    </child>
  </widget>
</glade-interface>
}


 set xml {<?xml version="1.0" encoding="ISO-8859-1"?>
    <loc version="1.0" src="Groundspeak">
    <waypoint>
    <name id="GCGPXK"><![CDATA[Playing Poker with the Squirrels by Rino 'n Rinette]]></name>
    <coord lat="40.1548166" lon="-82.5202833"/>
    <type>Geocache</type>
    <link text="Cache Details">http://www.geocaching.com/seek/cache_details.aspx?wp=GCGPXK</link>
    </waypoint><waypoint>
    <name id="GC19DF"><![CDATA[Great Playground Caper by Treasure Hunters Inc.]]></name>
    <coord lat="40.0667166666667" lon="-82.5358"/>
    <type>Geocache</type>
    <link text="Cache Details">http://www.geocaching.com/seek/cache_details.aspx?wp=GC19DF</link>
    </waypoint>
    </loc>
 }

#
# arguments
#	str		value string to be set
#
proc extractValue_2 {str} {
	#puts ">>> [lindex [split $str =] 1]"
	return [string trim [lindex [split $str =] 1] \"]
}

proc extractValue_1 {str} {
	#puts "<<< $str"
	#puts ">>> [lindex [split $str =] 2]"
	#return [string trim [lindex [split $str =] 1] \"]
}


# Build Gnocl UI based upon parsed string
# attr	current line from XML file
proc buildGui { val attr } {
	puts "val = $val"
	puts "attr = $attr"
	switch -exact $val {
		"widget" {
			set a [lindex $attr 0]
			set b [lindex $attr 1]
			puts "a = $a ; b = $b"
			switch $a {
				{class="GtkWindow"} {
					extractValue_2 $b
					set ::activeBuildWidget [gnocl::window -title [extractValue_2 $b]]
					}
				}
			}
		"property" {
					puts "HERE $attr"
			switch $attr {
				{name="height_request"} {

					extractValue_1 $attr
					$::activeBuildWidget configure -heightRequest 500 ;#[extractValue_1 $attr]
					}
				}
			}
		}

}




 # ::XML::Init $xml
 ::XML::Init $glade
 set wellFormed [::XML::IsWellFormed]
 if {$wellFormed ne ""} {
    puts "The xml is not well-formed: $wellFormed"
 } else {
    puts "The xml is well-formed"
    while {1} {
       foreach {type val attr etype} [::XML::NextToken] break
       puts "looking at: $type '$val' '$attr' '$etype'"

		buildGui $val $attr

       if {$type == "EOF"} break
    }
 }
