# text_dump.tcl
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

set title text_dump.tcl

package require Gnocl

proc applyTag {widget tagNames} {
	$widget tag apply selectionStart selectionEnd -tags $tagNames
}



set box [gnocl::box -orientation vertical]

set tbar [gnocl::toolBar]
$tbar add item -text "%#Bold" -onClicked { applyTag $txt bold}
$tbar add item -text "%#Italic" -onClicked {applyTag $txt italic}
$tbar add item -text "%#Underline" -onClicked {applyTag $txt underline}
$tbar add item -text "%#Strikethrough" -onClicked {applyTag $txt strikethrough}
$tbar add item -text "%#Find" -onClicked {
	foreach {a b} [$txt search bodhi -tags {SEARCH underline}] {
		puts "$a $b"
		}
	foreach {a b} [$txt search gate -tags {bold }] {
		puts "$a $b"
		}
	foreach {a b} [$txt search svaha ] {
		puts "$a $b"
		}
	}
$tbar add item -text "%#FindAndReplace" -onClicked {
	puts "replaced [$txt replace bodhi prajna] incidences\n"
	}

$tbar add item -text "DUMP" -onClicked {
	#puts "DUMP TO BE IMPLEMENTED"
	# puts [$txt dump] ;# error checking works!
	#puts [$txt dump text start end] ;# text dump works
	foreach {a b}  [$txt dump tags start end] {
		 ;# tag dump works
		 puts "tag: $a  attributes: $b"
	 }
	}


proc zoomText {widget state direction fontSize} {

	if {$state == "1"} {
		switch $direction {
			up { incr fontSize }
			down { if {$fontSize != "8"} { incr fontSize -1 } }
			default { break }
		}
		$widget configure -baseFont [list Gentium $fontSize]
	}
	return $fontSize
}

set fontSize 14

set txt [gnocl::text \
	-baseFont [list Gentium $fontSize] \
	-onButtonPress { #puts "w %w t %t b %b s %s x %x y %y X %X Y %Y"} \
	-onButtonRelease { #puts "w %w t %t b %b s %s x %x y %y X %X Y %Y"} \
	-onScroll {
		#puts "w %w t %t %y x %x y %y X %X Y %Y s %s d %d"
		set fontSize [zoomText %w %s %d $fontSize]
		} ]

$txt tag create SEARCH -background  yellow

if {1} {
$txt tag create bold -fontWeight bold
$txt tag create italic -fontStyle italic
$txt tag create underline -underline single
$txt tag create strikethrough -strikethrough 1
}

$box add $tbar
$box add $txt -fill {1 1 } -expand 1

for {set i 0} {$i < 10} {incr i} {
	$txt insert end "gate gate paragate parasamgate bodhi svaha\n"
}

set win [gnocl::window -title $title -child $box ]

gnocl::mainLoop

