#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

set lastLine ""

proc insertCursor {w  l} {

	if {[$w getCursor] != $l } {
   		set l [$w getCursor]
   		set a [lindex $l 0]
#   		$w tag remove "0 0" end -tags {cursor}
#		set lineEnd "$a [$w getLineLength $l]"
#		$w tag apply "$a 0" $lineEnd -tags {cursor}
#   	$w tag apply cursor sentenceStart -tags cursor
#		$w tag apply cursor sentenceEnd -tags cursor
# Because keywords positions are determined from the widget iterator and not arguments,
# some more fanciful uses of the keywords can be used.
		$w tag apply "$a 0" sentenceEnd -tags cursor

   } else {
   		set l 0
   }

   # return last position of the cursor
   return $l
}

proc wordstart { w } {
	global txt
	puts "worsdStart $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply $l wordStart -tags wordStart
}

proc wordend { w } {
	global txt
	puts "wordEnd $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply $l wordEnd -tags wordEnd

}

proc sentencestart { w } {
	global txt
	puts "sentenceStart $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply $l sentenceStart -tags sentenceStart
}

proc sentenceend { w } {
	global txt
	puts "sentenceEnd $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply $l sentenceEnd -tags sentenceEnd
}

proc wholeword { w } {
	global txt
	puts "wholeWord $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply $l wordStart -tags wholeWord
	$txt tag apply $l wordEnd -tags wholeWord
}


proc wholesentence { w } {
	global txt
	puts "wholeSentence $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply $l sentenceStart -tags wholeSentence
	$txt tag apply $l sentenceEnd -tags wholeSentence
}

proc word { w } {
	global txt
	puts "word $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply wordStart wordEnd -tags wholeWord
}


proc sentence { w } {
	global txt
	puts "wholeSentence $w [$txt getCursor]"
	set l [$txt getCursor]
	$txt tag apply sentenceStart sentenceEnd -tags wholeSentence
}


set box1 [gnocl::box]
set but1 [gnocl::button -text wordStart -onClicked {wordstart %w}]
set but2 [gnocl::button -text wordEnd -onClicked {wordend %w}]
set but3 [gnocl::button -text sentenceStart -onClicked {sentencestart %w}]
set but4 [gnocl::button -text sentenceEnd -onClicked { sentenceend %w}]
set but5 [gnocl::button -text wholeword -onClicked { wholeword %w}]
set but6 [gnocl::button -text wholesentence -onClicked { wholesentence %w}]
set but7 [gnocl::button -text word -onClicked { word %w}]
set but8 [gnocl::button -text sentence -onClicked { sentence %w}]

set but8 [gnocl::button -text all -onClicked { $txt tag apply { 1 0 } end -tags all } ]
set but9 [gnocl::button -text AddLine -onClicked { $txt insert end "HOW NOW BROWN COW.\n" } ]


for {set i 1} {$i <= 9} {incr i} {
	$box1 add [set but$i]
}

set box2 [gnocl::box -orientation vertical]
set txt [gnocl::text]


$txt configure -onButtonRelease {
   set lastLine [insertCursor %w $lastLine]
   }

$txt configure -onKeyRelease {
   set lastLine [insertCursor %w $lastLine]
   }

$txt configure -onKeyPress {
   %w tag remove "0 0" end -tags {cursor}
   }

$txt configure -onButtonPress {
   %w tag remove "0 0" end -tags {cursor}
   }


$txt tag create blue -foreground blue
$txt tag create cursor -underline single -foreground red


# create some tags
$txt tag create wordStart -foreground red
$txt tag create wordEnd -foreground green
$txt tag create sentenceStart -foreground blue
$txt tag create sentenceEnd -foreground cyan
$txt tag create wholeWord -foreground magenta
$txt tag create wholeSentence -foreground yellow

$txt tag create all -background blue

$box2 add $box1 -fill {1 0}
$box2 add $txt -fill {1 1} -expand 1

gnocl::window -title "Cursor Keywords" -child $box2 -onDelete { exit }

set i 0

while { $i < 6 } {
	puts $i
	# $txt insert "How now brown cow. The quick brown fox jumps over the lazy dog.\n"
	incr i
}

gnocl::mainLoop
