# printTest.tcl

#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

if {1} {
 set box [gnocl::box -orientation vertical]
 set toolbar [gnocl::toolBar]
 $toolbar add item -text "%#Print" -onClicked {gnocl::print print b}
 $toolbar add item -text "Print File" -onClicked {gnocl::print file b}
 $toolbar add item -text "Print Preview" -onClicked {gnocl::print preview b}
 set txt [gnocl::text]
 $box add $toolbar
 $box add $txt -fill {1 1} -expand 1
 set top1 [gnocl::window -child $box]
} else {

 set img [gnocl::image]
 set top2 [gnocl::window -title "pixBuf tests" -child $img]
 $img configure -image "%/EU_flag.jpg"

 set buf1 [gnocl::pixBuf -file EU_flag.jpg]
 set buf2 [gnocl::pixBuf -new $img]
 set buf3 [gnocl::pixBuf -from $img]
 set buf4 [gnocl::pixBuf -data $img]
 set buf5 [gnocl::pixBuf -copy $img]


 puts "top2 = $top2"
 puts "buf1 = $buf1"
 puts "buf2 = $buf2"
 puts "buf3 = $buf3"
 puts "buf4 = $buf4"
 puts "buf5 = $buf5"

 $buf1
 # gnocl::bitMap _WID
}

gnocl::mainLoop
