#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl


# http://wiki.tcl.tk/3919
proc xml2list xml {
     regsub -all {>\s*<} [string trim $xml " \n\t<>"] "\} \{" xml
     set xml [string map {> "\} \{#text \{" < "\}\} \{"}  $xml]

     set res ""   ;# string to collect the result
     set stack {} ;# track open tags
     set rest {}
     foreach item "{$xml}" {
	 switch -regexp -- $item {
	    ^# {append res "{[lrange $item 0 end]} " ; #text item}
	    ^/ {
		regexp {/(.+)} $item -> tagname ;# end tag
		set expected [lindex $stack end]
		if {$tagname!=$expected} {error "$item != $expected"}
		set stack [lrange $stack 0 end-1]
		append res "\}\} "
	  }
	    /$ { # singleton - start and end in one <> group
	       regexp {([^ ]+)( (.+))?/$} $item -> tagname - rest
	       set rest [lrange [string map {= " "} $rest] 0 end]
	       append res "{$tagname [list $rest] {}} "
	    }
	    default {
	       set tagname [lindex $item 0] ;# start tag
	       set rest [lrange [string map {= " "} $item] 1 end]
	       lappend stack $tagname
	       append res "\{$tagname [list $rest] \{"
	    }
	 }
	 if {[llength $rest]%2} {error "att's not paired: $rest"}
     }
     if [llength $stack] {error "unresolved: $stack"}
     string map {"\} \}" "\}\}"} [lindex $res 0]
 }

#---- Now that this went so well, I'll throw in the converse:

 proc list2xml list {
    switch -- [llength $list] {
	2 {lindex $list 1}
	3 {
	    foreach {tag attributes children} $list break
	    set res <$tag
	    foreach {name value} $attributes {
		append res " $name=\"$value\""
	    }
	    if [llength $children] {
		append res >
		foreach child $children {
		    append res [list2xml $child]
		}
		append res </$tag>
	    } else {append res />}
	}
	default {error "could not parse $list"}
    }
 }
 #-------------------------------------------- now testing:
 set test {<foo a="b">bar and<grill x:c="d" e="f g"><baz x="y"/></grill><room/></foo>}
 proc tdomlist x {[[dom parse $x] documentElement root] asList} ;# reference
 proc lequal {a b} {
    if {[llength $a] != [llength $b]} {return 0}
    if {[lindex $a 0] == $a} {return [string equal $a $b]}
    foreach i $a j $b {if {![lequal $i $j]} {return 0}}
    return 1
 }
 proc try x {
    puts [set a [tdomlist $x]]
    puts [set b [xml2list $x]]
    puts list:[lequal $a $b],string:[string equal $a $b]
 }
 puts [set res [xml2list $test]]

if {0} {

set gladeFilename "TopLevel.glade"
set fp [open $gladeFilename "r"]

set xml [read $fp]
close $fp

puts $xml
puts [set res [xml2list $xml] ]
}
