 # dateEntry.tcl
 #!/bin/sh
 # the next line restarts using tclsh \
 exec tclsh "$0" "$@"

 package require Gnocl

 # Procedure to get spinbox to display correct date:
 proc datespin {way w} {
        # set datoa [$w get]
		set datoa [$w cget -value]
        set oldsecs [clock scan $datoa -format {%Y/%m/%d}]
        if {$way eq "up"} {
                set newsecs [clock add $oldsecs 1 day]
        } else {
                set newsecs [clock add $oldsecs "-1" day]
        }
        set datoa [clock format $newsecs -format {%Y/%m/%d}]
        # $w set $datoa
		$w configure -value $datoa
  }

#----------------
# datespinner using eventboxes to create vertical spinbuttons
#----------------
proc dateSpinner { date variable {state 1}} {
  set dateEntry [gnocl::entry \
  	-value $date \
	-variable $variable \
	-editable $state \
	-widthChars 10]

  set upArrow [gnocl::image -image "%/upArrow.png"]
  set downArrow [gnocl::image -image "%/downArrow.png"]

  set up [gnocl::eventBox \
    -background black \
  	-child $upArrow \
	-data $dateEntry \
	-onButtonPress {
		set _tmp_ [%w cget -child]
		$_tmp_ configure -image "%/upArrow_shade.png"
		datespin "up" [%w cget -data ] } \
	-onButtonRelease {
		$_tmp_ configure -image "%/upArrow.png"
		unset _tmp_ } ]

  set down [gnocl::eventBox \
  	-child $downArrow \
	-data $dateEntry \
	-onButtonPress {
		set _tmp_ [%w cget -child]
		$_tmp_ configure -image "%/downArrow_shade.png"
		datespin "down" [%w cget -data ] } \
	-onButtonRelease {
		$_tmp_ configure -image "%/downArrow.png"
		unset _tmp_ } ]

  set box [gnocl::box \
  	-orientation vertical \
	-spacing 0 \
	-padding 0 \
	-borderWidth 0 \
	-align left]

  $box add [list $up $down] -fill {0 0} -expand 0

  # container for all items
  set dateSpinner [gnocl::box -borderWidth 0 -padding 0 -spacing 0]
  $dateSpinner add [list $dateEntry $box] -fill {0 0} -expand 0

  return $dateSpinner
}

 gnocl::window -child [dateSpinner "2009/03/06" ::date 0]

set list [gnocl::list \
	-titles {"bool" "string" "string" "string" "string"} \
	-types {boolean string string string string} ]

$list add {{0 "list" -104 1.45} {0 "window" "" 9.58}}
$list add {{0 "list" -104 1.45} {0 "window" "" ""}}

$list cellConfigure 0 0 -value 1
$list cellConfigure 0 1 -value WJG
$list cellConfigure 0 3 -value 1956.07

$list cellConfigure 3  0 -value 1
$list cellConfigure 3  1 -value LXY
$list cellConfigure 3  3 -value 1964.10

$list columnConfigure 2 -onCellData "setColor %v"

proc setColor { val } {
   if { $val < 0 } {
      return "-foreground red"
   }
   return "-foreground blue"
}

gnocl::window -title "List" -child $list -defaultWidth 300 -defaultHeight 300


set txt [gnocl::text \
	-onEnter {
		%w configure -cursorVisible 1} \
	-onLeave {
		%w configure -cursorVisible 0 }]

gnocl::window -title "List" -child $txt -defaultWidth 300 -defaultHeight 300


gnocl::mainLoop
