 # dateEntry.tcl
 #!/bin/sh
 # the next line restarts using tclsh \
 exec tclsh "$0" "$@"

 package require Gnocl

 # Procedure to get spinbox to display correct date:
 proc datespin {way w} {
        # set datoa [$w get]
		set datoa [$w cget -value]
        set oldsecs [clock scan $datoa -format {%Y/%m/%d}]
        if {$way eq "up"} {
                set newsecs [clock add $oldsecs 1 day]
        } else {
                set newsecs [clock add $oldsecs "-1" day]
        }
        set datoa [clock format $newsecs -format {%Y/%m/%d}]
        # $w set $datoa
		$w configure -value $datoa
  }

 # Create our own entry spinner as gnocl::spinBox only supports ints and floats
 proc dateSpinner { date variable {state 1}} {
  set dateEntry [gnocl::entry -value $date -variable $variable -editable $state -widthChars 10]
  set upArrow [gnocl::arrowButton -width 20 -arrow up -relief half -data $dateEntry -onClicked {datespin "up" [%w cget -data ] }]
  set downArrow [gnocl::arrowButton -width 20 -arrow down -relief half -data $dateEntry -onClicked {datespin "up" [%w cget -data ]  }]
  set dateSpinner [gnocl::box -borderWidth 0 -padding 0 -spacing 0]
  $dateSpinner add [list $dateEntry $upArrow $downArrow] -fill {0 0} -expand 0
  return $dateSpinner
}


 # Create our own entry spinner as gnocl::spinBox only supports ints and floats
 proc dateSpinner2 { date variable {state 1}} {
  set dateEntry [gnocl::entry -value $date -variable $variable -editable $state -widthChars 10]
  set box [gnocl::box -orientation vertical -padding 0 -borderWidth 0 -spacing 0]
  set upArrow [gnocl::button -text ^ -widthRequest 20 -heightRequest 15  -relief none -data $dateEntry -onClicked {datespin "up" [%w cget -data ] }]
  set downArrow [gnocl::button -text V -widthRequest 20  -heightRequest 15  -relief none -data $dateEntry -onClicked {datespin "up" [%w cget -data ]  }]
  $box add [list $upArrow $downArrow] -fill {0 1} -expand 0
  set dateSpinner [gnocl::box -borderWidth 0 -padding 0 -spacing 0]
  $dateSpinner add [list $dateEntry $box] -fill {0 0} -expand 0
  return $dateSpinner
}

 gnocl::window -child [dateSpinner2 "2009/03/06" ::date 0]

proc dateSpinner3 { date variable {state 1}} {
  set dateEntry [gnocl::entry -value $date -variable $variable -editable $state -widthChars 10]

  set upArrow [gnocl::image -image "%/upArrow.png"]
  set downArrow [gnocl::image -image "%/downArrow.png"]

  set up [gnocl::eventBox \
    -background black \
  	-child $upArrow \
	-data $dateEntry \
	-onButtonPress {
		set _tmp_ [%w cget -child]
		$_tmp_ configure -image "%/upArrow_shade.png"
		datespin "up" [%w cget -data ] } \
	-onButtonRelease {
		$_tmp_ configure -image "%/upArrow.png"
		unset _tmp_ } ]
  set down [gnocl::eventBox \
  	-child $downArrow \
	-data $dateEntry \
	-onButtonPress {
		set _tmp_ [%w cget -child]
		$_tmp_ configure -image "%/downArrow_shade.png"
		datespin "down" [%w cget -data ] } \
	-onButtonRelease {
		$_tmp_ configure -image "%/downArrow.png"
		unset _tmp_ } ]


  set box [gnocl::box -orientation vertical -spacing 0 -padding 0 -borderWidth 0 -align left]
  $box add [list $up $down] -fill {0 0} -expand 0

  set dateSpinner [gnocl::box -borderWidth 0 -padding 0 -spacing 0]
  $dateSpinner add [list $dateEntry $box] -fill {0 0} -expand 0
  return $dateSpinner
}

 gnocl::window -child [dateSpinner3 "2009/03/06" ::date 0]



 gnocl::mainLoop


