# test-text-1.tck
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

namespace eval ::static {}
proc static {name {value ""}} {
    set caller [lindex [info level -1] 0]
    namespace eval ::static::$caller {}
    set qname ::static::${caller}::$name
    if {![info exists $qname]} {set $qname $value}
    uplevel 1 [list upvar #0 $qname $name]
} ;#RS http://wiki.tcl.tk/1532


proc clipBoard_details {w t l s op c} {
	switch [string tolower $op] {
		cut -
		copy -
		paste {puts "$w $t $s $op $c"}
		default {}
	}
}

set txt1 [gnocl::text \
	-onKeyPress {puts "KeyPress"} \
	-onKeyRelease {puts "KeyRelease"} \
	-onButtonPress {puts "ButtonPress"} \
	-onButtonRelease {puts "ButtonRelease"} \
	-onMotion { $bar push "%x %y"} \
	-onCopy {
		# how much was copied?
		puts "copied [%w getSelectionBounds]"
		clipBoard_details %w %t %l %s copy [%w getCursor]
		} \
	-onCut {
		# how much was copied?
		puts "cut [%w getSelectionBounds]"
		clipBoard_details %w %t %l %s cut [%w getCursor]
		} \
	-onPaste {
		# how much was copied?
		puts "pasted [%w getSelectionBounds]"
		clipBoard_details %w %t %l %s paste [%w getCursor]
		} \
	-onSelectAll {puts "selectAll %w %t"} \
	-onInsertText {puts "InsertText %w" } \
	]

#	-dropTargets {puts droptTarget}
#	-dragTargets {puts dragTargets}
#	-onToggleOverwrite {puts onToggleOverwrite}
#	-onScrollAdjustments {puts onScrollAdjustments}
#	-onSetAnchor {puts onSetAnchor}
#   -onSelectAll {puts onSelectAll}
# 	-onPopulatePopup {puts onPopulatePopup} 
#  	-onPageHorizontally {puts onPageHorizontally}
#	-onMoveFocus {puts onMoveFocus}
#   -onMoveCursor {puts onMoveCursor}
#	-onInsertAtCursor {puts onInserAtCursor}
#	-onDeleteFromCursor {puts onDeleteFromCursor}
#	-onBackSpace {puts BackSpace}
#	-onMoveCursor {puts "MoveCursor"}

$txt1 configure -baseColor #ffffdd
$txt1 configure -baseFont "Andika 15"
set bar [gnocl::statusBar]
set box [gnocl::box -orientation vertical -borderWidth 2 -shadow in -fill {1 1} -expand 1]
$box add $txt1 -fill {1 1} -expand 1
$box add $bar
set win [gnocl::window -title "Test-Text-1a" -child $box -onDestroy {exit} ]

gnocl::mainLoop
