# text_dump.tcl
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

# http://wiki.tcl.tk/1011


package require GnoclCanvas

namespace eval clock {
 set halfpi  1.570796
 set piover6 0.5235987
 set twopi   6.283185
}


proc Clock { {s 1} } {

if {$s} {
	set clockFace [gnocl::canvas -width 200 -height 200]
	$clockFace create image -image "%/./clock200.png"
} else {
	set clockFace [gnocl::canvas -width 150 -height 150]
	$clockFace create image -image "%/./clock150.png"
}


	proc clock::hands {w s} {
    	catch { $w itemDelete hands }

    	# Compute seconds since midnight
    	set t [expr { [clock seconds] - [clock scan 00:00:00] }]

		if {$s} {
		set sh 70
		set mh 60
		set hh 40

		set c 100
	} else {
		set sh 52
		set mh 45
		set hh 30

		set c 75
	}

    	# Hour hand
    	set angle [expr { $t * $clock::twopi / 60. / 60. / 12. }]
    	set y [expr { $c - $hh * cos($angle) }]
    	set x [expr { $c + $hh * sin($angle) }]
    	$w create line -coords [list $c $c $x $y] -pixelWidth 3 -capStyle projecting -tags hands -fill white
		#$w create ellipse -fill yellow -centerRadius 0 -coords [list 92 92  108 108]

    	# Minute hand
    	set angle [expr { $t * $clock::twopi / 60. / 60. }]
    	set y [expr { $c - $mh * cos($angle) }]
    	set x [expr { $c + $mh * sin($angle) }]
    	$w create line -coords [list $c $c $x $y] -pixelWidth 3 -capStyle projecting -tags  hands -fill white
		#$w create ellipse -fill white -centerRadius 0 -coords [list 94 94  106 106]

    	# Angle of second hand
    	set angle [expr { $t * $clock::twopi / 60. }]
    	set y [expr { $c - $sh * cos($angle) }]
    	set x [expr { $c + $sh* sin($angle) }]
    	$w create line -coords [list $c $c $x $y] -pixelWidth 2 -tags hands -fill #7A7AE1
		# $w create ellipse -fill white -centerRadius 0 -coords [list 95 95  105 105]

    	after 1000 clock::hands $w $s

 }

clock::hands $clockFace $s
return $clockFace
}

set decorate 0
set menu [gnocl::menu -title "GnoclClock" -tearoff 0]
$menu add [gnocl::menuCheckItem -text "Decorated" -variable decorate -onToggled {$main configure -decorated $decorate}]
$menu add [gnocl::menuItem -text "Quit" -onClicked exit]

# set shadow [gnocl::window \
	-mask clock170_mask.png \
	-backgroundImage clock170_mask.png \
	-opacity 0.25 \
	-decorated $decorate \
	-x 1390 -y 40 \
	-keepAbove 0 \
	-widthRequest 170 \
	-heightRequest 170 \
	-onButtonPress { $menu popup }]

set main [gnocl::window \
	-child [ Clock 0] \
	-backgroundColor black \
	-decorated $decorate \
	-opacity 0.9 \
	-x 1400 -y 50 \
	-keepAbove 0 \
	-widthRequest 150 \
	-heightRequest 150 \
	-onButtonPress { $menu popup }]

if {1} {
$main configure -mask clock150.png
}


gnocl::mainLoop
