/**
 \brief
  This module implements the gnocl::sourceView widget.
 \authors
  Peter G. Baum, William J Giddings
 \date 2001-03:
*/

/* user documentation */

/**
  \page page53 gnocl::sourceView
  \section sec gnocl::sourceView
  Implementation of gnocl::sourceView
  \subsection subsection1 Implemented Options
  \verbatim

  \endverbatim
  \subsection subsection2 Implemented Commands
  \verbatim

  \endverbatim
  \subsection subsection3 Sample Tcl Script
  \code
   set box [gnocl::box -buttonType 1]
   $box add [gnocl::button -text "%_Do_n't save" -icon "%#No"]
   $box add [gnocl::button -text "%#Cancel"]
   $box add [gnocl::button -text "%#Save"]
   gnocl::window -title "Buttons" -child $box
  \endcode
  \subsection subsection4 Produces
  \image html "../pics/sourceView.png"
*/

http://library.gnome.org/devel/gtksourceview/stable/GtkSourceView.html
* /

/*
 * options
 * defined in sourceview.c
 *
 * -autoIdent
 * -highlightCurrentLine
 * -insertSpace
 * -margin
 * -showLineMarkers
 * -showLineNumbers
 * -smartHomeEnd
 * -tabsWidth
 */


#include "gnoclSourceView.h"



/****f* gnocl/sourceView/GnoclSourceView_Init
 * AUTHOR
 *	William J Giddings
 * NOTES
 *	The Gnocl initilisation proceedure. It is necessary to end the name of this function
 *	with "_Init" in order to initialise a shared library. This function will be automatically
 *	called when the Tcl load command loads the library.
 * SEE ALSO
 *  Welch, Jones & Hobbs (2003) pp695-699
 * SOURCE
 */
int Gnoclsourceview_Init ( Tcl_Interp *interp )
{

	printf ( "Initializing gnocl sourceView version %s\n", VERSION );

	if ( Tcl_InitStubs ( interp, "8.3", 0 ) == NULL )
		return TCL_ERROR;

	if ( Tcl_PkgRequire ( interp, "Gnocl", VERSION, 0 ) == NULL )
		return TCL_ERROR;

	if ( Tcl_PkgProvide ( interp, "GnoclSourceView", VERSION ) != TCL_OK )
		return TCL_ERROR;

	/* gnoclSourceViewCmd is located in sourceview.c */
	Tcl_CreateObjCommand ( interp, "gnocl::sourceView", gnoclSourceViewCmd, NULL, NULL );

	return TCL_OK;
}

/*****/

