/****h* pixBuf/pixbuf.c
 * NAME
 *  pixbuf.c
 * DESCRIPTION
 *  Create a tcl wrapper around Gtk/Gdk library functions which are used
 *  for the creation and manipulation of image data.
 * AUTHOR
	William J Giddings
 * CREATION DATE
 *  04-03-09
 * PURPOSE
 * USAGE
 * PARAMETERS
 * COMMANDS
 *   Drawing Commands
 *     line {list..}
 *     lines
 *     point
 *     points  {list..}
 *     segments
 * 	   rectangles
 *     arc
 *     polygon
 *     trapezoids
 *     glyph
 *     layoutLine
 *     string
 *     text
 *     get
 *     copy
 *   Image Manipulation
 * OPTIONS
 *  -file ??filename??
 *    Create a pixbuf/pixmap from diskbase image
 *  -new {width height}
 *    Allocate memory for the creation of a empty pixbuf/pixmap ready for direct drawing.
 *  -from ??widgetid??
 *    Create a pixbuf/pixmap from any GtkDrawable widget
 *  -data {string}
 *    Create a pixbuf/pixmap from a string of data.
 *  -copy ??widgetid??
 *    Make a copy of an existing pixbuf/pixmap object.
 * EXAMPLE
 * FUNCTION
 * NOTES
 * BUGS
 * SEE ALSO
 * USES
 * USED BY
 * MODIFICATION HISTORY
 * TODO
 * SOURCE
 *****
 */

#include "gnocl.h"

/****v* pixbuf/staticsVars
 * AUTHOR
 *	William J Giddings
 * CREATION DATE
 *	05-MAR-09
 * USAGE
 *	how this function is used
 * ARGUMENTS
 * RETURN VALUE
 * NOTES
 * TODO
 * USES
 * USED BY
 * MODIFICATION HISTORY
 * SOURCE
 */
static GHashTable *name2pixbufList;
static const char idPrefix[] = "::gnocl::_PIXBUF";

/*****/

/****f* pixBuf/gnoclPixBuffCommand
 * NAME
 *	gnoclPixBuffCommand
 * PURPOSE
 *  Create a pixbuf object.
 * AUTHOR
 *	William J Giddings
 * CREATION DATE
 *	04-Mar-09
 * USAGE
 *	how this function is used
 * ARGUMENTS
 * COMMANDS
 * OPTIONS
 * RETURN VALUE
 * NOTES
 * 	There may be some overlap with features already implemented, e.g. class.
 * TODO
 * USES
 * USED BY
 * MODIFICATION HISTORY
 *  04-03-09
 * SOURCE
 */
int gnoclPixBuffCommand (
	GdkPixbuf *pixbuf,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj *  const objv[],
	int cmdNo,
	int isPixBuffer )
{
	g_print ( "gnoclPixBuffCommand\n" );
	return TCL_OK;
}


/****f* pixBuf/gnoclPixBuffCmd
 * NAME
 *	gnoclPixBuffCmd
 * PURPOSE
 *  Create a pixbuf object.
 * AUTHOR
 *	William J Giddings
 * CREATION DATE
 *	04-Mar-09
 * USAGE
 *	how this function is used
 * ARGUMENTS
 * COMMANDS
 * OPTIONS
 * RETURN VALUE
 * NOTES
 * 	There may be some overlap with features already implemented, e.g. class.
 * TODO
 * USES
 * USED BY
 * MODIFICATION HISTORY
 *  04-03-09
 * SOURCE
 */

int gnoclPixBufCmd (
	ClientData data,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj * const objv[] )
{
	static const char *cmd[] =
	{
		"-file", "-new", "-from", "-data", "-copy", NULL
	};
	enum optIdx { FileIdx, NewIdx, FromIdx, DataIdx, CopyIdx };
	int idx;

	if ( objc <= 2 )
	{
		Tcl_WrongNumArgs ( interp, 1, objv, "command ??option?? ??val??" );
		return TCL_ERROR;
	}

	if ( Tcl_GetIndexFromObj ( interp, objv[1], cmd, "print", TCL_EXACT, &idx ) != TCL_OK )
	{
		return TCL_ERROR;
	}

	g_print ( "objc = %d opt = %s  id = %s\n", objc, Tcl_GetString ( objv[1] ), Tcl_GetString ( objv[2] ) );

	switch ( idx )
	{
		case FileIdx:
			{
				g_print ( "Open File: %s\n", Tcl_GetString ( objv[2] )  );

				GError *error = NULL;
				GdkPixbuf * pixbuf = gdk_pixbuf_new_from_file ( Tcl_GetString ( objv[2] ), &error );

				if ( error != NULL )
				{
					g_warning ( "%s", error->message );
					g_error_free ( error );
					return NULL;
				}

				return  gnoclRegisterPixbuf ( interp, pixbuf, gnoclPixBuffCommand );

			}

			break;
		case NewIdx:
			{
				g_print ( "Create New Pixbuf using parameters: %s\n", Tcl_GetString ( objv[2] )  );
				GError *error = NULL;

				// GdkPixmap *pixmap gdk_pixmap_new (GdkDrawable *drawable, gint width, gint height, gint depth);


				GdkPixbuf * pixbuf = gdk_pixbuf_new_from_file ( Tcl_GetString ( objv[2] ), &error );

				if ( error != NULL )
				{
					g_warning ( "%s", error->message );
					g_error_free ( error );
					return NULL;
				}

				return  gnoclRegisterPixbuf ( interp, pixbuf, gnoclPixBuffCommand );
			}

			break;
			/*
			http://library.gnome.org/devel/gdk/stable/gdk-Pixbufs.html#gdk-pixbuf-get-from-drawable
			*/
		case FromIdx:
			{
				g_print ( "Creat pixbuf from widget: %s\n", Tcl_GetString ( objv[2] )  );
				GError *error = NULL;
				/*
				 * GdkPixbuf * pixbuf = gdk_pixbuf_new_from_file ( Tcl_GetString ( objv[2] ), &error );
				 */

				GdkPixbuf *pixbuf = NULL;
				GdkPixbuf *src = NULL;
				GdkColormap *cmap = NULL;
				int src_x, src_y, dest_x, dest_y, width, height;

				pixbuf = gdk_pixbuf_get_from_drawable ( pixbuf, src, cmap, src_x, src_y, dest_x, dest_y, width, height );

				if ( pixbuf == NULL )
				{
					g_warning ( "%s", error->message );
					g_error_free ( error );
					return NULL;
				}

				return  gnoclRegisterPixbuf ( interp, pixbuf, gnoclPixBuffCommand );
			}

			break;
		case DataIdx:
			{
				g_print ( "Creat pixbuf using data: %s\n", Tcl_GetString ( objv[2] )  );
				GError *error = NULL;
				GdkPixbuf * pixbuf = gdk_pixbuf_new_from_file ( Tcl_GetString ( objv[2] ), &error );

				if ( error != NULL )
				{
					g_warning ( "%s", error->message );
					g_error_free ( error );
					return NULL;
				}

				return  gnoclRegisterPixbuf ( interp, pixbuf, gnoclPixBuffCommand );
			}

			break;
		case CopyIdx:
			{
				g_print ( "Copy Pixbuf from: %s\n", Tcl_GetString ( objv[2] )  );
				GError *error = NULL;
				GdkPixbuf * pixbuf = gdk_pixbuf_new_from_file ( Tcl_GetString ( objv[2] ), &error );

				if ( error != NULL )
				{
					g_warning ( "%s", error->message );
					g_error_free ( error );
					return NULL;
				}

				return  gnoclRegisterPixbuf ( interp, pixbuf, gnoclPixBuffCommand );
			}

			break;
	}

	return TCL_OK;

}

/*****/

/****f* pixBuf/gnoclBitMapCmd
 * NAME
 *	gnoclBitMapCmd
 * PURPOSE
 *  Load and manipulate bitMap files.
 * AUTHOR
 *	William J Giddings
 * CREATION DATE
 *	04-Mar-09
 * USAGE
 *	how this function is used
 * ARGUMENTS
 * RETURN VALUE
 * NOTES
 * 	There may be some overlap with features already implemented, e.g. class.
 * TODO
 * USES
 * USED BY
 * MODIFICATION HISTORY
 *  04-03-09
 * SOURCE
 */






int gnoclBitMapCmd (
	ClientData data,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj * const objv[] )
{
	static const char *cmd[] = { "print", "file", "preview", NULL };
	enum optIdx { PrintIdx, FileIdx, PreviewIdx };
	int idx;

	if ( objc != 3 )
	{
		Tcl_WrongNumArgs ( interp, 1, objv, "option widgetid " );
		return TCL_ERROR;
	}

	if ( Tcl_GetIndexFromObj ( interp, objv[1], cmd, "print", TCL_EXACT, &idx ) != TCL_OK )
	{
		return TCL_ERROR;
	}

	g_print ( "objc = %d opt = %s  id = %s\n", objc, Tcl_GetString ( objv[1] ), Tcl_GetString ( objv[2] ) );

	switch ( idx )
	{
		case PrintIdx:
			{
				g_print ( "Print Active Text Widget\n" );
			}

			break;
		case FileIdx:
			{
				g_print ( "Print File\n" );
			}

			break;
		case PreviewIdx:
			{
				g_print ( "Preview\n" );
			}
	}


	return TCL_OK;

}

/*****/

/****f* pixbuf/gnoclRegisterPixbuf
 * NAME
 *	gnoclRegisterPixbuf
 * PURPOSE
 * 	Provide the the pixel buffer with a name which can be used for later
 *  script operations.
 * AUTHOR
 *	William J Giddings
 * CREATION DATE
 *	05-03-09
 * USAGE
 *	how this function is used
 * ARGUMENTS
 * RETURN VALUE
 * NOTES
 * TODO
 * USES
 * USED BY
 * MODIFICATION HISTORY
 * SOURCE
 */
/*
 * Tcl_Interp *interp      Pointer to the Tcl interpreter
 * GtkPixBuf *pixbuf       Pointer to pixbuf object
 * Tcl_ObjCmdProc *proc    Command associated with this object
 */

int gnoclRegisterPixbuf (
	Tcl_Interp *interp,
	GdkPixbuf *pixbuf,
	Tcl_ObjCmdProc *proc )
{
	const char *name = gnoclGetAutoWidgetId();
	gnoclMemNameAndWidget ( name, pixbuf );

	// g_signal_connect_after ( G_OBJECT ( widget ), "destroy", G_CALLBACK ( simpleDestroyFunc ), interp );

	if ( proc != NULL )
		Tcl_CreateObjCommand ( interp, ( char * ) name, proc, pixbuf, NULL );

	Tcl_SetObjResult ( interp, Tcl_NewStringObj ( name, -1 ) );

	return TCL_OK;
}

/*****/
