/* folderChooserButton.c */

#include "gnocl.h"
#include <string.h>
#include <assert.h>

typedef struct
{
	GtkWidget	*widget;
	Tcl_Interp	*interp;
	char			*name;
	char			*variable;
	char			*onChanged;
	int         inSetVar;
} fileChooserParams;


/* hacked from entry.c */
static const int variableIdx  = 0;
static const int onChangedIdx = 1;
static const int valueIdx     = 2;

static int optMiscFp ( Tcl_Interp *interp, GnoclOption *opt, GObject *obj, Tcl_Obj **ret )
{
	return TCL_OK;
}

/* a function to manage changes and events occuring to the widget during runtime */
static int buttonFunc ( ClientData data, Tcl_Interp *interp, int objc, Tcl_Obj * const objv[] )
{
	static const char *cmds[] = { "delete", "configure", "cget", "onChanged", NULL };
	enum cmdIdx { DeleteIdx, ConfigureIdx, CgetIdx, OnChangedIdx };
	fileChooserParams *para = ( fileChooserParams * ) data;
	GtkWidget *widget = GTK_WIDGET ( para->widget );
	int idx;
	return TCL_OK;
}

static GnoclOption buttonOptions[] =
{

	{ "-folder", GNOCL_OBJ, "f", optMiscFp },					/* 0 */
	{ "-fileTypes", GNOCL_OBJ, NULL },        					/* 1 */
	{ "-onChanged", GNOCL_STRING, NULL }, 						/* 2 */
	{ "-tooltip", GNOCL_OBJ, "", gnoclOptTooltip },				/* 3 */
	{ "-variable", GNOCL_STRING, NULL },						/* 4 */

};

static int setVariable ( fileChooserParams *para, const char *val )
{
	if ( para->variable && para->inSetVar == 0 )
	{
		const char *ret;
		para->inSetVar = 1;
		ret = Tcl_SetVar ( para->interp, para->variable, val, TCL_GLOBAL_ONLY );
		para->inSetVar = 0;
		return ret == NULL ? TCL_ERROR : TCL_OK;
	}

	return TCL_OK;
}

static int doCommand ( fileChooserParams *para, const char val, int background )
{
	printf ( "doCommand\n" );

	//if( para->onChanged )
	//{
	//GnoclPercSubst ps[] = {
	//{ 'w', GNOCL_STRING }, /* widget */
	//{ 'v', GNOCL_STRING }, /* value */
	//{ 0 }
	//};
	//ps[0].val.str = para->name;
	//ps[1].val.str = val;

	//return gnoclPercentSubstAndEval( para->interp, ps, para->onChanged,
	//background );
	//}

	return TCL_OK;
}

/* hacked from entry.c */
static char *traceFunc ( ClientData data, Tcl_Interp *interp, const char *name1, const char *name2, int flags )
{
	return NULL;
}

/* hacked from entry.c */
static void changedFunc ( GtkWidget *widget, gpointer data )
{
	fileChooserParams *para = ( fileChooserParams * ) data;
	/* this line is causing the failure to compile, gtk_entry_get_text  */
	//const char *val = gtk_entry_get_text( para->widget );
	//setVariable( para, val );
	//doCommand( para, val, 1 );
	doCommand ( para, para->widget, 1 );
}

/* hacked from entry.c */
static int configure ( Tcl_Interp *interp, fileChooserParams *para, GnoclOption options[] )
{
	gnoclAttacheOptCmdAndVar (
		&options[onChangedIdx],
		&para->onChanged,
		&options[variableIdx],
		&para->variable,
		"changed",
		G_OBJECT ( para->widget ),
		G_CALLBACK ( changedFunc ),
		interp,
		traceFunc,
		para );

	if ( options[variableIdx].status == GNOCL_STATUS_CHANGED
			&& options[valueIdx].status == 0  /* value is handled below */
			&& para->variable != NULL )
	{
		/* if variable does not exist -> set it, else set widget state */
		const char *val = Tcl_GetVar ( interp, para->variable, TCL_GLOBAL_ONLY );
		//if( val == NULL )
		//{
		//val = gtk_entry_get_text( para->widget );
		//setVariable( para, val );
		//}
		//else
		//setVal( para->widget, val );
	}

	if ( options[valueIdx].status == GNOCL_STATUS_CHANGED )
	{
		char *str = options[valueIdx].val.str;
		//setVal( para->widget, str );
		//setVariable( para, str );
	}

	return TCL_OK;
}


//static int configure( Tcl_Interp *interp, GtkWidget *button, GnoclOption options[] )
//{
///* set the location to the user's home director */
//gtk_file_chooser_set_current_folder( GTK_FILE_CHOOSER(button), g_get_home_dir() ) ;
//printf( "Element 0 contains %s\n", options[0] );
//printf( "Element 1 contains %s\n", options[1] );
//printf( "Element 2 contains %s\n", options[2] );
//printf( "Element 3 contains %s\n", options[3] );
//printf( "Element 4 contains %s\n", options[4] );
//return TCL_OK;
//}

static int cget ( Tcl_Interp *interp, GtkButton *button, GnoclOption options[], int idx )
{
	return TCL_OK;
}

int gnoclFolderChooserButtonCmd ( ClientData data, Tcl_Interp *interp, int objc, Tcl_Obj * const objv[] )
{
	int       ret;
	fileChooserParams *para;
	GtkWidget *button;

	if ( gnoclParseOptions ( interp, objc, objv, buttonOptions ) != TCL_OK )
	{
		gnoclClearOptions ( buttonOptions );
		return TCL_ERROR;
	}

	/* create and show the button */
	button = gtk_file_chooser_button_new ( "Choose a folder", GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER );

	gtk_widget_show ( GTK_WIDGET ( button ) );

	/* assign values */
	//GtkWidget	*widget;
	//Tcl_Interp	*interp;
	//char			*name;
	//char			*variable;
	//char			*onChanged;
	//int			inSetVar;

	para = g_new ( fileChooserParams, 1 );

	para-> widget = button;

	para->interp = interp;

	para->variable = NULL;

	para->onChanged = NULL;

	/* intitalise options, and clear memory when done, return error initialisation fails */
	ret = gnoclSetOptions ( interp, buttonOptions, G_OBJECT ( button ), -1 );

	if ( ret == TCL_OK )
	{
		ret = configure ( interp, button, buttonOptions );
	}

	gnoclClearOptions ( buttonOptions );

	if ( ret != TCL_OK )
	{
		gtk_widget_destroy ( GTK_WIDGET ( button ) );
		return TCL_ERROR;
	}

	/* register the new widget for use with the Tcl interpretor */
	return gnoclRegisterWidget ( interp, GTK_WIDGET ( button ), buttonFunc );
}
