/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.engine.Constants;
import org.h2.server.Service;
import org.h2.server.pg.PgServerThread;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.Tool;

public class PgServer
implements Service {
    public static final int DEFAULT_PORT = 5435;
    private static final int PG_TYPE_BOOL = 16;
    private static final int PG_TYPE_BYTEA = 17;
    private static final int PG_TYPE_CHAR = 18;
    private static final int PG_TYPE_INT8 = 20;
    private static final int PG_TYPE_INT2 = 21;
    private static final int PG_TYPE_INT4 = 23;
    private static final int PG_TYPE_TEXT = 25;
    private static final int PG_TYPE_OID = 26;
    private static final int PG_TYPE_FLOAT4 = 700;
    private static final int PG_TYPE_FLOAT8 = 701;
    private static final int PG_TYPE_UNKNOWN = 705;
    private static final int PG_TYPE_TEXTARRAY = 1009;
    private static final int PG_TYPE_VARCHAR = 1043;
    private static final int PG_TYPE_DATE = 1082;
    private static final int PG_TYPE_TIME = 1083;
    private static final int PG_TYPE_TIMESTAMP_NO_TMZONE = 1114;
    private static final int PG_TYPE_NUMERIC = 1700;
    private int port = 5435;
    private boolean stop;
    private boolean trace;
    private ServerSocket serverSocket;
    private Set<PgServerThread> running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private boolean allowOthers;
    private boolean ifExists;

    public void init(String ... stringArray) {
        this.port = 5435;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-trace".equals(string)) {
                this.trace = true;
                continue;
            }
            if ("-log".equals(string) && SysProperties.OLD_COMMAND_LINE_OPTIONS) {
                this.trace = Tool.readArgBoolean(stringArray, i) == 1;
                ++i;
                continue;
            }
            if ("-pgPort".equals(string)) {
                this.port = MathUtils.decodeInt(stringArray[++i]);
                continue;
            }
            if ("-baseDir".equals(string)) {
                this.baseDir = stringArray[++i];
                continue;
            }
            if ("-pgAllowOthers".equals(string)) {
                if (Tool.readArgBoolean(stringArray, i) != 0) {
                    this.allowOthers = Tool.readArgBoolean(stringArray, i) == 1;
                    ++i;
                    continue;
                }
                this.allowOthers = true;
                continue;
            }
            if (!"-ifExists".equals(string)) continue;
            if (Tool.readArgBoolean(stringArray, i) != 0) {
                this.ifExists = Tool.readArgBoolean(stringArray, i) == 1;
                ++i;
                continue;
            }
            this.ifExists = true;
        }
        Driver.load();
    }

    boolean getTrace() {
        return this.trace;
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    synchronized void remove(PgServerThread pgServerThread) {
        this.running.remove(pgServerThread);
    }

    void traceError(Exception exception) {
        if (this.trace) {
            exception.printStackTrace();
        }
    }

    public String getURL() {
        return "pg://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    private boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void listen() {
        block4: {
            String string = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket socket = this.serverSocket.accept();
                    if (!this.allow(socket)) {
                        this.trace("Connection not allowed");
                        socket.close();
                        continue;
                    }
                    PgServerThread pgServerThread = new PgServerThread(socket, this);
                    this.running.add(pgServerThread);
                    pgServerThread.setProcessId(this.running.size());
                    Thread thread = new Thread(pgServerThread);
                    thread.setName(string + " thread");
                    pgServerThread.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception exception) {
                if (this.stop) break block4;
                exception.printStackTrace();
            }
        }
    }

    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        for (PgServerThread pgServerThread : New.arrayList(this.running)) {
            pgServerThread.close();
            try {
                Thread thread = pgServerThread.getThread();
                if (thread == null) continue;
                thread.join(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.serverSocket.getLocalPort(), false);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    String getBaseDir() {
        return this.baseDir;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "PG";
    }

    public String getName() {
        return "H2 PG Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    public static String getIndexColumn(Connection connection, int n, Integer n2, Boolean bl) throws SQLException {
        if (n2 == null || n2 == 0) {
            PreparedStatement preparedStatement = connection.prepareStatement("select sql from information_schema.indexes where id=?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return null;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select column_name from information_schema.indexes where id=? and ordinal_position=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    public static String getCurrentSchema(Connection connection) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery("call schema()");
        resultSet.next();
        return resultSet.getString(1);
    }

    public static String getEncodingName(int n) {
        switch (n) {
            case 0: {
                return "SQL_ASCII";
            }
            case 6: {
                return "UTF8";
            }
            case 8: {
                return "LATIN1";
            }
        }
        return n < 40 ? "UTF8" : "";
    }

    public static String getVersion() {
        return "PostgreSQL 8.1.4  server protocol using H2 " + Constants.getFullVersion();
    }

    public static Timestamp getStartTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getUserById(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT NAME FROM INFORMATION_SCHEMA.USERS WHERE ID=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    public static boolean hasDatabasePrivilege(int n, String string) {
        return true;
    }

    public static boolean hasTablePrivilege(String string, String string2) {
        return true;
    }

    public static int getCurrentTid(String string, String string2) {
        return 1;
    }

    public static int convertType(int n) {
        switch (n) {
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 2005: {
                return 25;
            }
            case 1: {
                return 18;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 3: {
                return 1700;
            }
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -3: {
                return 17;
            }
            case 2004: {
                return 26;
            }
            case 2003: {
                return 1009;
            }
        }
        return 705;
    }
}

