/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.data.DataAccessFactoryProducer;
import org.geoserver.data.DataStoreFactoryInitializer;
import org.geoserver.feature.FeatureSourceUtils;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataStoreUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.data");

    public static DataStore acquireDataStore(Map params, ServletContext sc) throws IOException {
        File baseDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        return DataStoreUtils.getDataStore(ResourcePool.getParams(params, baseDir.getAbsolutePath()));
    }

    public static DataStore getDataStore(Map params) throws IOException {
        DataAccess<? extends FeatureType, ? extends Feature> store = DataStoreUtils.getDataAccess(params);
        if (!(store instanceof DataStore)) {
            return null;
        }
        return (DataStore)store;
    }

    public static DataAccess<? extends FeatureType, ? extends Feature> getDataAccess(Map params) throws IOException {
        DataAccessFactory factory = DataStoreUtils.aquireFactory(params);
        if (factory == null) {
            return null;
        }
        DataAccess store = factory.createDataStore(params);
        if (store == null) {
            return null;
        }
        if (store instanceof DataStore) {
            String[] names = ((DataStore)store).getTypeNames();
            for (int i = 0; i < names.length; ++i) {
                if (names[i].indexOf(":") < 0) continue;
                return new RetypingDataStore((DataStore)store);
            }
        }
        return store;
    }

    public static Map getParams(Map m) {
        return DataStoreUtils.getParams(m, null);
    }

    public static Map getParams(Map m, ServletContext sc) {
        File data_dir = GeoserverDataDirectory.getGeoserverDataDirectory();
        String baseDir = data_dir.getPath();
        return ResourcePool.getParams(m, baseDir);
    }

    public static DataAccessFactory aquireFactory(Map params) {
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            DataStoreUtils.initializeDataStoreFactory(factory);
            if (!factory.canProcess(params)) continue;
            return factory;
        }
        return null;
    }

    public static DataAccessFactory aquireFactory(String displayName) {
        if (displayName == null) {
            return null;
        }
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            DataStoreUtils.initializeDataStoreFactory(factory);
            if (displayName.equals(factory.getDisplayName())) {
                return factory;
            }
            if (!displayName.equals(factory.getClass().toString())) continue;
            return factory;
        }
        return null;
    }

    static DataAccessFactory initializeDataStoreFactory(DataAccessFactory factory) {
        List initializers = GeoServerExtensions.extensions(DataStoreFactoryInitializer.class);
        for (DataStoreFactoryInitializer initer : initializers) {
            if (!initer.getFactoryClass().isAssignableFrom(factory.getClass())) continue;
            try {
                initer.initialize(factory);
            }
            catch (Throwable t) {
                String msg = "Error occured processing extension: " + initer.getClass().getName();
                GeoServerExtensions.LOGGER.log(Level.WARNING, msg, t);
            }
        }
        return factory;
    }

    public static DataAccessFactory.Param find(DataAccessFactory.Param[] params, String key) {
        for (int i = 0; i < params.length; ++i) {
            if (!key.equalsIgnoreCase(params[i].key)) continue;
            return params[i];
        }
        return null;
    }

    public static List listDataStoresDescriptions() {
        ArrayList<String> list2 = new ArrayList<String>();
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            DataStoreUtils.initializeDataStoreFactory(factory);
            list2.add(factory.getDisplayName());
        }
        return list2;
    }

    public static Map defaultParams(String description) {
        return DataStoreUtils.defaultParams(DataStoreUtils.aquireFactory(description));
    }

    public static Map defaultParams(DataAccessFactory factory) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        DataAccessFactory.Param[] params = factory.getParametersInfo();
        for (int i = 0; i < params.length; ++i) {
            DataAccessFactory.Param param = params[i];
            String key = param.key;
            String value = null;
            if (param.sample != null) {
                value = param.text(param.sample);
            }
            if (value == null) {
                value = "";
            }
            if (value == null) continue;
            defaults.put(key, value);
        }
        return defaults;
    }

    public static Map toConnectionParams(DataAccessFactory factory, Map params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        DataAccessFactory.Param[] info = factory.getParametersInfo();
        for (String key : params.keySet()) {
            Object value = DataStoreUtils.find(info, key).lookUp(params);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Envelope getBoundingBoxEnvelope(FeatureSource<? extends FeatureType, ? extends Feature> fs) throws IOException {
        return FeatureSourceUtils.getBoundingBoxEnvelope(fs);
    }

    public static Collection<DataAccessFactory> getAvailableDataStoreFactories() {
        ArrayList<DataAccessFactory> factories = new ArrayList<DataAccessFactory>();
        Iterator it = DataAccessFinder.getAvailableDataStores();
        while (it.hasNext()) {
            factories.add((DataAccessFactory)it.next());
        }
        for (DataAccessFactoryProducer producer : GeoServerExtensions.extensions(DataAccessFactoryProducer.class)) {
            try {
                factories.addAll(producer.getDataStoreFactories());
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error occured loading data access factories. Ignoring producer", t);
            }
        }
        return factories;
    }
}

