/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Wrapper;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredObjects;
import org.geoserver.security.decorators.SecurityUtils;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    static final Logger LOGGER = Logging.getLogger(SecuredFeatureCollection.class);
    WrapperPolicy policy;

    SecuredFeatureCollection(FeatureCollection<T, F> delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public Iterator iterator() {
        return (Iterator)SecuredObjects.secure(this.delegate.iterator(), this.policy);
    }

    public FeatureIterator<F> features() {
        return (FeatureIterator)SecuredObjects.secure(this.delegate.features(), this.policy);
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        FeatureCollection fc = this.delegate.sort(order);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        FeatureCollection fc = this.delegate.subCollection(filter);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    public void close(FeatureIterator<F> close) {
        if (close instanceof Wrapper && ((Wrapper)close).isWrapperFor(FeatureIterator.class)) {
            this.delegate.close(((Wrapper)close).unwrap(FeatureIterator.class));
        } else {
            this.delegate.close(close);
        }
    }

    public void close(Iterator<F> close) {
        if (close instanceof Wrapper && ((Wrapper)((Object)close)).isWrapperFor(Iterator.class)) {
            this.delegate.close(((Wrapper)((Object)close)).unwrap(Iterator.class));
        } else {
            this.delegate.close(close);
        }
    }

    public boolean add(F o) {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Filter filter = writeQuery.getFilter();
        if (filter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        if (filter.evaluate(o)) {
            if (writeQuery.getPropertyNames() == Query.ALL_NAMES) {
                return this.delegate.add(o);
            }
            LOGGER.log(Level.SEVERE, "Unfinished implementation, we need to shave off the attributes one cannot write!");
            return this.add(o);
        }
        return false;
    }

    public boolean addAll(Collection c) {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Filter filter = writeQuery.getFilter();
        if (filter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        List filtered = this.filterCollection(c, writeQuery);
        return this.addAll(filtered);
    }

    List filterCollection(Collection collection, Query writeQuery) {
        if (writeQuery.getPropertyNames() != Query.ALL_NAMES) {
            LOGGER.log(Level.SEVERE, "Unfinished implementation, we need to shave off the attributes one cannot write!");
        }
        Filter filter = writeQuery.getFilter();
        ArrayList filtered = new ArrayList();
        for (Object feature : collection) {
            if (!filter.evaluate(feature)) continue;
            filtered.add(feature);
        }
        return filtered;
    }

    public void clear() {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Filter filter = writeQuery.getFilter();
        if (filter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        this.delegate.clear();
    }

    public boolean remove(Object o) {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Filter filter = writeQuery.getFilter();
        if (filter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        if (filter.evaluate(o)) {
            return this.delegate.remove(o);
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Filter filter = writeQuery.getFilter();
        if (filter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        List filtered = this.filterCollection(c, writeQuery);
        return this.removeAll(filtered);
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Sorry, not even ContentFeatureCollection implements this one");
    }

    RuntimeException unsupportedOperation() {
        String typeName = this.getID();
        if (this.policy.response == Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess(typeName);
        }
        return new UnsupportedOperationException("Feature type " + typeName + " is read only");
    }
}

