/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingDataStoreInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.ProgressListener;

public class SecuredDataStoreInfo
extends DecoratingDataStoreInfo {
    WrapperPolicy policy;

    public SecuredDataStoreInfo(DataStoreInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public DataStore getDataStore(ProgressListener listener) throws IOException {
        DataAccess<? extends FeatureType, ? extends Feature> ds = super.getDataStore(listener);
        if (ds == null) {
            return null;
        }
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return (DataStore)SecuredObjects.secure(ds, this.policy);
    }
}

