/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ProxyBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvingProxy
extends ProxyBase {
    String ref;

    public static <T> T create(String ref, Class<T> clazz) {
        Object proxy;
        ResolvingProxy h = new ResolvingProxy(ref);
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
        try {
            proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(h);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)proxy;
    }

    public static <T> T resolve(Catalog catalog, T object) {
        InvocationHandler h;
        if (object instanceof Proxy && (h = Proxy.getInvocationHandler(object)) instanceof ResolvingProxy) {
            String ref = ((ResolvingProxy)h).getRef();
            if (object instanceof WorkspaceInfo) {
                WorkspaceInfo ws = catalog.getWorkspace(ref);
                if (ws == null) {
                    ws = catalog.getWorkspaceByName(ref);
                }
                return (T)ws;
            }
            if (object instanceof NamespaceInfo) {
                NamespaceInfo ns = catalog.getNamespace(ref);
                if (ns == null) {
                    ns = catalog.getNamespaceByPrefix(ref);
                }
                return (T)ns;
            }
            if (object instanceof StoreInfo) {
                if (object instanceof DataStoreInfo) {
                    return (T)catalog.getDataStore(ref);
                }
                if (object instanceof CoverageStoreInfo) {
                    return (T)catalog.getCoverageStore(ref);
                }
                return (T)catalog.getStore(ref, StoreInfo.class);
            }
            if (object instanceof ResourceInfo) {
                if (object instanceof FeatureTypeInfo) {
                    return (T)catalog.getFeatureType(ref);
                }
                if (object instanceof CoverageInfo) {
                    return (T)catalog.getCoverage(ref);
                }
                return (T)catalog.getResource(ref, ResourceInfo.class);
            }
            if (object instanceof LayerInfo) {
                LayerInfo l = catalog.getLayer(ref);
                if (l == null) {
                    l = catalog.getLayerByName(ref);
                }
                return (T)l;
            }
            if (object instanceof StyleInfo) {
                StyleInfo s = catalog.getStyle(ref);
                if (s == null) {
                    s = catalog.getStyleByName(ref);
                }
                return (T)s;
            }
        }
        return object;
    }

    public ResolvingProxy(String ref) {
        this.ref = ref;
    }

    public String getRef() {
        return this.ref;
    }

    @Override
    protected Object handleGetUnSet(Object proxy, Method method, String property) throws Throwable {
        if ("id".equalsIgnoreCase(property)) {
            return this.ref;
        }
        return null;
    }

    @Override
    protected Object handleOther(Object proxy, Method method, Object[] args) throws Throwable {
        return null;
    }
}

