/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogValidator;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.event.impl.CatalogAddEventImpl;
import org.geoserver.catalog.event.impl.CatalogModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogPostModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogRemoveEventImpl;
import org.geoserver.catalog.impl.CatalogFactoryImpl;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.DefaultCatalogFacade;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogImpl
implements Catalog {
    private static final Logger LOGGER = Logging.getLogger(CatalogImpl.class);
    protected CatalogFacade facade;
    protected List listeners = new ArrayList();
    protected ResourcePool resourcePool;
    protected GeoServerResourceLoader resourceLoader;

    public CatalogImpl() {
        this.facade = new DefaultCatalogFacade(this);
        this.resourcePool = new ResourcePool(this);
    }

    @Override
    public CatalogFacade getFacade() {
        return this.facade;
    }

    public Iterable<CatalogValidator> getValidators() {
        return GeoServerExtensions.extensions(CatalogValidator.class);
    }

    public void setFacade(CatalogFacade facade) {
        this.facade = facade;
        facade.setCatalog(this);
    }

    @Override
    public String getId() {
        return "catalog";
    }

    @Override
    public CatalogFactory getFactory() {
        return new CatalogFactoryImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StoreInfo store) {
        if (store.getWorkspace() == null) {
            store.setWorkspace(this.getDefaultWorkspace());
        }
        this.validate(store, true);
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.add(this.resolve(store));
            if (this.getDefaultDataStore(store.getWorkspace()) == null && store instanceof DataStoreInfo) {
                this.setDefaultDataStore(store.getWorkspace(), (DataStoreInfo)store);
            }
        }
        this.added(store);
    }

    @Override
    public List<RuntimeException> validate(StoreInfo store, boolean isNew) {
        if (this.isNull(store.getName())) {
            throw new IllegalArgumentException("Store name must not be null");
        }
        if (store.getWorkspace() == null) {
            throw new IllegalArgumentException("Store must be part of a workspace");
        }
        WorkspaceInfo workspace = store.getWorkspace();
        StoreInfo existing = this.getStoreByName(workspace, store.getName(), StoreInfo.class);
        if (existing != null && !existing.getId().equals(store.getId())) {
            String msg = "Store '" + store.getName() + "' already exists in workspace '" + workspace.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        return this.postValidate(store, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StoreInfo store) {
        if (!this.getResourcesByStore(store, ResourceInfo.class).isEmpty()) {
            throw new IllegalArgumentException("Unable to delete non-empty store.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.remove(store);
            WorkspaceInfo workspace = store.getWorkspace();
            DataStoreInfo defaultStore = this.getDefaultDataStore(workspace);
            if (store.equals(defaultStore)) {
                this.setDefaultDataStore(workspace, null);
                List<DataStoreInfo> dstores = this.getStoresByWorkspace(workspace, DataStoreInfo.class);
                if (!dstores.isEmpty()) {
                    this.setDefaultDataStore(workspace, dstores.get(0));
                }
            }
        }
        this.removed(store);
    }

    @Override
    public void save(StoreInfo store) {
        if (store.getId() == null) {
            this.add(store);
            return;
        }
        this.validate(store, false);
        this.facade.save(store);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return this.detached(store, this.facade.detach(store));
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        return this.facade.getStore(id, clazz);
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String name, Class<T> clazz) {
        return this.getStoreByName((WorkspaceInfo)null, name, clazz);
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        WorkspaceInfo ws = workspace;
        if (ws == null) {
            ws = this.getDefaultWorkspace();
        }
        if (DataStoreInfo.class == clazz && (name == null || name.equals("default"))) {
            return (T)this.getDefaultDataStore(workspace);
        }
        T store = this.facade.getStoreByName(ws, name, clazz);
        if (store == null && workspace == null) {
            store = this.facade.getStoreByName(DefaultCatalogFacade.ANY_WORKSPACE, name, clazz);
        }
        return store;
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String workspaceName, String name, Class<T> clazz) {
        if (workspaceName == null) {
            return this.getStoreByName((WorkspaceInfo)null, name, clazz);
        }
        WorkspaceInfo workspace = this.getWorkspaceByName(workspaceName);
        if (workspace != null) {
            return this.getStoreByName(workspace, name, clazz);
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(String workspaceName, Class<T> clazz) {
        WorkspaceInfo workspace = null;
        if (workspaceName != null && (workspace = this.getWorkspaceByName(workspaceName)) == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getStoresByWorkspace(workspace, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        return this.facade.getStoresByWorkspace(workspace, clazz);
    }

    public List getStores(Class clazz) {
        return this.facade.getStores(clazz);
    }

    @Override
    public DataStoreInfo getDataStore(String id) {
        return this.getStore(id, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String name) {
        return this.getStoreByName(name, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String workspaceName, String name) {
        return this.getStoreByName(workspaceName, name, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(WorkspaceInfo workspace, String name) {
        return this.getStoreByName(workspace, name, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(String workspaceName) {
        return this.getStoresByWorkspace(workspaceName, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo workspace) {
        return this.getStoresByWorkspace(workspace, DataStoreInfo.class);
    }

    public List getDataStores() {
        return this.getStores(DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        return this.facade.getDefaultDataStore(workspace);
    }

    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo store) {
        if (store != null) {
            if (store.getWorkspace() == null) {
                throw new IllegalArgumentException("The store has not been assigned a workspace");
            }
            if (!store.getWorkspace().equals(workspace)) {
                throw new IllegalArgumentException("Trying to mark as default for workspace " + workspace.getName() + " a store that " + "is contained in " + store.getWorkspace().getName());
            }
        }
        this.facade.setDefaultDataStore(workspace, store);
    }

    @Override
    public CoverageStoreInfo getCoverageStore(String id) {
        return this.getStore(id, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String name) {
        return this.getStoreByName(name, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String workspaceName, String name) {
        return this.getStoreByName(workspaceName, name, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo workspace, String name) {
        return this.getStoreByName(workspace, name, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String workspaceName) {
        return this.getStoresByWorkspace(workspaceName, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo workspace) {
        return this.getStoresByWorkspace(workspace, CoverageStoreInfo.class);
    }

    public List getCoverageStores() {
        return this.getStores(CoverageStoreInfo.class);
    }

    @Override
    public void add(ResourceInfo resource) {
        if (resource.getNamespace() == null) {
            resource.setNamespace(this.getDefaultNamespace());
        }
        if (resource.getNativeName() == null) {
            resource.setNativeName(resource.getName());
        }
        this.validate(resource, true);
        this.facade.add(this.resolve(resource));
        this.added(resource);
    }

    @Override
    public List<RuntimeException> validate(ResourceInfo resource, boolean isNew) {
        if (this.isNull(resource.getName())) {
            throw new NullPointerException("Resource name must not be null");
        }
        if (this.isNull(resource.getNativeName())) {
            throw new NullPointerException("Resource native name must not be null");
        }
        if (resource.getStore() == null) {
            throw new IllegalArgumentException("Resource must be part of a store");
        }
        if (resource.getNamespace() == null) {
            throw new IllegalArgumentException("Resource must be part of a namespace");
        }
        StoreInfo store = resource.getStore();
        ResourceInfo existing = this.getResourceByStore(store, resource.getName(), ResourceInfo.class);
        if (existing != null && !existing.getId().equals(resource.getId())) {
            String msg = "Resource named '" + resource.getName() + "' already exists in store: '" + store.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        NamespaceInfo namespace = resource.getNamespace();
        existing = this.getResourceByName(namespace, resource.getName(), ResourceInfo.class);
        if (existing != null && !existing.getId().equals(resource.getId())) {
            String msg = "Resource named '" + resource.getName() + "' already exists in namespace: '" + namespace.getPrefix() + "'";
            throw new IllegalArgumentException(msg);
        }
        return this.postValidate(resource, isNew);
    }

    @Override
    public void remove(ResourceInfo resource) {
        if (!this.getLayers(resource).isEmpty()) {
            throw new IllegalArgumentException("Unable to delete resource referenced by layer");
        }
        this.facade.remove(resource);
        this.removed(resource);
    }

    @Override
    public void save(ResourceInfo resource) {
        this.validate(resource, false);
        this.facade.save(resource);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return this.detached(resource, this.facade.detach(resource));
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        return this.facade.getResource(id, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String ns, String name, Class<T> clazz) {
        if ("".equals(ns)) {
            ns = null;
        }
        if (ns != null) {
            NamespaceInfo namespace = this.getNamespaceByPrefix(ns);
            if (namespace == null) {
                namespace = this.getNamespaceByURI(ns);
            }
            if (namespace != null) {
                return this.getResourceByName(namespace, name, clazz);
            }
            return null;
        }
        return this.getResourceByName((NamespaceInfo)null, name, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo ns, String name, Class<T> clazz) {
        T resource;
        NamespaceInfo namespace = ns;
        if (namespace == null) {
            namespace = this.getDefaultNamespace();
        }
        if ((resource = this.facade.getResourceByName(namespace, name, clazz)) == null && ns == null) {
            resource = this.facade.getResourceByName(DefaultCatalogFacade.ANY_NAMESPACE, name, clazz);
        }
        return resource;
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(Name name, Class<T> clazz) {
        return this.getResourceByName(name.getNamespaceURI(), name.getLocalPart(), clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String name, Class<T> clazz) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            String ns = name.substring(0, colon);
            String localName = name.substring(colon + 1);
            return this.getResourceByName(ns, localName, clazz);
        }
        return this.getResourceByName((String)null, name, clazz);
    }

    public List getResources(Class clazz) {
        return this.facade.getResources(clazz);
    }

    public List getResourcesByNamespace(NamespaceInfo namespace, Class clazz) {
        return this.facade.getResourcesByNamespace(namespace, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String namespace, Class<T> clazz) {
        if (namespace == null) {
            return this.getResourcesByNamespace((NamespaceInfo)null, (Class)clazz);
        }
        NamespaceInfo ns = this.getNamespaceByPrefix(namespace);
        if (ns == null) {
            ns = this.getNamespaceByURI(namespace);
        }
        if (ns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getResourcesByNamespace(ns, (Class)clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        return this.facade.getResourceByStore(store, name, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        return this.facade.getResourcesByStore(store, clazz);
    }

    @Override
    public FeatureTypeInfo getFeatureType(String id) {
        return this.getResource(id, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String ns, String name) {
        return this.getResourceByName(ns, name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo ns, String name) {
        return this.getResourceByName(ns, name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(Name name) {
        return this.getResourceByName(name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String name) {
        return this.getResourceByName(name, FeatureTypeInfo.class);
    }

    public List getFeatureTypes() {
        return this.getResources(FeatureTypeInfo.class);
    }

    public List getFeatureTypesByNamespace(NamespaceInfo namespace) {
        return this.getResourcesByNamespace(namespace, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByStore(DataStoreInfo dataStore, String name) {
        return this.getFeatureTypeByDataStore(dataStore, name);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo dataStore, String name) {
        return this.getResourceByStore(dataStore, name, FeatureTypeInfo.class);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByStore(DataStoreInfo store) {
        return this.getFeatureTypesByDataStore(store);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByDataStore(DataStoreInfo store) {
        return this.getResourcesByStore(store, FeatureTypeInfo.class);
    }

    @Override
    public CoverageInfo getCoverage(String id) {
        return this.getResource(id, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(String ns, String name) {
        return this.getResourceByName(ns, name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(NamespaceInfo ns, String name) {
        return this.getResourceByName(ns, name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(Name name) {
        return this.getResourceByName(name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(String name) {
        return this.getResourceByName(name, CoverageInfo.class);
    }

    public List getCoverages() {
        return this.getResources(CoverageInfo.class);
    }

    public List getCoveragesByNamespace(NamespaceInfo namespace) {
        return this.getResourcesByNamespace(namespace, CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoveragesByStore(CoverageStoreInfo store) {
        return this.getResourcesByStore(store, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo coverageStore, String name) {
        return this.getResourceByStore(coverageStore, name, CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo store) {
        return this.getResourcesByStore(store, CoverageInfo.class);
    }

    @Override
    public void add(LayerInfo layer) {
        this.validate(layer, true);
        if (layer.getType() == null) {
            if (layer.getResource() instanceof FeatureTypeInfo) {
                layer.setType(LayerInfo.Type.VECTOR);
            } else if (layer.getResource() instanceof CoverageInfo) {
                layer.setType(LayerInfo.Type.RASTER);
            } else if (layer.getResource() instanceof WMSLayerInfo) {
                layer.setType(LayerInfo.Type.WMS);
            } else {
                String msg = "Layer type not set and can't be derived from resource";
                throw new IllegalArgumentException(msg);
            }
        }
        this.facade.add(this.resolve(layer));
        this.added(layer);
    }

    @Override
    public List<RuntimeException> validate(LayerInfo layer, boolean isNew) {
        LayerInfo existing = this.getLayerByName(layer.getName());
        if (existing != null && !existing.getId().equals(layer.getId()) && ((Object)existing.getResource().getNamespace()).equals(layer.getName())) {
            throw new IllegalArgumentException("Layer named '" + layer.getName() + "' already exists.");
        }
        if (layer.getResource() == null) {
            throw new NullPointerException("Layer resource must not be null");
        }
        return this.postValidate(layer, isNew);
    }

    @Override
    public void remove(LayerInfo layer) {
        for (LayerGroupInfo lg : this.facade.getLayerGroups()) {
            if (!lg.getLayers().contains(layer)) continue;
            String msg = "Unable to delete layer referenced by layer group '" + lg.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        this.facade.remove(layer);
        this.removed(layer);
    }

    @Override
    public void save(LayerInfo layer) {
        this.validate(layer, false);
        this.facade.save(layer);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return this.detached(layer, this.facade.detach(layer));
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.facade.getLayer(id);
    }

    @Override
    public LayerInfo getLayerByName(Name name) {
        NamespaceInfo ns;
        if (name.getNamespaceURI() != null && (ns = this.getNamespaceByURI(name.getNamespaceURI())) != null) {
            return this.getLayerByName(ns.getPrefix() + ":" + name.getLocalPart());
        }
        return this.getLayerByName(name.getLocalPart());
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        String prefix = null;
        String resource = null;
        int colon = name.indexOf(58);
        if (colon != -1) {
            List<LayerInfo> layers;
            prefix = name.substring(0, colon);
            ResourceInfo r = this.getResourceByName(prefix, resource = name.substring(colon + 1), ResourceInfo.class);
            if (r != null && (layers = this.getLayers(r)).size() == 1) {
                return layers.get(0);
            }
            return null;
        }
        return this.facade.getLayerByName(name);
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        return this.facade.getLayers(resource);
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        return this.facade.getLayers(style);
    }

    public List getLayers() {
        return this.facade.getLayers();
    }

    @Override
    public MapInfo getMap(String id) {
        return this.facade.getMap(id);
    }

    @Override
    public MapInfo getMapByName(String name) {
        return this.facade.getMapByName(name);
    }

    @Override
    public List<MapInfo> getMaps() {
        return this.facade.getMaps();
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        this.validate(layerGroup, true);
        this.resolve(layerGroup);
        if (layerGroup.getStyles().isEmpty()) {
            for (LayerInfo l : layerGroup.getLayers()) {
                layerGroup.getStyles().add(null);
            }
        }
        layerGroup = this.facade.add(layerGroup);
        this.added(layerGroup);
    }

    @Override
    public List<RuntimeException> validate(LayerGroupInfo layerGroup, boolean isNew) {
        if (this.isNull(layerGroup.getName())) {
            throw new NullPointerException("Layer group name must not be null");
        }
        LayerGroupInfo existing = this.getLayerGroupByName(layerGroup.getName());
        if (existing != null && !existing.getId().equals(layerGroup.getId())) {
            throw new IllegalArgumentException("Layer group named '" + layerGroup.getName() + "' already exists.");
        }
        if (layerGroup.getLayers() == null || layerGroup.getLayers().isEmpty()) {
            throw new IllegalArgumentException("Layer group must not be empty");
        }
        if (layerGroup.getStyles() != null && !layerGroup.getStyles().isEmpty() && layerGroup.getStyles().size() != layerGroup.getLayers().size()) {
            throw new IllegalArgumentException("Layer group has different number of styles than layers");
        }
        return this.postValidate(layerGroup, isNew);
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        this.facade.remove(layerGroup);
        this.removed(layerGroup);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        this.validate(layerGroup, false);
        this.facade.save(layerGroup);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return this.detached(layerGroup, this.facade.detach(layerGroup));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.facade.getLayerGroups();
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.facade.getLayerGroup(id);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.facade.getLayerGroupByName(name);
    }

    @Override
    public void add(MapInfo map) {
        this.facade.add(this.resolve(map));
        this.added(map);
    }

    @Override
    public void remove(MapInfo map) {
        this.facade.remove(map);
        this.removed(map);
    }

    @Override
    public void save(MapInfo map) {
        this.facade.save(map);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return this.detached(map, this.facade.detach(map));
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        return this.facade.getNamespace(id);
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        NamespaceInfo ns;
        if ((prefix == null || "default".equals(prefix)) && (ns = this.getDefaultNamespace()) != null) {
            prefix = ns.getPrefix();
        }
        return this.facade.getNamespaceByPrefix(prefix);
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        return this.facade.getNamespaceByURI(uri);
    }

    public List getNamespaces() {
        return this.facade.getNamespaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(NamespaceInfo namespace) {
        this.validate(namespace, true);
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.add(this.resolve(namespace));
            if (this.getDefaultNamespace() == null) {
                this.setDefaultNamespace(namespace);
            }
        }
        this.added(namespace);
    }

    @Override
    public List<RuntimeException> validate(NamespaceInfo namespace, boolean isNew) {
        if (this.isNull(namespace.getPrefix())) {
            throw new NullPointerException("Namespace prefix must not be null");
        }
        if (namespace.getPrefix().equals("default")) {
            throw new IllegalArgumentException("default is a reserved keyword, can't be used as the namespace prefix");
        }
        NamespaceInfo existing = this.getNamespaceByPrefix(namespace.getPrefix());
        if (existing != null && !existing.getId().equals(namespace.getId())) {
            throw new IllegalArgumentException("Namespace with prefix '" + namespace.getPrefix() + "' already exists.");
        }
        existing = this.getNamespaceByURI(namespace.getURI());
        if (existing != null && !existing.getId().equals(namespace.getId())) {
            throw new IllegalArgumentException("Namespace with URI '" + namespace.getURI() + "' already exists.");
        }
        if (this.isNull(namespace.getURI())) {
            throw new NullPointerException("Namespace uri must not be null");
        }
        try {
            new URI(namespace.getURI());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI syntax for '" + namespace.getURI() + "' in namespace '" + namespace.getPrefix() + "'");
        }
        return this.postValidate(namespace, isNew);
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        if (!this.getResourcesByNamespace(namespace, ResourceInfo.class).isEmpty()) {
            throw new IllegalArgumentException("Unable to delete non-empty namespace.");
        }
        this.facade.remove(namespace);
        this.removed(namespace);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        this.validate(namespace, false);
        this.facade.save(namespace);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return this.detached(namespace, this.facade.detach(namespace));
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return this.facade.getDefaultNamespace();
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        NamespaceInfo ns = this.getNamespaceByPrefix(defaultNamespace.getPrefix());
        if (ns == null) {
            throw new IllegalArgumentException("No such namespace: '" + defaultNamespace.getPrefix() + "'");
        }
        this.facade.setDefaultNamespace(defaultNamespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(WorkspaceInfo workspace) {
        this.validate(workspace, true);
        if (this.getWorkspaceByName(workspace.getName()) != null) {
            throw new IllegalArgumentException("Workspace with name '" + workspace.getName() + "' already exists.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.add(this.resolve(workspace));
            if (this.getDefaultWorkspace() == null) {
                this.setDefaultWorkspace(workspace);
            }
        }
        this.added(workspace);
    }

    @Override
    public List<RuntimeException> validate(WorkspaceInfo workspace, boolean isNew) {
        if (this.isNull(workspace.getName())) {
            throw new NullPointerException("workspace name must not be null");
        }
        if (workspace.getName().equals("default")) {
            throw new IllegalArgumentException("default is a reserved keyword, can't be used as the workspace name");
        }
        WorkspaceInfo existing = this.getWorkspaceByName(workspace.getName());
        if (existing != null && !existing.getId().equals(workspace.getId())) {
            throw new IllegalArgumentException("Workspace named '" + workspace.getName() + "' already exists.");
        }
        return this.postValidate(workspace, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(WorkspaceInfo workspace) {
        if (this.getNamespaceByPrefix(workspace.getName()) != null) {
            throw new IllegalArgumentException("Cannot delete workspace with linked namespace");
        }
        if (!this.getStoresByWorkspace(workspace, StoreInfo.class).isEmpty()) {
            throw new IllegalArgumentException("Cannot delete non-empty workspace.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.remove(workspace);
            WorkspaceInfo defaultWorkspace = this.getDefaultWorkspace();
            if (workspace.equals(defaultWorkspace) || defaultWorkspace == null) {
                List<WorkspaceInfo> workspaces = this.facade.getWorkspaces();
                defaultWorkspace = null;
                if (!workspaces.isEmpty()) {
                    defaultWorkspace = workspaces.get(0);
                }
                this.setDefaultWorkspace(defaultWorkspace);
            }
        }
        this.removed(workspace);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        this.validate(workspace, false);
        this.facade.save(workspace);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return this.detached(workspace, this.facade.detach(workspace));
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return this.facade.getDefaultWorkspace();
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        if (workspace != null && this.facade.getWorkspaceByName(workspace.getName()) == null) {
            this.facade.add(workspace);
        }
        this.facade.setDefaultWorkspace(workspace);
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return this.facade.getWorkspaces();
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        return this.facade.getWorkspace(id);
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        WorkspaceInfo ws;
        if ((name == null || "default".equals(name)) && (ws = this.getDefaultWorkspace()) != null) {
            name = ws.getName();
        }
        return this.facade.getWorkspaceByName(name);
    }

    @Override
    public StyleInfo getStyle(String id) {
        return this.facade.getStyle(id);
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        return this.facade.getStyleByName(name);
    }

    public List getStyles() {
        return this.facade.getStyles();
    }

    @Override
    public void add(StyleInfo style) {
        this.validate(style, true);
        this.facade.add(this.resolve(style));
        this.added(style);
    }

    @Override
    public List<RuntimeException> validate(StyleInfo style, boolean isNew) {
        if (this.isNull(style.getName())) {
            throw new NullPointerException("Style name must not be null");
        }
        if (this.isNull(style.getFilename())) {
            throw new NullPointerException("Style fileName must not be null");
        }
        StyleInfo existing = this.getStyleByName(style.getName());
        if (existing != null && !existing.getId().equals(style.getId())) {
            throw new IllegalArgumentException("Style named '" + style.getName() + "' already exists.");
        }
        return this.postValidate(style, isNew);
    }

    @Override
    public void remove(StyleInfo style) {
        for (LayerInfo l : this.facade.getLayers()) {
            if (!style.equals(l.getDefaultStyle()) && !l.getStyles().contains(style)) continue;
            throw new IllegalArgumentException("Unable to delete style referenced by '" + l.getName() + "'");
        }
        this.facade.remove(style);
        this.removed(style);
    }

    @Override
    public void save(StyleInfo style) {
        this.validate(style, false);
        this.facade.save(style);
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return this.detached(style, this.facade.detach(style));
    }

    public Collection getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    @Override
    public void addListener(CatalogListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(CatalogListener listener) {
        this.listeners.remove(listener);
    }

    public Iterator search(String cql) {
        return null;
    }

    @Override
    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    @Override
    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    @Override
    public GeoServerResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void dispose() {
        this.facade.dispose();
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.resourcePool != null) {
            this.resourcePool.dispose();
        }
    }

    protected void added(CatalogInfo object) {
        this.fireAdded(object);
    }

    protected void removed(CatalogInfo object) {
        this.fireRemoved(object);
    }

    @Override
    public void fireAdded(CatalogInfo object) {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource(object);
        this.event(event);
    }

    public void fireModified(CatalogInfo object, List propertyNames, List oldValues, List newValues) {
        CatalogModifyEventImpl event = new CatalogModifyEventImpl();
        event.setSource(object);
        event.setPropertyNames(propertyNames);
        event.setOldValues(oldValues);
        event.setNewValues(newValues);
        this.event(event);
    }

    @Override
    public void firePostModified(CatalogInfo object) {
        CatalogPostModifyEventImpl event = new CatalogPostModifyEventImpl();
        event.setSource(object);
        this.event(event);
    }

    @Override
    public void fireRemoved(CatalogInfo object) {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource(object);
        this.event(event);
    }

    protected void event(CatalogEvent event) {
        CatalogException toThrow = null;
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            try {
                CatalogListener listener = (CatalogListener)l.next();
                if (event instanceof CatalogAddEvent) {
                    listener.handleAddEvent((CatalogAddEvent)event);
                    continue;
                }
                if (event instanceof CatalogRemoveEvent) {
                    listener.handleRemoveEvent((CatalogRemoveEvent)event);
                    continue;
                }
                if (event instanceof CatalogModifyEvent) {
                    listener.handleModifyEvent((CatalogModifyEvent)event);
                    continue;
                }
                if (!(event instanceof CatalogPostModifyEvent)) continue;
                listener.handlePostModifyEvent((CatalogPostModifyEvent)event);
            }
            catch (Throwable t) {
                if (t instanceof CatalogException && toThrow == null) {
                    toThrow = (CatalogException)t;
                    continue;
                }
                LOGGER.log(Level.WARNING, "Catalog listener threw exception handling event.", t);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static Object unwrap(Object obj) {
        return obj;
    }

    public void resolve() {
        this.facade.setCatalog(this);
        this.facade.resolve();
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.resourcePool == null) {
            this.resourcePool = new ResourcePool(this);
        }
    }

    protected WorkspaceInfo resolve(WorkspaceInfo workspace) {
        this.resolveCollections(workspace);
        return workspace;
    }

    protected NamespaceInfo resolve(NamespaceInfo namespace) {
        this.resolveCollections(namespace);
        return namespace;
    }

    protected StoreInfo resolve(StoreInfo store) {
        this.resolveCollections(store);
        StoreInfoImpl s = (StoreInfoImpl)store;
        s.setCatalog(this);
        return store;
    }

    protected ResourceInfo resolve(ResourceInfo resource) {
        ResourceInfoImpl r = (ResourceInfoImpl)resource;
        r.setCatalog(this);
        if (resource instanceof FeatureTypeInfo) {
            this.resolve((FeatureTypeInfo)resource);
        }
        if (r instanceof CoverageInfo) {
            this.resolve((CoverageInfo)resource);
        }
        if (r instanceof WMSLayerInfo) {
            this.resolve((WMSLayerInfo)resource);
        }
        return resource;
    }

    private CoverageInfo resolve(CoverageInfo r) {
        CoverageInfoImpl c = (CoverageInfoImpl)r;
        if (c.getDimensions() != null) {
            for (CoverageDimensionInfo dim : c.getDimensions()) {
                if (dim.getNullValues() != null) continue;
                ((CoverageDimensionImpl)dim).setNullValues(new ArrayList<Double>());
            }
        }
        this.resolveCollections(r);
        return r;
    }

    private FeatureTypeInfo resolve(FeatureTypeInfo featureType) {
        FeatureTypeInfoImpl ft = (FeatureTypeInfoImpl)featureType;
        this.resolveCollections(ft);
        return ft;
    }

    private WMSLayerInfo resolve(WMSLayerInfo wmsLayer) {
        WMSLayerInfoImpl impl = (WMSLayerInfoImpl)wmsLayer;
        this.resolveCollections(impl);
        return wmsLayer;
    }

    protected LayerInfo resolve(LayerInfo layer) {
        if (layer.getAttribution() == null) {
            layer.setAttribution(this.getFactory().createAttribution());
        }
        this.resolveCollections(layer);
        return layer;
    }

    protected LayerGroupInfo resolve(LayerGroupInfo layerGroup) {
        this.resolveCollections(layerGroup);
        return layerGroup;
    }

    protected StyleInfo resolve(StyleInfo style) {
        ((StyleInfoImpl)style).setCatalog(this);
        return style;
    }

    protected MapInfo resolve(MapInfo map) {
        this.resolveCollections(map);
        return map;
    }

    protected void resolveCollections(Object object) {
        ClassProperties properties = OwsUtils.getClassProperties(object.getClass());
        for (String property : properties.properties()) {
            Method s;
            Class<?> type;
            Method g = properties.getter(property, null);
            if (g == null || !Map.class.isAssignableFrom(type = g.getReturnType()) && !Collection.class.isAssignableFrom(type) || (s = properties.setter(property, null)) == null) continue;
            try {
                Serializable value = g.invoke(object, null);
                if (value != null) continue;
                if (Map.class.isAssignableFrom(type)) {
                    value = MetadataMap.class.isAssignableFrom(type) ? new MetadataMap() : new HashMap();
                } else if (List.class.isAssignableFrom(type)) {
                    value = new ArrayList();
                } else if (Set.class.isAssignableFrom(type)) {
                    value = new HashSet();
                } else {
                    throw new RuntimeException("Unknown collection type:" + type.getName());
                }
                s.invoke(object, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean isNull(String string) {
        return string == null || "".equals(string.trim());
    }

    <T extends CatalogInfo> T detached(T original, T detached) {
        return detached != null ? detached : original;
    }

    protected List<RuntimeException> postValidate(CatalogInfo info, boolean isNew) {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        for (CatalogValidator constraint : this.getValidators()) {
            try {
                info.accept(new CatalogValidatorVisitor(constraint, isNew));
            }
            catch (RuntimeException e) {
                errors.add(e);
            }
        }
        return errors;
    }

    public void sync(CatalogImpl other) {
        other.facade.syncTo(this.facade);
        this.listeners = other.listeners;
        if (this.resourcePool != other.resourcePool) {
            this.resourcePool.dispose();
            this.resourcePool = other.resourcePool;
        }
        this.resourceLoader = other.resourceLoader;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    static class CatalogValidatorVisitor
    implements CatalogVisitor {
        CatalogValidator validator;
        boolean isNew;

        CatalogValidatorVisitor(CatalogValidator validator, boolean isNew) {
            this.validator = validator;
            this.isNew = isNew;
        }

        public void visit(Catalog catalog) {
        }

        public void visit(WorkspaceInfo workspace) {
            this.validator.validate(workspace, this.isNew);
        }

        public void visit(NamespaceInfo namespace) {
            this.validator.validate(namespace, this.isNew);
        }

        public void visit(DataStoreInfo dataStore) {
            this.validator.validate(dataStore, this.isNew);
        }

        public void visit(CoverageStoreInfo coverageStore) {
            this.validator.validate(coverageStore, this.isNew);
        }

        public void visit(WMSStoreInfo wmsStore) {
            this.validator.validate(wmsStore, this.isNew);
        }

        public void visit(FeatureTypeInfo featureType) {
            this.validator.validate(featureType, this.isNew);
        }

        public void visit(CoverageInfo coverage) {
            this.validator.validate(coverage, this.isNew);
        }

        public void visit(LayerInfo layer) {
            this.validator.validate(layer, this.isNew);
        }

        public void visit(StyleInfo style) {
            this.validator.validate(style, this.isNew);
        }

        public void visit(LayerGroupInfo layerGroup) {
            this.validator.validate(layerGroup, this.isNew);
        }

        public void visit(WMSLayerInfo wmsLayer) {
            this.validator.validate(wmsLayer, this.isNew);
        }
    }
}

