/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.FacetHandler;
import org.geotools.xml.handlers.xsi.ListHandler;
import org.geotools.xml.handlers.xsi.RestrictionHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.handlers.xsi.UnionHandler;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SimpleTypeGT;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class SimpleTypeHandler
extends XSIElementHandler {
    public static final int NONE = 0;
    public static final int ALL = 7;
    public static final String LOCALNAME = "simpleType";
    private static int offset = 0;
    private String id;
    private String name;
    private int finaL;
    private XSIElementHandler child;
    private int hashCodeOffset = SimpleTypeHandler.getOffset();
    private SimpleType cache;

    private static int getOffset() {
        return offset++;
    }

    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) * (this.finaL == 0 ? 1 : this.finaL) * (this.name == null ? 1 : this.name.hashCode()) + this.hashCodeOffset;
    }

    public XSIElementHandler getHandler(String namespaceURI, String localName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            if ("list".equalsIgnoreCase(localName)) {
                ListHandler lh = new ListHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one '" + "list" + "' declaration.");
                }
                this.child = lh;
                return lh;
            }
            if ("restriction".equalsIgnoreCase(localName)) {
                RestrictionHandler lh = new RestrictionHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one '" + "restriction" + "' declaration.");
                }
                this.child = lh;
                return lh;
            }
            if ("union".equalsIgnoreCase(localName)) {
                UnionHandler lh = new UnionHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one '" + "union" + "' declaration.");
                }
                this.child = lh;
                return lh;
            }
        }
        return null;
    }

    public void startElement(String namespaceURI, String localName, Attributes atts) {
        String finaL1;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((finaL1 = atts.getValue("", "final")) == null) {
            finaL1 = atts.getValue(namespaceURI, "final");
        }
        this.finaL = SimpleTypeHandler.findFinal(finaL1);
        this.name = atts.getValue("", "name");
        if (this.name == null) {
            this.name = atts.getValue(namespaceURI, "name");
        }
    }

    public static int findFinal(String finaL) {
        if (finaL == null || "".equalsIgnoreCase(finaL)) {
            return 0;
        }
        String[] tokens = finaL.split("\\s");
        int r = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if ("#all".equalsIgnoreCase(tokens[i])) {
                r = 7;
                i = tokens.length;
                continue;
            }
            if ("union".equalsIgnoreCase(tokens[i])) {
                ++r;
                continue;
            }
            if ("list".equalsIgnoreCase(tokens[i])) {
                r += 2;
                continue;
            }
            if (!"restriction".equalsIgnoreCase(tokens[i])) continue;
            r += 4;
        }
        return r;
    }

    public String getLocalName() {
        return LOCALNAME;
    }

    public String getName() {
        return this.name;
    }

    protected SimpleType compress(SchemaHandler parent) {
        logger.info("Start compressing SimpleType " + this.getName());
        if (this.cache != null) {
            return this.cache;
        }
        Facet[] facets = null;
        if (this.child.getHandlerType() == 4) {
            facets = SimpleTypeHandler.getFacets((RestrictionHandler)this.child);
        }
        SimpleType[] simpleTypes = SimpleTypeHandler.getSimpleTypes(this.child, parent);
        this.cache = new SimpleTypeGT(this.id, this.name, parent.getTargetNamespace(), this.child.getHandlerType(), simpleTypes, facets, this.finaL);
        logger.info("End compressing SimpleType " + this.getName());
        this.id = null;
        this.child = null;
        return this.cache;
    }

    static SimpleType[] getSimpleTypes(XSIElementHandler child, SchemaHandler parent) {
        switch (child.getHandlerType()) {
            case 4: {
                return SimpleTypeHandler.getSimpleTypes((RestrictionHandler)child, parent);
            }
            case 2: {
                return SimpleTypeHandler.getSimpleTypes((ListHandler)child, parent);
            }
            case 1: {
                return SimpleTypeHandler.getSimpleTypes((UnionHandler)child, parent);
            }
        }
        throw new RuntimeException("Should not be here ... child is one of the other three types.");
    }

    static SimpleType[] getSimpleTypes(RestrictionHandler rest, SchemaHandler parent) {
        SimpleType[] children = new SimpleType[]{rest.getChild() != null ? ((SimpleTypeHandler)rest.getChild()).compress(parent) : parent.lookUpSimpleType(rest.getBase())};
        return children;
    }

    static SimpleType[] getSimpleTypes(ListHandler rest, SchemaHandler parent) {
        SimpleType[] children = new SimpleType[]{rest.getSimpleType() != null ? rest.getSimpleType().compress(parent) : parent.lookUpSimpleType(rest.getItemType())};
        return children;
    }

    static SimpleType[] getSimpleTypes(UnionHandler union, SchemaHandler parent) {
        LinkedList<SimpleType> l = new LinkedList<SimpleType>();
        if (union.getMemberTypes() != null) {
            String[] qNames = union.getMemberTypes().split("\\s");
            for (int i = 0; i < qNames.length; ++i) {
                l.add(parent.lookUpSimpleType(qNames[i]));
            }
        }
        if (union.getSimpleTypes() != null) {
            Iterator i = union.getSimpleTypes().iterator();
            while (i.hasNext()) {
                l.add(((SimpleTypeHandler)i.next()).compress(parent));
            }
        }
        return l.toArray(new SimpleType[l.size()]);
    }

    static Facet[] getFacets(RestrictionHandler rh) {
        List contraints = rh.getConstraints();
        if (contraints == null || contraints.size() == 0) {
            return null;
        }
        Facet[] facets = new Facet[contraints.size()];
        Iterator i = contraints.iterator();
        int index = 0;
        while (i.hasNext()) {
            FacetHandler fh = (FacetHandler)i.next();
            facets[index] = new FacetGT(fh.getType(), fh.getValue());
            ++index;
        }
        return facets;
    }

    public int getHandlerType() {
        return 8;
    }

    public void endElement(String namespaceURI, String localName) {
    }
}

