/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLDebugGridLayer
extends TileLayer {
    public static final String LAYERNAME = "debugGrid";
    public static final int IS_KMZ = 100;
    private static GridSetBroker gridSetBroker = new GridSetBroker(false, false);
    private static KMLDebugGridLayer instance;

    private KMLDebugGridLayer() {
        this.subSets = new Hashtable();
        this.subSets.put(KMLDebugGridLayer.gridSetBroker.WORLD_EPSG4326.getName(), GridSubsetFactory.createGridSubSet((GridSet)KMLDebugGridLayer.gridSetBroker.WORLD_EPSG4326, (BoundingBox)BoundingBox.WORLD4326, (Integer)0, (Integer)3));
    }

    public static synchronized KMLDebugGridLayer getInstance() {
        if (instance == null) {
            instance = new KMLDebugGridLayer();
        }
        return instance;
    }

    public void acquireLayerLock() {
    }

    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        return null;
    }

    public BoundingBox getBounds(SRS srs) {
        return new BoundingBox(-180.0, -90.0, 180.0, 90.0);
    }

    public MimeType getDefaultMimeType() {
        return null;
    }

    public int[] getMetaTilingFactors() {
        return null;
    }

    public List<MimeType> getMimeTypes() {
        return null;
    }

    public String getName() {
        return "Debug grid";
    }

    public SRS[] getProjections() {
        SRS[] srsList = new SRS[]{SRS.getEPSG4326()};
        return srsList;
    }

    public double[] getResolutions(int srsIdx) {
        return null;
    }

    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException {
        long[] gridLoc = tile.getTileIndex();
        BoundingBox bbox = tile.getGridSubset().boundsFromIndex(gridLoc);
        String data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n<Document>\n<Placemark id=\"PlaceMarkId\">\n<name>" + gridLoc[0] + "," + gridLoc[1] + "," + gridLoc[2] + "</name>" + "<Style id=\"square\">\n" + "<PolyStyle><color>7fffffff</color><colorMode>random</colorMode>\n" + "</PolyStyle>\n" + "<IconStyle><Icon><href>http://icons.opengeo.org/dynamic/circle/aaffaa_aaffaa_2.png</href></Icon></IconStyle>\n" + "<LabelStyle id=\"name\"><color>ffffffff</color><colorMode>normal</colorMode><scale>1.0</scale></LabelStyle>\n" + "</Style>\n" + "<MultiGeometry>\n" + "<Point><coordinates>" + (bbox.getMinX() + bbox.getMaxX()) / 2.0 + "," + (bbox.getMinY() + bbox.getMaxY()) / 2.0 + ",0</coordinates></Point>\n" + "<Polygon><outerBoundaryIs><LinearRing>\n" + "<coordinates decimal=\".\" cs=\",\" ts=\" \">\n" + bbox.getMinX() + "," + bbox.getMinY() + " " + bbox.getMaxX() + "," + bbox.getMinY() + " " + bbox.getMaxX() + "," + bbox.getMaxY() + " " + bbox.getMinX() + "," + bbox.getMaxY() + "</coordinates>\n" + "</LinearRing></outerBoundaryIs></Polygon>\n" + "</MultiGeometry>\n" + "</Placemark>\n" + "</Document>\n" + "</kml>";
        tile.setBlob((Resource)new ByteArrayResource(data.getBytes()));
        tile.setStatus(200);
        return tile;
    }

    public String getStyles() {
        return null;
    }

    public int[][] getZoomInGridLoc(SRS srs, int[] gridLoc) {
        int[][] retVal = new int[4][3];
        int x = gridLoc[0] * 2;
        int y = gridLoc[1] * 2;
        int z = gridLoc[2] + 1;
        if (z > 25) {
            z = -1;
        }
        int n = x;
        retVal[2][0] = n;
        retVal[0][0] = n;
        int n2 = x + 1;
        retVal[3][0] = n2;
        retVal[1][0] = n2;
        int n3 = y;
        retVal[1][1] = n3;
        retVal[0][1] = n3;
        int n4 = y + 1;
        retVal[3][1] = n4;
        retVal[2][1] = n4;
        int n5 = z;
        retVal[3][2] = n5;
        retVal[2][2] = n5;
        retVal[1][2] = n5;
        retVal[0][2] = n5;
        return retVal;
    }

    public int getZoomStart() {
        return 0;
    }

    public int getZoomStop() {
        return 25;
    }

    public boolean initializeInternal(GridSetBroker gridSetBroker) {
        return true;
    }

    public void releaseLayerLock() {
    }

    public void setExpirationHeader(HttpServletResponse response, int zoomLevel) {
    }

    public String supportsBbox(SRS srs, BoundingBox bounds) throws GeoWebCacheException {
        return null;
    }

    public boolean supportsFormat(String formatStr) throws GeoWebCacheException {
        return false;
    }

    public boolean supportsSRS(SRS srs) throws GeoWebCacheException {
        return false;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
    }

    public int getType() {
        return 0;
    }

    public void init() {
    }

    public BoundingBox getBboxForGridLoc(SRS srs, int[] gridLoc) {
        double tileWidth = 180.0 / Math.pow(2.0, gridLoc[2]);
        BoundingBox bbox = new BoundingBox(-180.0 + tileWidth * (double)gridLoc[0], -90.0 + tileWidth * (double)gridLoc[1], -180.0 + tileWidth * (double)(gridLoc[0] + 1), -90.0 + tileWidth * (double)(gridLoc[1] + 1));
        return bbox;
    }

    public int[][] getCoveredGridLevels(SRS srs, BoundingBox bounds) {
        return null;
    }

    public int[] getGridLocForBounds(SRS srs, BoundingBox bounds) throws BadTileException {
        return null;
    }

    public int[] getZoomedOutGridLoc(SRS srs) {
        int[] zoomedOutGridLoc = new int[]{-1, -1, -1};
        return zoomedOutGridLoc;
    }

    public Integer getBackendTimeout() {
        return null;
    }

    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        return null;
    }

    public Boolean isCacheBypassAllowed() {
        return null;
    }

    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
    }

    public void setBackendTimeout(int seconds) {
    }

    public void setCacheBypassAllowed(boolean allowed) {
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }
}

