/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.FilterDOMParser;
import org.geotools.resources.i18n.Errors;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.Extent;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeConstraintImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedLayerImpl;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.OtherText;
import org.geotools.styling.OtherTextImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.RemoteOWSImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDInlineFeatureParser;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.UserLayer;
import org.geotools.styling.UserLayerImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SLDParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.styling");
    private static final String channelSelectionString = "ChannelSelection";
    private static final String graphicSt = "Graphic";
    private static final String geomString = "Geometry";
    private static final String fillSt = "Fill";
    private static final String opacityString = "Opacity";
    private static final String overlapBehaviorString = "OverlapBehavior";
    private static final String colorMapString = "ColorMap";
    private static final String colorMapOpacityString = "opacity";
    private static final String colorMapColorString = "color";
    private static final String contrastEnhancementString = "ContrastEnhancement";
    private static final String shadedReliefString = "ShadedRelief";
    private static final String imageOutlineString = "ImageOutline";
    private static final String colorMapQuantityString = "quantity";
    private static final String colorMapLabelString = "label";
    private static final String strokeString = "Stroke";
    private static final String uomString = "uom";
    private static final Pattern WHITESPACES = Pattern.compile("\\s+", 8);
    private static final Pattern LEADING_WHITESPACES = Pattern.compile("^\\s+");
    private static final Pattern TRAILING_WHITESPACES = Pattern.compile("\\s+$");
    private FilterFactory ff;
    protected InputSource source;
    private Document dom;
    protected StyleFactory factory;
    private URL sourceUrl;

    public SLDParser(StyleFactory factory) {
        this(factory, CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public SLDParser(StyleFactory factory, FilterFactory filterFactory) {
        this.factory = factory;
        this.ff = filterFactory;
    }

    public SLDParser(StyleFactory factory, String filename) throws FileNotFoundException {
        this(factory);
        File f = new File(filename);
        this.setInput(f);
    }

    public SLDParser(StyleFactory factory, File f) throws FileNotFoundException {
        this(factory);
        this.setInput(f);
    }

    public SLDParser(StyleFactory factory, URL url) throws IOException {
        this(factory);
        this.setInput(url);
    }

    public SLDParser(StyleFactory factory, InputStream s) {
        this(factory);
        this.setInput(s);
    }

    public SLDParser(StyleFactory factory, Reader r) {
        this(factory);
        this.setInput(r);
    }

    public void setInput(String filename) throws FileNotFoundException {
        File f = new File(filename);
        this.source = new InputSource(new FileInputStream(f));
        try {
            this.sourceUrl = f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Can't build URL for file " + f.getAbsolutePath());
        }
    }

    public void setInput(File f) throws FileNotFoundException {
        this.source = new InputSource(new FileInputStream(f));
        try {
            this.sourceUrl = f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Can't build URL for file " + f.getAbsolutePath());
        }
    }

    public void setInput(URL url) throws IOException {
        this.source = new InputSource(url.openStream());
        this.sourceUrl = url;
    }

    public void setInput(InputStream in) {
        this.source = new InputSource(in);
    }

    public void setInput(Reader in) {
        this.source = new InputSource(in);
    }

    public Style[] readXML() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.source);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
        return this.readDOM(this.dom);
    }

    public Style[] readDOM() {
        if (this.dom == null) {
            throw new NullPointerException("dom is null");
        }
        return this.readDOM(this.dom);
    }

    public Style[] readDOM(Document document) {
        this.dom = document;
        NodeList nodes = this.findElements(document, "UserStyle");
        int length = nodes.getLength();
        if (nodes == null) {
            return new Style[0];
        }
        Style[] styles = new Style[length];
        for (int i = 0; i < length; ++i) {
            styles[i] = this.parseStyle(nodes.item(i));
        }
        return styles;
    }

    private NodeList findElements(Document document, String name) {
        NodeList nodes = document.getElementsByTagNameNS("*", name);
        if (nodes.getLength() == 0) {
            nodes = document.getElementsByTagName(name);
        }
        return nodes;
    }

    private NodeList findElements(Element element, String name) {
        NodeList nodes = element.getElementsByTagNameNS("*", name);
        if (nodes.getLength() == 0) {
            nodes = element.getElementsByTagName(name);
        }
        return nodes;
    }

    public StyledLayerDescriptor parseSLD() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.source);
            StyledLayerDescriptor sld = this.parseDescriptor(this.dom.getDocumentElement());
            return sld;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    public StyledLayerDescriptor parseDescriptor(Node root) {
        StyledLayerDescriptor sld = this.factory.createStyledLayerDescriptor();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            StyledLayer layer;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                sld.setName(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Title")) {
                sld.setTitle(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                sld.setAbstract(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("NamedLayer")) {
                layer = this.parseNamedLayer(child);
                sld.addStyledLayer(layer);
                continue;
            }
            if (!childName.equalsIgnoreCase("UserLayer")) continue;
            layer = this.parseUserLayer(child);
            sld.addStyledLayer(layer);
        }
        return sld;
    }

    String getFirstChildValue(Node child) {
        if (child.getFirstChild() != null) {
            return child.getFirstChild().getNodeValue();
        }
        return null;
    }

    private StyledLayer parseUserLayer(Node root) {
        UserLayerImpl layer = new UserLayerImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("InlineFeature")) {
                this.parseInlineFeature(child, layer);
                continue;
            }
            if (childName.equalsIgnoreCase("UserStyle")) {
                Style user = this.parseStyle(child);
                layer.addUserStyle(user);
                continue;
            }
            if (childName.equalsIgnoreCase("Name")) {
                String layerName = this.getFirstChildValue(child);
                layer.setName(layerName);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("layer name: " + layer.getName());
                continue;
            }
            if (childName.equalsIgnoreCase("RemoteOWS")) {
                RemoteOWS remoteOws = this.parseRemoteOWS(child);
                layer.setRemoteOWS(remoteOws);
                continue;
            }
            if (!childName.equalsIgnoreCase("LayerFeatureConstraints")) continue;
            layer.setLayerFeatureConstraints(this.parseLayerFeatureConstraints(child));
        }
        return layer;
    }

    private FeatureTypeConstraint[] parseLayerFeatureConstraints(Node root) {
        ArrayList<FeatureTypeConstraint> featureTypeConstraints = new ArrayList<FeatureTypeConstraint>();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            FeatureTypeConstraint ftc;
            String childName;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1 || !(childName = child.getLocalName()).equalsIgnoreCase("FeatureTypeConstraint") || (ftc = this.parseFeatureTypeConstraint(child)) == null) continue;
            featureTypeConstraints.add(ftc);
        }
        return featureTypeConstraints.toArray(new FeatureTypeConstraint[featureTypeConstraints.size()]);
    }

    protected FeatureTypeConstraint parseFeatureTypeConstraint(Node root) {
        FeatureTypeConstraintImpl ftc = new FeatureTypeConstraintImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equalsIgnoreCase("FeatureTypeName")) {
                ftc.setFeatureTypeName(this.getFirstChildValue(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("Filter")) continue;
            ftc.setFilter(this.parseFilter(child));
        }
        ftc.setExtents(new Extent[0]);
        if (ftc.getFeatureTypeName() == null) {
            return null;
        }
        return ftc;
    }

    protected RemoteOWS parseRemoteOWS(Node root) {
        RemoteOWSImpl ows = new RemoteOWSImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equalsIgnoreCase("Service")) {
                ows.setService(this.getFirstChildValue(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("OnlineResource")) continue;
            ows.setOnlineResource(this.parseOnlineResource(child));
        }
        return ows;
    }

    private void parseInlineFeature(Node root, UserLayer layer) {
        try {
            SLDInlineFeatureParser inparser = new SLDInlineFeatureParser(root);
            layer.setInlineFeatureDatastore(inparser.dataStore);
            layer.setInlineFeatureType(inparser.featureType);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    private NamedLayer parseNamedLayer(Node root) {
        NamedLayerImpl layer = new NamedLayerImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                layer.setName(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("NamedStyle")) {
                NamedStyle style = this.parseNamedStyle(child);
                layer.addStyle(style);
                continue;
            }
            if (childName.equalsIgnoreCase("UserStyle")) {
                Style user = this.parseStyle(child);
                layer.addStyle(user);
                continue;
            }
            if (!childName.equalsIgnoreCase("LayerFeatureConstraints")) continue;
            layer.setLayerFeatureConstraints(this.parseLayerFeatureConstraints(child));
        }
        return layer;
    }

    public NamedStyle parseNamedStyle(Node n) {
        if (this.dom == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.dom = db.newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        NamedStyle style = this.factory.createNamedStyle();
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("" + children.getLength() + " children to process");
        }
        for (int j = 0; j < length; ++j) {
            String childName;
            Node child = children.item(j);
            if (child == null || child.getNodeType() != 1 || child.getFirstChild() == null) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if ((childName = child.getLocalName()) == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("Name")) continue;
            style.setName(this.getFirstChildValue(child));
        }
        return style;
    }

    public Style parseStyle(Node n) {
        if (this.dom == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.dom = db.newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        Style style = this.factory.createStyle();
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("" + children.getLength() + " children to process");
        }
        for (int j = 0; j < length; ++j) {
            String childName;
            Node child = children.item(j);
            if (child == null || child.getNodeType() != 1 || child.getFirstChild() == null) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if ((childName = child.getLocalName()) == null) {
                childName = child.getNodeName();
            }
            String firstChildValue = this.getFirstChildValue(child);
            if (childName.equalsIgnoreCase("Name")) {
                style.setName(firstChildValue);
                continue;
            }
            if (childName.equalsIgnoreCase("Title")) {
                style.setTitle(firstChildValue);
                continue;
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                style.setAbstract(firstChildValue);
                continue;
            }
            if (childName.equalsIgnoreCase("IsDefault")) {
                if ("1".equals(firstChildValue)) {
                    style.setDefault(true);
                    continue;
                }
                style.setDefault(Boolean.valueOf(firstChildValue));
                continue;
            }
            if (!childName.equalsIgnoreCase("FeatureTypeStyle")) continue;
            style.addFeatureTypeStyle(this.parseFeatureTypeStyle(child));
        }
        return style;
    }

    protected FeatureTypeStyle parseFeatureTypeStyle(Node style) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Parsing featuretype style " + style.getLocalName());
        }
        FeatureTypeStyle ft = this.factory.createFeatureTypeStyle();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<String> sti = new ArrayList<String>();
        NodeList children = style.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            String childName;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if ((childName = child.getLocalName()) == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                ft.setName(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Title")) {
                ft.setTitle(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                ft.setAbstract(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("FeatureTypeName")) {
                ft.setFeatureTypeName(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("SemanticTypeIdentifier")) {
                sti.add(this.getFirstChildValue(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("Rule")) continue;
            rules.add(this.parseRule(child));
        }
        if (sti.size() > 0) {
            ft.setSemanticTypeIdentifiers(sti.toArray(new String[0]));
        }
        ft.setRules(rules.toArray(new Rule[0]));
        return ft;
    }

    protected Rule parseRule(Node ruleNode) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Parsing rule " + ruleNode.getLocalName());
        }
        Rule rule = this.factory.createRule();
        ArrayList<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
        NodeList children = ruleNode.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.indexOf(58) != -1) {
                childName = childName.substring(childName.indexOf(58) + 1);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if (childName.equalsIgnoreCase("Name")) {
                rule.setName(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Title")) {
                rule.setTitle(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                rule.setAbstract(this.getFirstChildValue(child));
                continue;
            }
            if (childName.equalsIgnoreCase("MinScaleDenominator")) {
                rule.setMinScaleDenominator(Double.parseDouble(this.getFirstChildValue(child)));
                continue;
            }
            if (childName.equalsIgnoreCase("MaxScaleDenominator")) {
                rule.setMaxScaleDenominator(Double.parseDouble(this.getFirstChildValue(child)));
                continue;
            }
            if (childName.equalsIgnoreCase("Filter")) {
                Filter filter = this.parseFilter(child);
                rule.setFilter(filter);
                continue;
            }
            if (childName.equalsIgnoreCase("ElseFilter")) {
                rule.setElseFilter(true);
                continue;
            }
            if (childName.equalsIgnoreCase("LegendGraphic")) {
                this.findElements((Element)child, graphicSt);
                NodeList g = this.findElements((Element)child, graphicSt);
                ArrayList<Graphic> legends = new ArrayList<Graphic>();
                int l = g.getLength();
                for (int k = 0; k < l; ++k) {
                    legends.add(this.parseGraphic(g.item(k)));
                }
                rule.setLegendGraphic(legends.toArray(new Graphic[0]));
                continue;
            }
            if (childName.equalsIgnoreCase("LineSymbolizer")) {
                symbolizers.add(this.parseLineSymbolizer(child));
                continue;
            }
            if (childName.equalsIgnoreCase("PolygonSymbolizer")) {
                symbolizers.add(this.parsePolygonSymbolizer(child));
                continue;
            }
            if (childName.equalsIgnoreCase("PointSymbolizer")) {
                symbolizers.add(this.parsePointSymbolizer(child));
                continue;
            }
            if (childName.equalsIgnoreCase("TextSymbolizer")) {
                symbolizers.add(this.parseTextSymbolizer(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("RasterSymbolizer")) continue;
            symbolizers.add(this.parseRasterSymbolizer(child));
        }
        rule.setSymbolizers(symbolizers.toArray(new Symbolizer[0]));
        return rule;
    }

    protected Filter parseFilter(Node child) {
        Node firstChild;
        for (firstChild = child.getFirstChild(); firstChild != null && firstChild.getNodeType() != 1; firstChild = firstChild.getNextSibling()) {
        }
        Filter filter = FilterDOMParser.parseFilter(firstChild);
        return filter;
    }

    protected LineSymbolizer parseLineSymbolizer(Node root) {
        LineSymbolizer symbol = this.factory.createLineSymbolizer();
        NamedNodeMap namedNodeMap = root.getAttributes();
        Node uomNode = namedNodeMap.getNamedItem(uomString);
        if (uomNode != null) {
            UomOgcMapping uomMapping = UomOgcMapping.get(uomNode.getNodeValue());
            symbol.setUnitOfMeasure(uomMapping.getUnit());
        }
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(geomString)) {
                symbol.setGeometry(this.parseGeometry(child));
                continue;
            }
            if (!childName.equalsIgnoreCase(strokeString)) continue;
            symbol.setStroke(this.parseStroke(child));
        }
        return symbol;
    }

    protected PolygonSymbolizer parsePolygonSymbolizer(Node root) {
        PolygonSymbolizer symbol = this.factory.createPolygonSymbolizer();
        symbol.setFill(null);
        symbol.setStroke(null);
        NamedNodeMap namedNodeMap = root.getAttributes();
        Node uomNode = namedNodeMap.getNamedItem(uomString);
        if (uomNode != null) {
            UomOgcMapping uomMapping = UomOgcMapping.get(uomNode.getNodeValue());
            symbol.setUnitOfMeasure(uomMapping.getUnit());
        }
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(geomString)) {
                symbol.setGeometry(this.parseGeometry(child));
                continue;
            }
            if (childName.equalsIgnoreCase(strokeString)) {
                symbol.setStroke(this.parseStroke(child));
                continue;
            }
            if (!childName.equalsIgnoreCase(fillSt)) continue;
            symbol.setFill(this.parseFill(child));
        }
        return symbol;
    }

    protected TextSymbolizer parseTextSymbolizer(Node root) {
        TextSymbolizer symbol = this.factory.createTextSymbolizer();
        symbol.setFill(null);
        NamedNodeMap namedNodeMap = root.getAttributes();
        Node uomNode = namedNodeMap.getNamedItem(uomString);
        if (uomNode != null) {
            UomOgcMapping uomMapping = UomOgcMapping.get(uomNode.getNodeValue());
            symbol.setUnitOfMeasure(uomMapping.getUnit());
        }
        ArrayList<Font> fonts = new ArrayList<Font>();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(geomString)) {
                symbol.setGeometry(this.parseGeometry(child));
            } else if (childName.equalsIgnoreCase(fillSt)) {
                symbol.setFill(this.parseFill(child));
            } else if (childName.equalsIgnoreCase("Label")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("parsing label " + child.getNodeValue());
                }
                symbol.setLabel(this.parseCssParameter(child, false));
                if (symbol.getLabel() == null && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("parsing TextSymbolizer node - couldnt find anything in the Label element!");
                }
            }
            if (childName.equalsIgnoreCase("Font")) {
                fonts.add(this.parseFont(child));
                continue;
            }
            if (childName.equalsIgnoreCase("LabelPlacement")) {
                symbol.setPlacement(this.parseLabelPlacement(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Halo")) {
                symbol.setHalo(this.parseHalo(child));
                continue;
            }
            if (childName.equalsIgnoreCase(graphicSt)) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Parsing non-standard Graphic in TextSymbolizer");
                }
                if (!(symbol instanceof TextSymbolizer2)) continue;
                ((TextSymbolizer2)symbol).setGraphic(this.parseGraphic(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Snippet")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Parsing non-standard Abstract in TextSymbolizer");
                }
                if (!(symbol instanceof TextSymbolizer2)) continue;
                ((TextSymbolizer2)symbol).setSnippet(this.parseCssParameter(child, false));
                continue;
            }
            if (childName.equalsIgnoreCase("FeatureDescription")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Parsing non-standard Description in TextSymbolizer");
                }
                if (!(symbol instanceof TextSymbolizer2)) continue;
                ((TextSymbolizer2)symbol).setFeatureDescription(this.parseCssParameter(child, false));
                continue;
            }
            if (childName.equalsIgnoreCase("OtherText")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Parsing non-standard OtherText in TextSymbolizer");
                }
                if (!(symbol instanceof TextSymbolizer2)) continue;
                ((TextSymbolizer2)symbol).setOtherText(this.parseOtherText(child));
                continue;
            }
            if (childName.equalsIgnoreCase("priority")) {
                symbol.setPriority(this.parseCssParameter(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("vendoroption")) continue;
            this.parseVendorOption(symbol, child);
        }
        symbol.setFonts(fonts.toArray(new Font[0]));
        return symbol;
    }

    protected OtherText parseOtherText(Node root) {
        OtherTextImpl ot = new OtherTextImpl();
        Node targetAttribute = root.getAttributes().getNamedItem("target");
        if (targetAttribute == null) {
            throw new IllegalArgumentException("OtherLocation does not have the required 'target' attribute");
        }
        String target = targetAttribute.getNodeValue();
        Expression text = this.parseCssParameter(root, true);
        ot.setTarget(target);
        ot.setText(text);
        return ot;
    }

    private void parseVendorOption(TextSymbolizer symbol, Node child) {
        String key = child.getAttributes().getNamedItem("name").getNodeValue();
        String value = this.getFirstChildValue(child);
        symbol.addToOptions(key, value);
    }

    protected RasterSymbolizer parseRasterSymbolizer(Node root) {
        RasterSymbolizer symbol = this.factory.getDefaultRasterSymbolizer();
        NamedNodeMap namedNodeMap = root.getAttributes();
        Node uomNode = namedNodeMap.getNamedItem(uomString);
        if (uomNode != null) {
            UomOgcMapping uomMapping = UomOgcMapping.get(uomNode.getNodeValue());
            symbol.setUnitOfMeasure(uomMapping.getUnit());
        }
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(geomString)) {
                symbol.setGeometry(this.parseGeometry(child));
            }
            if (childName.equalsIgnoreCase(opacityString)) {
                try {
                    String opacityString = this.getFirstChildValue(child);
                    Expression opacity = this.parseParameterValueExpression(child, false);
                    symbol.setOpacity(opacity);
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                continue;
            }
            if (childName.equalsIgnoreCase(channelSelectionString)) {
                symbol.setChannelSelection(this.parseChannelSelection(child));
                continue;
            }
            if (childName.equalsIgnoreCase(overlapBehaviorString)) {
                try {
                    String overlapString = child.getFirstChild().getLocalName();
                    symbol.setOverlap((Expression)this.ff.literal((Object)overlapString));
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                continue;
            }
            if (childName.equalsIgnoreCase(colorMapString)) {
                symbol.setColorMap(this.parseColorMap(child));
                continue;
            }
            if (childName.equalsIgnoreCase(contrastEnhancementString)) {
                symbol.setContrastEnhancement(this.parseContrastEnhancement(child));
                continue;
            }
            if (childName.equalsIgnoreCase(shadedReliefString)) {
                symbol.setShadedRelief(this.parseShadedRelief(child));
                continue;
            }
            if (!childName.equalsIgnoreCase(imageOutlineString)) continue;
            symbol.setImageOutline(this.parseLineSymbolizer(child));
        }
        return symbol;
    }

    Expression parseParameterValueExpression(Node root, boolean mixedText) {
        ExpressionDOMParser parser = new ExpressionDOMParser((FilterFactory2)this.ff);
        Expression expr = parser.expression(root);
        if (expr != null) {
            return expr;
        }
        NodeList children = root.getChildNodes();
        if (children.getLength() == 1 && root.getFirstChild() instanceof CharacterData) {
            Node textNode = root.getFirstChild();
            String text = textNode.getNodeValue();
            return this.ff.literal((Object)text.trim());
        }
        ArrayList<Object> expressionList = new ArrayList<Object>();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child instanceof CharacterData) {
                if (!mixedText) continue;
                String text = child.getNodeValue();
                Literal childExpr = this.ff.literal((Object)text);
                expressionList.add(childExpr);
                continue;
            }
            Expression childExpr = parser.expression(child);
            if (childExpr == null) continue;
            expressionList.add(childExpr);
        }
        if (expressionList.isEmpty()) {
            return Expression.NIL;
        }
        if (expressionList.size() == 1) {
            return (Expression)expressionList.get(0);
        }
        if (expressionList.size() == 2) {
            Expression[] expressionArray = expressionList.toArray(new Expression[0]);
            return this.ff.function("strConcat", expressionArray);
        }
        Expression[] expressionArray = expressionList.toArray(new Expression[0]);
        return this.ff.function("Concatenate", expressionArray);
    }

    protected ColorMapEntry parseColorMapEntry(Node root) {
        ColorMapEntry symbol = this.factory.createColorMapEntry();
        NamedNodeMap atts = root.getAttributes();
        if (atts.getNamedItem(colorMapLabelString) != null) {
            symbol.setLabel(atts.getNamedItem(colorMapLabelString).getNodeValue());
        }
        if (atts.getNamedItem(colorMapColorString) != null) {
            symbol.setColor((Expression)this.ff.literal((Object)atts.getNamedItem(colorMapColorString).getNodeValue()));
        }
        if (atts.getNamedItem(colorMapOpacityString) != null) {
            symbol.setOpacity((Expression)this.ff.literal((Object)atts.getNamedItem(colorMapOpacityString).getNodeValue()));
        }
        if (atts.getNamedItem(colorMapQuantityString) != null) {
            symbol.setQuantity((Expression)this.ff.literal((Object)atts.getNamedItem(colorMapQuantityString).getNodeValue()));
        }
        return symbol;
    }

    protected ColorMap parseColorMap(Node root) {
        ColorMap symbol = this.factory.createColorMap();
        if (root.hasAttributes()) {
            String type;
            NamedNodeMap atts = root.getAttributes();
            Node typeAtt = atts.getNamedItem("type");
            if (typeAtt != null) {
                type = typeAtt.getNodeValue();
                if ("ramp".equalsIgnoreCase(type)) {
                    symbol.setType(1);
                } else if ("intervals".equalsIgnoreCase(type)) {
                    symbol.setType(2);
                } else if ("values".equalsIgnoreCase(type)) {
                    symbol.setType(3);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(Errors.format((int)58, (Object)"ColorMapType", (Object)type));
                }
            }
            if ((typeAtt = atts.getNamedItem("extended")) != null) {
                type = typeAtt.getNodeValue();
                if ("true".equalsIgnoreCase(type)) {
                    symbol.setExtendedColors(true);
                } else if ("false".equalsIgnoreCase(type)) {
                    symbol.setExtendedColors(false);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(Errors.format((int)58, (Object)"Extended", (Object)type));
                }
            }
        }
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("ColorMapEntry")) continue;
            symbol.addColorMapEntry(this.parseColorMapEntry(child));
        }
        return symbol;
    }

    protected SelectedChannelType parseSelectedChannel(Node root) {
        SelectedChannelTypeImpl symbol = new SelectedChannelTypeImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
                continue;
            }
            if (childName.equalsIgnoreCase("SourceChannelName")) {
                if (child.getFirstChild() == null || child.getFirstChild().getNodeType() != 3) continue;
                symbol.setChannelName(this.getFirstChildValue(child));
                continue;
            }
            if (!childName.equalsIgnoreCase(contrastEnhancementString)) continue;
            symbol.setContrastEnhancement(this.parseContrastEnhancement(child));
        }
        return symbol;
    }

    protected ChannelSelection parseChannelSelection(Node root) {
        ArrayList<SelectedChannelType> channels = new ArrayList<SelectedChannelType>();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
                continue;
            }
            if (childName.equalsIgnoreCase("GrayChannel")) {
                channels.add(this.parseSelectedChannel(child));
                continue;
            }
            if (childName.equalsIgnoreCase("RedChannel")) {
                channels.add(this.parseSelectedChannel(child));
                continue;
            }
            if (childName.equalsIgnoreCase("GreenChannel")) {
                channels.add(this.parseSelectedChannel(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("BlueChannel")) continue;
            channels.add(this.parseSelectedChannel(child));
        }
        ChannelSelection dap = this.factory.createChannelSelection(channels.toArray(new SelectedChannelType[channels.size()]));
        return dap;
    }

    protected ContrastEnhancement parseContrastEnhancement(Node root) {
        ContrastEnhancementImpl symbol = new ContrastEnhancementImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Normalize")) {
                symbol.setNormalize();
                continue;
            }
            if (childName.equalsIgnoreCase("Histogram")) {
                symbol.setHistogram();
                continue;
            }
            if (childName.equalsIgnoreCase("Logarithmic")) {
                symbol.setLogarithmic();
                continue;
            }
            if (childName.equalsIgnoreCase("Exponential")) {
                symbol.setExponential();
                continue;
            }
            if (!childName.equalsIgnoreCase("GammaValue")) continue;
            try {
                String gammaString = this.getFirstChildValue(child);
                symbol.setGammaValue((Expression)this.ff.literal(Double.parseDouble(gammaString)));
                continue;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return symbol;
    }

    protected ShadedRelief parseShadedRelief(Node root) {
        ShadedReliefImpl symbol = new ShadedReliefImpl();
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if ("BrightnessOnly".equalsIgnoreCase(childName)) {
                symbol.setBrightnessOnly(Boolean.getBoolean(this.getFirstChildValue(child)));
                continue;
            }
            if (!"ReliefFactor".equalsIgnoreCase(childName)) continue;
            try {
                String reliefString = this.getFirstChildValue(child);
                Expression relief = ExpressionDOMParser.parseExpression(child);
                symbol.setReliefFactor(relief);
                continue;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return symbol;
    }

    protected PointSymbolizer parsePointSymbolizer(Node root) {
        PointSymbolizer symbol = this.factory.getDefaultPointSymbolizer();
        NamedNodeMap namedNodeMap = root.getAttributes();
        Node uomNode = namedNodeMap.getNamedItem(uomString);
        if (uomNode != null) {
            UomOgcMapping uomMapping = UomOgcMapping.get(uomNode.getNodeValue());
            symbol.setUnitOfMeasure(uomMapping.getUnit());
        }
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(geomString)) {
                symbol.setGeometry(this.parseGeometry(child));
                continue;
            }
            if (!childName.equalsIgnoreCase(graphicSt)) continue;
            symbol.setGraphic(this.parseGraphic(child));
        }
        return symbol;
    }

    protected Graphic parseGraphic(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("processing graphic " + root);
        }
        Graphic graphic = this.factory.createGraphic(null, null, null, null, null, null);
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(geomString)) {
                graphic.setGeometryPropertyName(this.parseGeometryName(child));
                continue;
            }
            if (childName.equalsIgnoreCase("ExternalGraphic")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("parsing extgraphic " + child);
                }
                graphic.addExternalGraphic(this.parseExternalGraphic(child));
                continue;
            }
            if (childName.equalsIgnoreCase("Mark")) {
                graphic.addMark(this.parseMark(child));
                continue;
            }
            if (childName.equalsIgnoreCase(opacityString)) {
                graphic.setOpacity(this.parseCssParameter(child));
                continue;
            }
            if (childName.equalsIgnoreCase("size")) {
                graphic.setSize(this.parseCssParameter(child));
                continue;
            }
            if (childName.equalsIgnoreCase("displacement")) {
                graphic.setDisplacement(this.parseDisplacement(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("rotation")) continue;
            graphic.setRotation(this.parseCssParameter(child));
        }
        return graphic;
    }

    protected String parseGeometryName(Node root) {
        Expression result = this.parseGeometry(root);
        if (result instanceof PropertyName) {
            return ((PropertyName)result).getPropertyName();
        }
        return null;
    }

    protected Expression parseGeometry(Node root) {
        if (LOGGER.isLoggable(Level.FINEST) && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing GeometryExpression");
        }
        return this.parseCssParameter(root);
    }

    protected Mark parseMark(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing mark");
        }
        Mark mark = this.factory.createMark();
        mark.setFill(null);
        mark.setStroke(null);
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(strokeString)) {
                mark.setStroke(this.parseStroke(child));
                continue;
            }
            if (childName.equalsIgnoreCase(fillSt)) {
                mark.setFill(this.parseFill(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("WellKnownName")) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("setting mark to " + this.getFirstChildValue(child));
            }
            mark.setWellKnownName(this.parseCssParameter(child));
        }
        return mark;
    }

    protected ExternalGraphic parseExternalGraphic(Node root) {
        URL url;
        HashMap<String, Object> paramList;
        String uri;
        String format;
        block12: {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing external graphic ");
            }
            format = "";
            uri = "";
            paramList = new HashMap<String, Object>();
            NodeList children = root.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase("OnLineResource")) {
                    uri = this.parseOnlineResource(child);
                }
                if (childName.equalsIgnoreCase("format")) {
                    LOGGER.finest("format child is " + child);
                    LOGGER.finest("seting ExtGraph format " + this.getFirstChildValue(child));
                    format = this.getFirstChildValue(child);
                    continue;
                }
                if (!childName.equalsIgnoreCase("customProperty")) continue;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("custom child is " + child);
                }
                String propName = child.getAttributes().getNamedItem("name").getNodeValue();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("seting custom property " + propName + " to " + this.getFirstChildValue(child));
                }
                Expression value = this.parseCssParameter(child);
                paramList.put(propName, value);
            }
            url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException mfe) {
                LOGGER.fine("Looks like " + uri + " is a relative path..");
                if (this.sourceUrl != null) {
                    try {
                        url = new URL(this.sourceUrl, uri);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.warning("can't parse " + uri + " as relative to" + this.sourceUrl.toExternalForm());
                    }
                }
                if (url != null || (url = this.getClass().getResource(uri)) != null) break block12;
                LOGGER.warning("can't parse " + uri + " as a java resource present in the classpath");
            }
        }
        ExternalGraphic extgraph = url == null ? this.factory.createExternalGraphic(uri, format) : this.factory.createExternalGraphic(url, format);
        extgraph.setCustomProperties(paramList);
        return extgraph;
    }

    protected String parseOnlineResource(Node root) {
        Element param = (Element)root;
        NamedNodeMap map = param.getAttributes();
        int length = map.getLength();
        LOGGER.finest("attributes " + map.toString());
        for (int k = 0; k < length; ++k) {
            String res = map.item(k).getNodeValue();
            String name = map.item(k).getNodeName();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing attribute " + name + "=" + res);
            }
            if (!name.equalsIgnoreCase("xlink:href") && !name.equalsIgnoreCase("href")) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("seting ExtGraph uri " + res);
            }
            return res;
        }
        return null;
    }

    protected Stroke parseStroke(Node root) {
        Graphic g;
        String childName;
        Node child;
        int i;
        NodeList kids;
        Stroke stroke = this.factory.getDefaultStroke();
        NodeList list = this.findElements((Element)root, "GraphicFill");
        int length = list.getLength();
        if (length > 0) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("stroke: found a graphic fill " + list.item(0));
            }
            kids = list.item(0).getChildNodes();
            for (i = 0; i < kids.getLength(); ++i) {
                child = kids.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (!childName.equalsIgnoreCase(graphicSt)) continue;
                g = this.parseGraphic(child);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("setting stroke graphicfill with " + g);
                }
                stroke.setGraphicFill(g);
            }
        }
        if ((length = (list = this.findElements((Element)root, "GraphicStroke")).getLength()) > 0) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("stroke: found a graphic stroke " + list.item(0));
            }
            kids = list.item(0).getChildNodes();
            for (i = 0; i < kids.getLength(); ++i) {
                child = kids.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (!childName.equalsIgnoreCase(graphicSt)) continue;
                g = this.parseGraphic(child);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("setting stroke graphicStroke with " + g);
                }
                stroke.setGraphicStroke(g);
            }
        }
        list = this.findElements((Element)root, "CssParameter");
        length = list.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Node child2 = list.item(i2);
            if (child2 == null || child2.getNodeType() != 1) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("now I am processing " + child2);
            }
            Element param = (Element)child2;
            NamedNodeMap map = param.getAttributes();
            int mapLength = map.getLength();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attributes " + map.toString());
            }
            for (int k = 0; k < mapLength; ++k) {
                String res = map.item(k).getNodeValue();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("processing attribute " + res);
                }
                if (res.equalsIgnoreCase(strokeString)) {
                    Expression color = this.parseParameterValueExpression(child2, false);
                    stroke.setColor(color);
                    continue;
                }
                if (res.equalsIgnoreCase("width") || res.equalsIgnoreCase("stroke-width")) {
                    Expression width = this.parseParameterValueExpression(child2, false);
                    stroke.setWidth(width);
                    continue;
                }
                if (res.equalsIgnoreCase(opacityString) || res.equalsIgnoreCase("stroke-opacity")) {
                    Expression opacity = this.parseParameterValueExpression(child2, false);
                    stroke.setOpacity(opacity);
                    continue;
                }
                if (res.equalsIgnoreCase("linecap") || res.equalsIgnoreCase("stroke-linecap")) {
                    stroke.setLineCap(this.parseCssParameter(child2));
                    continue;
                }
                if (res.equalsIgnoreCase("linejoin") || res.equalsIgnoreCase("stroke-linejoin")) {
                    stroke.setLineJoin(this.parseCssParameter(child2));
                    continue;
                }
                if (res.equalsIgnoreCase("dasharray") || res.equalsIgnoreCase("stroke-dasharray")) {
                    String dashString = null;
                    if (child2.getChildNodes().getLength() == 1 && child2.getFirstChild().getNodeType() == 3) {
                        dashString = this.getFirstChildValue(child2);
                    } else {
                        Expression definition = this.parseCssParameter(child2);
                        if (definition instanceof Literal) {
                            dashString = ((Literal)definition).getValue().toString();
                        } else {
                            LOGGER.warning("Only literal stroke-dasharray supported at this time:" + definition);
                        }
                    }
                    if (dashString != null) {
                        StringTokenizer stok = new StringTokenizer(dashString.trim(), " ");
                        float[] dashes = new float[stok.countTokens()];
                        for (int l = 0; l < dashes.length; ++l) {
                            dashes[l] = Float.parseFloat(stok.nextToken());
                        }
                        stroke.setDashArray(dashes);
                        continue;
                    }
                    LOGGER.fine("Unable to parse stroke-dasharray");
                    continue;
                }
                if (!res.equalsIgnoreCase("dashoffset") && !res.equalsIgnoreCase("stroke-dashoffset")) continue;
                stroke.setDashOffset(this.parseCssParameter(child2));
            }
        }
        return stroke;
    }

    protected Fill parseFill(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing fill ");
        }
        Fill fill = this.factory.getDefaultFill();
        NodeList list = this.findElements((Element)root, "GraphicFill");
        int length = list.getLength();
        if (length > 0) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("fill found a graphic fill " + list.item(0));
            }
            NodeList kids = list.item(0).getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node child = kids.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (!childName.equalsIgnoreCase(graphicSt)) continue;
                Graphic g = this.parseGraphic(child);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("setting fill graphic with " + g);
                }
                fill.setGraphicFill(g);
            }
        }
        list = this.findElements((Element)root, "CssParameter");
        length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = list.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            Element param = (Element)child;
            NamedNodeMap map = param.getAttributes();
            int mapLength = map.getLength();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("now I am processing " + child);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attributes " + map.toString());
            }
            for (int k = 0; k < mapLength; ++k) {
                String res = map.item(k).getNodeValue();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("processing attribute " + res);
                }
                if (res.equalsIgnoreCase(fillSt)) {
                    fill.setColor(this.parseCssParameter(child));
                    continue;
                }
                if (!res.equalsIgnoreCase(opacityString) && !res.equalsIgnoreCase("fill-opacity")) continue;
                fill.setOpacity(this.parseCssParameter(child));
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("fill graphic " + fill.getGraphicFill());
        }
        return fill;
    }

    private Expression manageMixed(Expression left, Expression right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Function mixed = this.ff.function("strConcat", new Expression[]{left, right});
        return mixed;
    }

    private Expression parseCssParameter(Node root) {
        return this.parseCssParameter(root, true);
    }

    /*
     * WARNING - void declaration
     */
    private Expression parseCssParameter(Node root, boolean trimWhiteSpace) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsingCssParam " + root);
        }
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        ArrayList<Object> expressions = new ArrayList<Object>();
        ArrayList<Boolean> cdatas = new ArrayList<Boolean>();
        for (int i = 0; i < length; ++i) {
            String string;
            Literal literal;
            Node child = children.item(i);
            if (child == null) continue;
            if (child.getNodeType() == 3) {
                void var9_15;
                String string2 = child.getNodeValue();
                if (string2 == null) continue;
                if (trimWhiteSpace) {
                    String string3 = string2.trim();
                } else {
                    String string4 = WHITESPACES.matcher(string2).replaceAll(" ");
                }
                if (var9_15 == null || var9_15.length() == 0) continue;
                literal = this.ff.literal((Object)var9_15);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Built new literal " + literal);
                }
                expressions.add(literal);
                cdatas.add(false);
                continue;
            }
            if (child.getNodeType() == 1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("about to parse " + child.getLocalName());
                }
                expressions.add(ExpressionDOMParser.parseExpression(child));
                cdatas.add(false);
                continue;
            }
            if (child.getNodeType() != 4 || (string = child.getNodeValue()) == null || string.length() == 0) continue;
            literal = this.ff.literal((Object)string);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Built new literal " + literal);
            }
            expressions.add(literal);
            cdatas.add(true);
        }
        if (expressions.size() == 0 && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("no children in CssParam");
        }
        if (!trimWhiteSpace) {
            Literal literal;
            int idx;
            Expression ex;
            Literal literal2;
            Expression ex2;
            while (expressions.size() > 0 && (ex2 = (Expression)expressions.get(0)) instanceof Literal && (literal2 = (Literal)ex2).getValue() instanceof String) {
                String string = (String)literal2.getValue();
                if (((Boolean)cdatas.get(0)).booleanValue()) break;
                if ("".equals(string.trim())) {
                    expressions.remove(0);
                    cdatas.remove(0);
                    continue;
                }
                if (!string.startsWith(" ")) break;
                String string5 = LEADING_WHITESPACES.matcher(string).replaceAll("");
                expressions.set(0, this.ff.literal((Object)string5));
                break;
            }
            while (expressions.size() > 0 && (ex = (Expression)expressions.get(idx = expressions.size() - 1)) instanceof Literal && (literal = (Literal)ex).getValue() instanceof String) {
                String s = (String)literal.getValue();
                if (((Boolean)cdatas.get(idx)).booleanValue()) break;
                if ("".equals(s.trim())) {
                    expressions.remove(idx);
                    cdatas.remove(idx);
                    continue;
                }
                if (!s.endsWith(" ")) break;
                s = TRAILING_WHITESPACES.matcher(s).replaceAll("");
                expressions.set(idx, this.ff.literal((Object)s));
                break;
            }
        }
        Expression ret = null;
        for (Expression expression : expressions) {
            ret = this.manageMixed(ret, expression);
        }
        return ret;
    }

    protected Font parseFont(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing font");
        }
        Font font = this.factory.getDefaultFont();
        NodeList list = this.findElements((Element)root, "CssParameter");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = list.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            Element param = (Element)child;
            NamedNodeMap map = param.getAttributes();
            int mapLength = map.getLength();
            for (int k = 0; k < mapLength; ++k) {
                String res = map.item(k).getNodeValue();
                if (res.equalsIgnoreCase("font-family")) {
                    font.setFontFamily(this.parseCssParameter(child));
                    continue;
                }
                if (res.equalsIgnoreCase("font-style")) {
                    font.setFontStyle(this.parseCssParameter(child));
                    continue;
                }
                if (res.equalsIgnoreCase("font-size")) {
                    font.setFontSize(this.parseCssParameter(child));
                    continue;
                }
                if (!res.equalsIgnoreCase("font-weight")) continue;
                font.setFontWeight(this.parseCssParameter(child));
            }
        }
        return font;
    }

    protected LabelPlacement parseLabelPlacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing labelPlacement");
        }
        LabelPlacement ret = null;
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("PointPlacement")) {
                ret = this.parsePointPlacement(child);
                continue;
            }
            if (!childName.equalsIgnoreCase("LinePlacement")) continue;
            ret = this.parseLinePlacement(child);
        }
        return ret;
    }

    protected PointPlacement parsePointPlacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing pointPlacement");
        }
        Literal rotation = this.ff.literal(0.0);
        AnchorPoint ap = null;
        Displacement dp = null;
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("AnchorPoint")) {
                ap = this.parseAnchorPoint(child);
                continue;
            }
            if (childName.equalsIgnoreCase("Displacement")) {
                dp = this.parseDisplacement(child);
                continue;
            }
            if (!childName.equalsIgnoreCase("Rotation")) continue;
            rotation = this.parseCssParameter(child);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting anchorPoint " + ap);
            LOGGER.fine("setting displacement " + dp);
        }
        PointPlacement dpp = this.factory.createPointPlacement(ap, dp, (Expression)rotation);
        return dpp;
    }

    protected LinePlacement parseLinePlacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing linePlacement");
        }
        Literal offset = this.ff.literal(0.0);
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("PerpendicularOffset")) continue;
            offset = this.parseCssParameter(child);
        }
        LinePlacement dlp = this.factory.createLinePlacement((Expression)offset);
        return dlp;
    }

    protected AnchorPoint parseAnchorPoint(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing anchorPoint");
        }
        Expression x = null;
        Expression y = null;
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("AnchorPointX")) {
                x = this.parseCssParameter(child);
                continue;
            }
            if (!childName.equalsIgnoreCase("AnchorPointY")) continue;
            y = this.parseCssParameter(child);
        }
        AnchorPoint dap = this.factory.createAnchorPoint(x, y);
        return dap;
    }

    protected Displacement parseDisplacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing displacment");
        }
        Expression x = null;
        Expression y = null;
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("DisplacementX")) {
                x = this.parseCssParameter(child);
            }
            if (!childName.equalsIgnoreCase("DisplacementY")) continue;
            y = this.parseCssParameter(child);
        }
        Displacement dd = this.factory.createDisplacement(x, y);
        return dd;
    }

    protected Halo parseHalo(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing halo");
        }
        Halo halo = this.factory.createHalo(this.factory.createFill((Expression)this.ff.literal((Object)"#FFFFFF")), (Expression)this.ff.literal(1.0));
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(fillSt)) {
                halo.setFill(this.parseFill(child));
                continue;
            }
            if (!childName.equalsIgnoreCase("Radius")) continue;
            halo.setRadius(this.parseCssParameter(child));
        }
        return halo;
    }
}

