/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigDecimal;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;

public class LiteralExpressionImpl
extends DefaultExpression
implements LiteralExpression {
    private static BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private Object literal = null;
    private Object parsedValue = null;

    protected LiteralExpressionImpl() {
    }

    protected LiteralExpressionImpl(Object literal) throws IllegalFilterException {
        this.setLiteral(literal);
    }

    protected LiteralExpressionImpl(int value) {
        try {
            this.setLiteral(new Integer(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Integers");
        }
    }

    protected LiteralExpressionImpl(long value) {
        try {
            this.setLiteral(new Long(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Longs");
        }
    }

    protected LiteralExpressionImpl(double value) {
        try {
            this.setLiteral(new Double(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Doubles");
        }
    }

    protected LiteralExpressionImpl(String value) {
        try {
            this.setLiteral(value);
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Strings");
        }
    }

    public short getType() {
        return this.expressionType;
    }

    public final void setLiteral(Object literal) throws IllegalFilterException {
        this.setValue(literal);
    }

    public final Object getLiteral() {
        return this.getValue();
    }

    public Object getValue() {
        return this.literal;
    }

    public final void setValue(Object literal) {
        this.expressionType = literal instanceof Double ? (short)101 : (literal instanceof Integer ? (short)102 : (literal instanceof Long ? (short)100 : (literal instanceof String ? (short)103 : (literal instanceof Geometry ? (short)104 : (short)115))));
        this.literal = literal;
    }

    public Object evaluate(SimpleFeature feature) throws IllegalArgumentException {
        return this.evaluate((Object)feature);
    }

    public Object evaluate(Object feature) {
        if (this.parsedValue != null) {
            return this.parsedValue;
        }
        if (this.literal == null || !(this.literal instanceof String)) {
            this.parsedValue = this.literal;
        } else {
            String s = (String)this.literal;
            try {
                long l;
                double d;
                BigDecimal bd = new BigDecimal(s);
                this.parsedValue = bd.scale() > 0 ? (Number)(!Double.isInfinite(d = bd.doubleValue()) ? Double.valueOf(d) : bd) : (Number)(bd.compareTo(MIN_LONG) >= 0 && bd.compareTo(MAX_LONG) <= 0 ? ((long)((int)(l = bd.longValue())) == l ? (Number)new Integer((int)l) : (Number)new Long(l)) : bd.toBigInteger());
            }
            catch (Exception e) {
                this.parsedValue = this.literal;
            }
        }
        return this.parsedValue;
    }

    public Object evaluate(Object feature, Class context) {
        return Converters.convert(this.literal, context);
    }

    public String toString() {
        return this.literal == null ? "NULL" : this.literal.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralExpressionImpl) {
            LiteralExpressionImpl expLit = (LiteralExpressionImpl)obj;
            if (this.literal == null) {
                return expLit.literal == null;
            }
            if (this.expressionType == expLit.expressionType) {
                if (this.literal.equals(expLit.literal)) {
                    return true;
                }
                if (this.expressionType == 104 && this.literal instanceof Geometry && expLit.literal instanceof Geometry && ((Geometry)this.literal).equals((Geometry)expLit.literal)) {
                    return true;
                }
            }
            if (this.expressionType == 104) {
                return ((Geometry)this.literal).equals((Geometry)expLit.evaluate(null, Geometry.class));
            }
            if (this.expressionType == 102) {
                return ((Integer)this.literal).equals((Integer)expLit.evaluate(null, Integer.class));
            }
            if (this.expressionType == 103) {
                return ((String)this.literal).equals((String)expLit.evaluate(null, String.class));
            }
            if (this.expressionType == 101) {
                return ((Double)this.literal).equals((Double)expLit.evaluate(null, Double.class));
            }
            if (this.expressionType == 100) {
                return ((Long)this.literal).equals((Long)expLit.evaluate(null, Long.class));
            }
            return true;
        }
        if (obj instanceof Literal) {
            Literal other = (Literal)obj;
            return this.equals(new LiteralExpressionImpl(other.getValue()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 37 * result + this.expressionType;
        return result;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Literal)this, extraData);
    }
}

