/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Iterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;

public class CollectionUtil {
    static void accept(SimpleFeatureCollection collection, FeatureVisitor visitor) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            visitor.visit((Feature)feature);
        }
        collection.close(iterator);
    }

    static void accept(SimpleFeatureCollection collection, FeatureVisitor[] visitors) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            for (int i = 0; i < visitors.length; ++i) {
                FeatureVisitor visitor = visitors[i];
                visitor.visit((Feature)feature);
            }
        }
        collection.close(iterator);
    }

    public static Object calc(SimpleFeatureCollection collection, FeatureCalc calculator) {
        CollectionUtil.accept(collection, calculator);
        return calculator.getResult();
    }
}

