/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.gwc.CatalogConfiguration;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.storage.BDBQuotaStore;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWC
implements DisposableBean,
ApplicationContextAware {
    public static final String WMS_INTEGRATION_ENABLED_KEY = "GWC_WMS_Integration";
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWC");
    private final CatalogConfiguration config;
    private final TileLayerDispatcher tld;
    private final StorageBroker storageBroker;
    private final TileBreeder tileBreeder;
    private final GeoServer geoserver;
    private ApplicationContext appContext;
    private final BDBQuotaStore quotaStore;

    public GWC(StorageBroker sb, TileLayerDispatcher tld, TileBreeder tileBreeder, CatalogConfiguration config, GeoServer geoserver, BDBQuotaStore quotaStore) {
        this.tld = tld;
        this.storageBroker = sb;
        this.tileBreeder = tileBreeder;
        this.config = config;
        this.geoserver = geoserver;
        this.quotaStore = quotaStore;
    }

    public boolean isWMSIntegrationEnabled() {
        Boolean storedValue;
        boolean enabled = false;
        WMSInfo service = (WMSInfo)this.geoserver.getService(WMSInfo.class);
        if (service != null && service.getMetadata() != null && (storedValue = (Boolean)service.getMetadata().get(WMS_INTEGRATION_ENABLED_KEY, Boolean.class)) != null) {
            enabled = storedValue;
        }
        return enabled;
    }

    public void truncate(String layerName) {
        try {
            this.storageBroker.delete(layerName);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void truncate(String layerName, ReferencedEnvelope bounds) throws GeoWebCacheException {
        TileLayer tileLayer = this.tld.getTileLayer(layerName);
        ArrayList<GWCTask> truncateTasks = new ArrayList<GWCTask>(tileLayer.getGridSubsets().size() * tileLayer.getMimeTypes().size());
        for (GridSubset layerGrid : tileLayer.getGridSubsets().values()) {
            ReferencedEnvelope truncateBoundsInGridsetCrs;
            CoordinateReferenceSystem gridSetCrs;
            GridSet gridSet = layerGrid.getGridSet();
            String gridSetId = gridSet.getName();
            SRS srs = gridSet.getSRS();
            try {
                gridSetCrs = CRS.decode((String)("EPSG:" + srs.getNumber()));
            }
            catch (Exception e) {
                throw new RuntimeException("Can't decode SRS for layer '" + layerName + "': ESPG:" + srs.getNumber());
            }
            try {
                truncateBoundsInGridsetCrs = bounds.transform(gridSetCrs, true);
            }
            catch (Exception e) {
                log.info("Can't truncate layer " + layerName + ": error transforming requested bounds to layer gridset " + gridSetId + ": " + e.getMessage());
                continue;
            }
            double minx = truncateBoundsInGridsetCrs.getMinX();
            double miny = truncateBoundsInGridsetCrs.getMinY();
            double maxx = truncateBoundsInGridsetCrs.getMaxX();
            double maxy = truncateBoundsInGridsetCrs.getMaxY();
            BoundingBox reqBounds = new BoundingBox(minx, miny, maxx, maxy);
            BoundingBox layerBounds = layerGrid.getCoverageBestFitBounds();
            if (!layerBounds.intersects(reqBounds)) {
                log.fine("Requested truncation bounds do not intersect cached layer bounds, ignoring truncate request");
                continue;
            }
            BoundingBox intersection = BoundingBox.intersection((BoundingBox)layerBounds, (BoundingBox)reqBounds);
            long[][] coverageIntersections = layerGrid.getCoverageIntersections(intersection);
            int zoomStart = layerGrid.getZoomStart();
            int zoomStop = layerGrid.getZoomStop();
            String parameters = null;
            for (MimeType mime : tileLayer.getMimeTypes()) {
                TileRange tileRange = new TileRange(layerName, gridSetId, zoomStart, zoomStop, coverageIntersections, mime, parameters);
                GWCTask[] singleTask = this.tileBreeder.createTasks(tileRange, tileLayer, GWCTask.TYPE.TRUNCATE, 1, false);
                truncateTasks.add(singleTask[0]);
            }
        }
        GWCTask[] tasks = truncateTasks.toArray(new GWCTask[truncateTasks.size()]);
        this.tileBreeder.dispatchTasks(tasks);
    }

    public void destroy() throws Exception {
    }

    public void addOrReplaceLayer(TileLayer layer) {
        this.tld.getLayerList();
        this.tld.add(layer);
        log.finer(layer.getName() + " added to TileLayerDispatcher");
    }

    public synchronized void removeLayer(String prefixedName) {
        this.config.removeLayer(prefixedName);
        this.tld.remove(prefixedName);
        try {
            this.storageBroker.delete(prefixedName);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        try {
            this.tld.reInit();
        }
        catch (GeoWebCacheException gwce) {
            log.fine("Unable to reinit TileLayerDispatcher gwce.getMessage()");
        }
    }

    public void createLayer(LayerInfo layerInfo) {
        TileLayer tileLayer = this.config.createLayer(layerInfo);
        if (tileLayer == null) {
            log.warning("TileLayer was not created for " + layerInfo.getName());
            return;
        }
        this.addOrReplaceLayer(tileLayer);
    }

    public void createLayer(LayerGroupInfo lgi) {
        TileLayer tileLayer = this.config.createLayer(lgi);
        if (tileLayer == null) {
            log.warning("TileLayer was not created for " + lgi.getName());
            return;
        }
        this.addOrReplaceLayer(tileLayer);
    }

    public final ConveyorTile dispatch(GetMapRequest request) {
        MimeType mimeType;
        GridSubset gridSubset;
        TileLayer tileLayer;
        if (!this.isCachingPossible(request)) {
            return null;
        }
        String layerName = (String)request.getRawKvp().get("LAYERS");
        if (layerName.indexOf(44) != -1) {
            return null;
        }
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            return null;
        }
        try {
            String srs = request.getSRS();
            int epsgId = Integer.parseInt(srs.substring(srs.indexOf(58) + 1));
            SRS srs2 = SRS.getSRS((int)epsgId);
            gridSubset = tileLayer.getGridSubsetForSRS(srs2);
            if (gridSubset == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (request.getWidth() != gridSubset.getTileWidth() || request.getHeight() != gridSubset.getTileHeight()) {
            return null;
        }
        try {
            mimeType = MimeType.createFromFormat((String)request.getFormat());
            List tileLayerFormats = tileLayer.getMimeTypes();
            if (!tileLayerFormats.contains(mimeType)) {
                return null;
            }
        }
        catch (MimeException me) {
            return null;
        }
        ConveyorTile tileResp = null;
        try {
            long[] tileIndex;
            HttpServletRequest servletReq = null;
            HttpServletResponse servletResp = null;
            String gridSetId = gridSubset.getName();
            Envelope bbox = request.getBbox();
            BoundingBox tileBounds = new BoundingBox(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
            try {
                tileIndex = gridSubset.closestIndex(tileBounds);
            }
            catch (GridMismatchException e) {
                return null;
            }
            Map fullParameters = null;
            Map modifiedParameters = null;
            ConveyorTile tileReq = new ConveyorTile(this.storageBroker, layerName, gridSetId, tileIndex, mimeType, fullParameters, modifiedParameters, servletReq, servletResp);
            tileResp = tileLayer.getTile(tileReq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tileResp;
    }

    private boolean isCachingPossible(GetMapRequest request) {
        if (request.getFormatOptions() != null && !request.getFormatOptions().isEmpty()) {
            return false;
        }
        if (0.0 != request.getAngle()) {
            return false;
        }
        if (0 != request.getBuffer()) {
            return false;
        }
        if (null != request.getCQLFilter() && !request.getCQLFilter().isEmpty()) {
            return false;
        }
        if (!Double.isNaN(request.getElevation())) {
            return false;
        }
        if (null != request.getFeatureId() && !request.getFeatureId().isEmpty()) {
            return false;
        }
        if (null != request.getFilter() && !request.getFilter().isEmpty()) {
            return false;
        }
        if (null != request.getPalette()) {
            return false;
        }
        if (null != request.getRemoteOwsType() || null != request.getRemoteOwsURL()) {
            return false;
        }
        if (null != request.getSld() || null != request.getSldBody()) {
            return false;
        }
        if (null != request.getStartIndex()) {
            return false;
        }
        if (null != request.getTime() && !request.getTime().isEmpty()) {
            return false;
        }
        return null == request.getViewParams() || request.getViewParams().isEmpty();
    }

    public List<TileLayer> getLayers() {
        return new ArrayList<TileLayer>(this.tld.getLayerList());
    }

    public List<TileLayer> getLayers(String namespacePrefixFilter) {
        if (namespacePrefixFilter == null) {
            return this.getLayers();
        }
        Catalog catalog = this.config.getCatalog();
        NamespaceInfo namespaceFilter = catalog.getNamespaceByPrefix(namespacePrefixFilter);
        if (namespaceFilter == null) {
            return this.getLayers();
        }
        ArrayList<TileLayer> filteredLayers = new ArrayList<TileLayer>();
        for (TileLayer tileLayer : this.getLayers()) {
            NamespaceInfo layerNamespace;
            String layerName = tileLayer.getName();
            LayerInfo layerInfo = catalog.getLayerByName(layerName);
            if (layerInfo == null || !namespaceFilter.equals(layerNamespace = layerInfo.getResource().getNamespace())) continue;
            filteredLayers.add(tileLayer);
        }
        return filteredLayers;
    }

    public DiskQuotaConfig getDisQuotaConfig() {
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        if (!monitor.isEnabled()) {
            return null;
        }
        return monitor.getConfig();
    }

    private DiskQuotaMonitor getDiskQuotaMonitor() {
        DiskQuotaMonitor monitor = (DiskQuotaMonitor)this.appContext.getBean("DiskQuotaMonitor");
        Assert.notNull((Object)monitor);
        return monitor;
    }

    public void saveDiskQuotaConfig() {
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        monitor.saveConfig();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public Quota getGlobalQuota() {
        return this.getDisQuotaConfig().getGlobalQuota();
    }

    public Quota getGlobalUsedQuota() {
        try {
            return this.quotaStore.getGloballyUsedQuota();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

