/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.opengis.wfs.BaseRequestType;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.xml.ApplicationSchemaConfiguration2;
import org.geoserver.wfs.xml.ApplicationSchemaXSD2;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GML32OutputFormat
extends GML3OutputFormat {
    GeoServer geoServer;

    public GML32OutputFormat(GeoServer geoServer, WFSConfiguration configuration) {
        super(new HashSet<String>(Arrays.asList("gml32", "text/xml; subtype=gml/3.2")), geoServer, configuration);
        this.geoServer = geoServer;
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/3.2";
    }

    @Override
    protected Encoder createEncoder(Configuration configuration, Map<String, Set<FeatureTypeInfo>> featureTypes, BaseRequestType request) {
        FeatureTypeSchemaBuilder.GML32 schemaBuilder = new FeatureTypeSchemaBuilder.GML32(this.geoServer);
        ApplicationSchemaXSD2 xsd = new ApplicationSchemaXSD2(schemaBuilder, featureTypes);
        xsd.setBaseURL(request.getBaseUrl());
        ApplicationSchemaConfiguration2 config = new ApplicationSchemaConfiguration2(xsd, (Configuration)new org.geotools.wfs.v2_0.WFSConfiguration());
        return new Encoder((Configuration)config);
    }

    @Override
    protected void encode(FeatureCollectionType results, OutputStream output, Encoder encoder) throws IOException {
        encoder.encode((Object)results, WFS.FeatureCollection, output);
    }
}

