/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.DefaultServiceExceptionHandler;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;

public class WfsExceptionHandler
extends DefaultServiceExceptionHandler {
    GeoServer gs;

    public WfsExceptionHandler(List services, GeoServer gs) {
        super(services);
        this.gs = gs;
    }

    public WFSInfo getInfo() {
        return (WFSInfo)this.gs.getService(WFSInfo.class);
    }

    public void handleServiceException(ServiceException e, Request request) {
        this.verboseExceptions = this.getInfo().getGeoServer().getGlobal().isVerboseExceptions();
        if ("1.0.0".equals(request.getVersion())) {
            this.handle1_0(e, request.getHttpResponse());
        } else {
            super.handleServiceException(e, request);
        }
    }

    public void handle1_0(ServiceException e, HttpServletResponse response) {
        try {
            String tab = "   ";
            StringBuffer s = new StringBuffer();
            s.append("<?xml version=\"1.0\" ?>\n");
            s.append("<ServiceExceptionReport\n");
            s.append(tab + "version=\"1.2.0\"\n");
            s.append(tab + "xmlns=\"http://www.opengis.net/ogc\"\n");
            s.append(tab + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            s.append(tab);
            s.append("xsi:schemaLocation=\"http://www.opengis.net/ogc ");
            s.append(ResponseUtils.appendPath((String[])new String[]{this.getInfo().getSchemaBaseURL(), "wfs/1.0.0/OGC-exception.xsd"}) + "\">\n");
            s.append(tab + "<ServiceException");
            if (e.getCode() != null && !e.getCode().equals("")) {
                s.append(" code=\"" + e.getCode() + "\"");
            }
            if (e.getLocator() != null && !e.getLocator().equals("")) {
                s.append(" locator=\"" + e.getLocator() + "\"");
            }
            s.append(">");
            if (e.getMessage() != null) {
                s.append("\n" + tab + tab);
                OwsUtils.dumpExceptionMessages((ServiceException)e, (StringBuffer)s, (boolean)true);
                if (this.verboseExceptions) {
                    ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                    s.append("\nDetails:\n");
                    s.append(ResponseUtils.encodeXML((String)new String(stackTrace.toByteArray())));
                }
            }
            s.append("\n</ServiceException>");
            s.append("</ServiceExceptionReport>");
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            response.getOutputStream().write(s.toString().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

