/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.ResultTypeType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.response.WFSResponse;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class HitsOutputFormat
extends WFSResponse {
    WFSConfiguration configuration;

    public HitsOutputFormat(GeoServer gs, WFSConfiguration configuration) {
        super(gs, FeatureCollectionType.class);
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        return request != null && request.getResultType() == ResultTypeType.HITS_LITERAL;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        WFSInfo wfs = this.getInfo();
        FeatureCollectionType featureCollection = (FeatureCollectionType)value;
        FeatureCollectionType hits = WfsFactory.eINSTANCE.createFeatureCollectionType();
        if (GML3OutputFormat.isComplexFeature(featureCollection)) {
            hits.setNumberOfFeatures(this.countFeature(featureCollection));
        } else {
            hits.setNumberOfFeatures(featureCollection.getNumberOfFeatures());
        }
        hits.setTimeStamp(featureCollection.getTimeStamp());
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        encoder.setEncoding(Charset.forName(wfs.getGeoServer().getGlobal().getCharset()));
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String[])new String[]{wfs.getSchemaBaseURL(), "wfs/1.1.0/wfs.xsd"}));
        encoder.encode((Object)hits, WFS.FEATURECOLLECTION, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger countFeature(FeatureCollectionType fct) {
        BigInteger count = BigInteger.valueOf(0L);
        for (int fcIndex = 0; fcIndex < fct.getFeature().size(); ++fcIndex) {
            Object var6_5;
            FeatureIterator i = null;
            try {
                i = ((FeatureCollection)fct.getFeature().get(fcIndex)).features();
                while (i.hasNext()) {
                    count = count.add(BigInteger.ONE);
                    i.next();
                }
                var6_5 = null;
                if (i == null) continue;
            }
            catch (Throwable throwable) {
                var6_5 = null;
                if (i != null) {
                    i.close();
                }
                throw throwable;
            }
            i.close();
            {
                continue;
            }
        }
        return count;
    }
}

