/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BBoxKvpParser
extends KvpParser {
    public BBoxKvpParser() {
        super("bbox", Envelope.class);
    }

    public Object parse(String value) throws Exception {
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        if (unparsed.size() < 4) {
            throw new IllegalArgumentException("Requested bounding box contains wrongnumber of coordinates (should have 4): " + unparsed.size());
        }
        double[] bbox = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                bbox[i] = Double.parseDouble((String)unparsed.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bounding box coordinate " + i + " is not parsable:" + unparsed.get(i));
            }
        }
        double minx = bbox[0];
        double miny = bbox[1];
        double maxx = bbox[2];
        double maxy = bbox[3];
        if (minx > maxx) {
            throw new ServiceException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
        }
        if (miny > maxy) {
            throw new ServiceException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
        }
        CoordinateReferenceSystem crs = null;
        if (unparsed.size() > 4) {
            StringBuilder sb = new StringBuilder();
            for (int i = 4; i < unparsed.size(); ++i) {
                sb.append(unparsed.get(i));
                if (i >= unparsed.size() - 1) continue;
                sb.append(",");
            }
            crs = CRS.decode((String)sb.toString());
        }
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }
}

