/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import org.gdal.ogr.ogrJNI;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;

public class Geometry {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Geometry(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Geometry obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            ogrJNI.delete_Geometry(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtrAndDisown(Geometry obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
        }
        return Geometry.getCPtr(obj);
    }

    public Geometry(int type, String wkt, int wkb, String wkb_buf, String gml) {
        this(ogrJNI.new_Geometry(type, wkt, wkb, wkb_buf, gml), true);
    }

    public int ExportToWkt(String[] argout) {
        return ogrJNI.Geometry_ExportToWkt(this.swigCPtr, this, argout);
    }

    public int ExportToWkb(char[][] nLen, int byte_order) {
        return ogrJNI.Geometry_ExportToWkb(this.swigCPtr, this, nLen, byte_order);
    }

    public String ExportToGML() {
        return ogrJNI.Geometry_ExportToGML(this.swigCPtr, this);
    }

    public void AddPoint(double x, double y, double z) {
        ogrJNI.Geometry_AddPoint(this.swigCPtr, this, x, y, z);
    }

    public int AddGeometryDirectly(Geometry other) {
        return ogrJNI.Geometry_AddGeometryDirectly(this.swigCPtr, this, Geometry.getCPtrAndDisown(other), other);
    }

    public int AddGeometry(Geometry other) {
        return ogrJNI.Geometry_AddGeometry(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public Geometry Clone() {
        long cPtr = ogrJNI.Geometry_Clone(this.swigCPtr, this);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public int GetGeometryType() {
        return ogrJNI.Geometry_GetGeometryType(this.swigCPtr, this);
    }

    public String GetGeometryName() {
        return ogrJNI.Geometry_GetGeometryName(this.swigCPtr, this);
    }

    public double GetArea() {
        return ogrJNI.Geometry_GetArea(this.swigCPtr, this);
    }

    public int GetPointCount() {
        return ogrJNI.Geometry_GetPointCount(this.swigCPtr, this);
    }

    public double GetX(int point) {
        return ogrJNI.Geometry_GetX(this.swigCPtr, this, point);
    }

    public double GetY(int point) {
        return ogrJNI.Geometry_GetY(this.swigCPtr, this, point);
    }

    public double GetZ(int point) {
        return ogrJNI.Geometry_GetZ(this.swigCPtr, this, point);
    }

    public int GetGeometryCount() {
        return ogrJNI.Geometry_GetGeometryCount(this.swigCPtr, this);
    }

    public void SetPoint(int point, double x, double y, double z) {
        ogrJNI.Geometry_SetPoint(this.swigCPtr, this, point, x, y, z);
    }

    public Geometry GetGeometryRef(int geom) {
        long cPtr = ogrJNI.Geometry_GetGeometryRef(this.swigCPtr, this, geom);
        return cPtr == 0L ? null : new Geometry(cPtr, false);
    }

    public Geometry GetBoundary() {
        long cPtr = ogrJNI.Geometry_GetBoundary(this.swigCPtr, this);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry ConvexHull() {
        long cPtr = ogrJNI.Geometry_ConvexHull(this.swigCPtr, this);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Buffer(double distance, int quadsecs) {
        long cPtr = ogrJNI.Geometry_Buffer(this.swigCPtr, this, distance, quadsecs);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Intersection(Geometry other) {
        long cPtr = ogrJNI.Geometry_Intersection(this.swigCPtr, this, Geometry.getCPtr(other), other);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Union(Geometry other) {
        long cPtr = ogrJNI.Geometry_Union(this.swigCPtr, this, Geometry.getCPtr(other), other);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry Difference(Geometry other) {
        long cPtr = ogrJNI.Geometry_Difference(this.swigCPtr, this, Geometry.getCPtr(other), other);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public Geometry SymmetricDifference(Geometry other) {
        long cPtr = ogrJNI.Geometry_SymmetricDifference(this.swigCPtr, this, Geometry.getCPtr(other), other);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public double Distance(Geometry other) {
        return ogrJNI.Geometry_Distance(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public void Empty() {
        ogrJNI.Geometry_Empty(this.swigCPtr, this);
    }

    public boolean Intersect(Geometry other) {
        return ogrJNI.Geometry_Intersect(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Equal(Geometry other) {
        return ogrJNI.Geometry_Equal(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Disjoint(Geometry other) {
        return ogrJNI.Geometry_Disjoint(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Touches(Geometry other) {
        return ogrJNI.Geometry_Touches(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Crosses(Geometry other) {
        return ogrJNI.Geometry_Crosses(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Within(Geometry other) {
        return ogrJNI.Geometry_Within(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Contains(Geometry other) {
        return ogrJNI.Geometry_Contains(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public boolean Overlaps(Geometry other) {
        return ogrJNI.Geometry_Overlaps(this.swigCPtr, this, Geometry.getCPtr(other), other);
    }

    public int TransformTo(SpatialReference reference) {
        return ogrJNI.Geometry_TransformTo(this.swigCPtr, this, SpatialReference.getCPtr(reference), reference);
    }

    public int Transform(CoordinateTransformation trans) {
        return ogrJNI.Geometry_Transform(this.swigCPtr, this, CoordinateTransformation.getCPtr(trans), trans);
    }

    public SpatialReference GetSpatialReference() {
        long cPtr = ogrJNI.Geometry_GetSpatialReference(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public void AssignSpatialReference(SpatialReference reference) {
        ogrJNI.Geometry_AssignSpatialReference(this.swigCPtr, this, SpatialReference.getCPtr(reference), reference);
    }

    public void CloseRings() {
        ogrJNI.Geometry_CloseRings(this.swigCPtr, this);
    }

    public void FlattenTo2D() {
        ogrJNI.Geometry_FlattenTo2D(this.swigCPtr, this);
    }

    public void GetEnvelope(double[] argout) {
        ogrJNI.Geometry_GetEnvelope(this.swigCPtr, this, argout);
    }

    public Geometry Centroid() {
        long cPtr = ogrJNI.Geometry_Centroid(this.swigCPtr, this);
        return cPtr == 0L ? null : new Geometry(cPtr, true);
    }

    public int WkbSize() {
        return ogrJNI.Geometry_WkbSize(this.swigCPtr, this);
    }

    public int GetCoordinateDimension() {
        return ogrJNI.Geometry_GetCoordinateDimension(this.swigCPtr, this);
    }

    public void SetCoordinateDimension(int dimension) {
        ogrJNI.Geometry_SetCoordinateDimension(this.swigCPtr, this, dimension);
    }

    public int GetDimension() {
        return ogrJNI.Geometry_GetDimension(this.swigCPtr, this);
    }
}

