/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.IOException;
import java.io.StringReader;
import org.geowebcache.diskquota.ConfigLoader;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.StringRepresentation;

public class DiskQuotaConfigurationResource
extends Resource {
    private DiskQuotaMonitor monitor;

    public void setMonitor(DiskQuotaMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean allowGet() {
        return true;
    }

    public boolean allowPut() {
        return true;
    }

    public void handleGet() {
        JsonRepresentation representation;
        Request request = this.getRequest();
        Response response = this.getResponse();
        String formatExtension = (String)request.getAttributes().get("extension");
        DiskQuotaConfig config = this.monitor.getConfig();
        if ("json".equals(formatExtension)) {
            try {
                representation = this.getJsonRepresentation(config);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        } else if ("xml".equals(formatExtension)) {
            representation = this.getXmlRepresentation(config);
        } else {
            response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unknown or missing format extension : " + formatExtension);
            return;
        }
        response.setEntity((Representation)representation);
        response.setStatus(Status.SUCCESS_OK);
    }

    public void put(Representation entity) {
        Response response;
        block4: {
            Request request = this.getRequest();
            response = this.getResponse();
            String formatExtension = (String)request.getAttributes().get("extension");
            DiskQuotaConfig config = this.monitor.getConfig();
            DiskQuotaConfig newConfig = null;
            try {
                if ("json".equals(formatExtension)) {
                    newConfig = this.fromJSON(entity);
                    this.applyDiff(config, newConfig);
                    response.setEntity((Representation)this.getJsonRepresentation(config));
                    break block4;
                }
                if ("xml".equals(formatExtension)) {
                    newConfig = this.fromXML(entity);
                    this.applyDiff(config, newConfig);
                    response.setEntity(this.getXmlRepresentation(config));
                    break block4;
                }
                response.setStatus(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
                return;
            }
            catch (Exception e) {
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
                response.setEntity(e.getMessage(), MediaType.TEXT_PLAIN);
                return;
            }
        }
        this.monitor.saveConfig();
        response.setStatus(Status.SUCCESS_OK);
    }

    private void applyDiff(DiskQuotaConfig config, DiskQuotaConfig newConfig) throws IllegalArgumentException {
        if (newConfig != null) {
            if (null != newConfig.isEnabled()) {
                config.setEnabled(newConfig.isEnabled());
            }
            if (null != newConfig.getCacheCleanUpFrequency()) {
                config.setCacheCleanUpFrequency(newConfig.getCacheCleanUpFrequency());
            }
            if (null != newConfig.getDiskBlockSize()) {
                config.setDiskBlockSize(newConfig.getDiskBlockSize());
            }
            if (null != newConfig.getMaxConcurrentCleanUps()) {
                config.setMaxConcurrentCleanUps(newConfig.getMaxConcurrentCleanUps());
            }
            if (null != newConfig.getCacheCleanUpUnits()) {
                config.setCacheCleanUpUnits(newConfig.getCacheCleanUpUnits());
            }
            if (null != newConfig.getGlobalExpirationPolicyName()) {
                config.setGlobalExpirationPolicyName(newConfig.getGlobalExpirationPolicyName());
            }
            if (null != newConfig.getGlobalQuota()) {
                config.setGlobalQuota(newConfig.getGlobalQuota());
            }
            if (null != newConfig.getLayerQuotas()) {
                config.setLayerQuotas(newConfig.getLayerQuotas());
            }
        }
    }

    public Representation getPreferredRepresentation() {
        JsonRepresentation jsonRepresentation;
        DiskQuotaConfig config = this.monitor.getConfig();
        try {
            jsonRepresentation = this.getJsonRepresentation(config);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonRepresentation;
    }

    private JsonRepresentation getJsonRepresentation(DiskQuotaConfig config) throws JSONException {
        JsonRepresentation rep = null;
        XStream xs = ConfigLoader.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()));
        JSONObject obj = new JSONObject(xs.toXML((Object)config));
        rep = new JsonRepresentation(obj);
        return rep;
    }

    private Representation getXmlRepresentation(DiskQuotaConfig config) {
        XStream xStream = ConfigLoader.getConfiguredXStream(new XStream());
        String xml = xStream.toXML((Object)config);
        return new StringRepresentation((CharSequence)xml, MediaType.TEXT_XML);
    }

    private DiskQuotaConfig fromXML(Representation entity) throws IOException {
        String text = entity.getText();
        StringReader reader = new StringReader(text);
        XStream xstream = ConfigLoader.getConfiguredXStream(new XStream());
        DiskQuotaConfig diskQuotaConfig = ConfigLoader.loadConfiguration(reader, xstream);
        return diskQuotaConfig;
    }

    private DiskQuotaConfig fromJSON(Representation entity) throws IOException {
        String text = entity.getText();
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        XStream xStream = new XStream((HierarchicalStreamDriver)driver);
        xStream = ConfigLoader.getConfiguredXStream(xStream);
        StringReader reader = new StringReader(text);
        DiskQuotaConfig configuration = ConfigLoader.loadConfiguration(reader, xStream);
        return configuration;
    }
}

