/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.QueuedUsageStatsConsumer;
import org.geowebcache.diskquota.QueuedUsageStatsProducer;
import org.geowebcache.diskquota.UsageStats;
import org.geowebcache.diskquota.storage.BDBQuotaStore;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.TileLayerListener;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class UsageStatsMonitor {
    private static final Log log = LogFactory.getLog(UsageStatsMonitor.class);
    private static final CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC DiskQuota Usage Stats Gathering Thread-");
    private final BDBQuotaStore quotaStore;
    private final TileLayerDispatcher tileLayerDispatcher;
    private final TilePageCalculator tilePageCalculator;
    private ExecutorService executorService;
    private BlockingQueue<UsageStats> sharedQueue;
    private QueuedUsageStatsProducer usageStatsProducer;
    private QueuedUsageStatsConsumer usageStatsConsumer;

    public UsageStatsMonitor(BDBQuotaStore quotaStore, TileLayerDispatcher tileLayerDispatcher) {
        Assert.notNull((Object)quotaStore, (String)"quotaStore is null");
        Assert.notNull((Object)tileLayerDispatcher, (String)"tileLayerDispatcher is null");
        this.quotaStore = quotaStore;
        this.tileLayerDispatcher = tileLayerDispatcher;
        this.tilePageCalculator = quotaStore.getTilePageCalculator();
    }

    public void startUp() {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)tf);
        this.sharedQueue = new LinkedBlockingQueue<UsageStats>(1000);
        this.usageStatsConsumer = new QueuedUsageStatsConsumer(this.quotaStore, this.sharedQueue, this.tilePageCalculator);
        this.executorService.submit(this.usageStatsConsumer);
        this.usageStatsProducer = new QueuedUsageStatsProducer(this.sharedQueue);
        List allLayers = this.tileLayerDispatcher.getLayerList();
        for (TileLayer layer : allLayers) {
            layer.addLayerListener((TileLayerListener)this.usageStatsProducer);
        }
    }

    public void shutDown() {
        boolean cancel = false;
        this.shutDown(false);
        int maxAttempts = 6;
        int seconds = 5;
        int attempts = 1;
        while (!this.executorService.isTerminated()) {
            ++attempts;
            try {
                this.awaitTermination(5, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                String message = "Usage statistics thread helper for DiskQuota failed to shutdown within " + attempts * 5 + " seconds. Attempt " + attempts + " of " + 6 + "...";
                log.warn((Object)message);
                if (attempts != 6) continue;
                throw new RuntimeException(message, e);
            }
        }
    }

    public void awaitTermination(int timeout, TimeUnit units) throws InterruptedException {
        if (!this.executorService.isShutdown()) {
            throw new IllegalStateException("Called awaitTermination but the UsageStatsMonitor is not shutting down");
        }
        this.executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS);
    }

    public void shutDownNow() {
        this.shutDown(true);
    }

    private void shutDown(boolean cancel) {
        List allLayers = this.tileLayerDispatcher.getLayerList();
        for (TileLayer layer : allLayers) {
            try {
                layer.removeLayerListener((TileLayerListener)this.usageStatsProducer);
            }
            catch (RuntimeException e) {
                log.error((Object)("Unexpected exception while removing the usage stats listener from layer '" + layer + "'. Ignoring in order to continue with the monitor's shutdown " + "process"), (Throwable)e);
            }
        }
        if (cancel) {
            this.usageStatsProducer.setCancelled(true);
            this.executorService.shutdownNow();
        } else {
            this.executorService.shutdown();
        }
        this.sharedQueue = null;
    }
}

