/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.QuotaUpdatesMonitor;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.util.FileUtils;

final class LayerCacheInfoBuilder {
    private static final Log log = LogFactory.getLog(LayerCacheInfoBuilder.class);
    private final File rootCacheDir;
    private final ExecutorService threadPool;
    private final Map<String, List<Future<ZoomLevelVisitor.Stats>>> perLayerRunningTasks;
    private final QuotaUpdatesMonitor quotaUsageMonitor;

    public LayerCacheInfoBuilder(File rootCacheDir, ExecutorService threadPool, QuotaUpdatesMonitor quotaUsageMonitor) {
        this.rootCacheDir = rootCacheDir;
        this.threadPool = threadPool;
        this.quotaUsageMonitor = quotaUsageMonitor;
        this.perLayerRunningTasks = new HashMap<String, List<Future<ZoomLevelVisitor.Stats>>>();
    }

    public void buildCacheInfo(TileLayer tileLayer) {
        String layerName = tileLayer.getName();
        String layerDirName = FilePathGenerator.filteredLayerName((String)layerName);
        File layerDir = new File(this.rootCacheDir, layerDirName);
        this.perLayerRunningTasks.put(layerName, new ArrayList());
        if (layerDir.exists()) {
            Hashtable gridSubsets = tileLayer.getGridSubsets();
            for (GridSubset gs : gridSubsets.values()) {
                String gridSetId = gs.getName();
                int zoomStart = gs.getZoomStart();
                int zoomStop = gs.getZoomStop();
                for (int zoomLevel = zoomStart; zoomLevel <= zoomStop; ++zoomLevel) {
                    String gridsetZLevelDirName = FilePathGenerator.gridsetZoomLevelDir((String)gridSetId, (long)zoomLevel);
                    File gridsetZLevelDir = new File(layerDir, gridsetZLevelDirName);
                    if (!gridsetZLevelDir.exists()) continue;
                    ZoomLevelVisitor cacheInfoBuilder = new ZoomLevelVisitor(layerName, gridsetZLevelDir, gridSetId, zoomLevel, this.quotaUsageMonitor);
                    Future<ZoomLevelVisitor.Stats> cacheTask = this.threadPool.submit(cacheInfoBuilder);
                    this.perLayerRunningTasks.get(layerName).add(cacheTask);
                    log.debug((Object)("Submitted background task to gather cache info for '" + layerName + "'/" + gridSetId + "/" + zoomLevel));
                }
            }
        }
    }

    public boolean isRunning(String layerName) {
        try {
            List<Future<ZoomLevelVisitor.Stats>> layerTasks = this.perLayerRunningTasks.get(layerName);
            if (layerTasks == null) {
                return false;
            }
            int numRunning = 0;
            Iterator<Future<ZoomLevelVisitor.Stats>> it = layerTasks.iterator();
            while (it.hasNext()) {
                Future<ZoomLevelVisitor.Stats> future = it.next();
                if (future.isDone()) {
                    it.remove();
                    continue;
                }
                ++numRunning;
            }
            return numRunning > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void shutDown() {
        this.threadPool.shutdownNow();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ZoomLevelVisitor
    implements FileFilter,
    Callable<Stats> {
        private final String gridSetId;
        private int tileZ;
        private final File zoomLevelPath;
        private Stats stats;
        private final QuotaUpdatesMonitor quotaUsageMonitor;
        private final String layerName;

        public ZoomLevelVisitor(String layerName, File zoomLevelPath, String gridsetId, int zoomLevel, QuotaUpdatesMonitor quotaUsageMonitor) {
            this.layerName = layerName;
            this.zoomLevelPath = zoomLevelPath;
            this.gridSetId = gridsetId;
            this.quotaUsageMonitor = quotaUsageMonitor;
            this.tileZ = zoomLevel;
            this.stats = new Stats();
        }

        @Override
        public Stats call() throws Exception {
            String zLevelKey = this.layerName + "'/" + this.gridSetId + "/" + this.tileZ;
            try {
                log.debug((Object)("Gathering cache information for '" + zLevelKey));
                this.stats.numTiles = 0L;
                this.stats.runTimeMillis = 0L;
                long runTime = System.currentTimeMillis();
                FileUtils.traverseDepth((File)this.zoomLevelPath, (FileFilter)this);
                this.stats.runTimeMillis = runTime = System.currentTimeMillis() - runTime;
            }
            catch (TraversalCanceledException cancel) {
                log.debug((Object)("Gathering cache information for " + zLevelKey + " was canceled."));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            log.debug((Object)("Cache information for " + zLevelKey + " collected in " + (double)this.stats.runTimeMillis / 1000.0 + "s. Counted " + this.stats.numTiles + " tiles for a storage space of " + this.stats.collectedQuota.toNiceString()));
            return this.stats;
        }

        @Override
        public boolean accept(File file) {
            String blobFormat;
            if (file.isDirectory()) {
                log.trace((Object)("Processing files in " + file.getAbsolutePath()));
                return true;
            }
            long length = file.length();
            String path = file.getPath();
            int fileNameIdx = 1 + path.lastIndexOf(File.separatorChar);
            int coordSepIdx = path.lastIndexOf(95);
            int dotIdx = path.lastIndexOf(46);
            String extension = FilenameUtils.getExtension((String)file.getName());
            try {
                blobFormat = MimeType.createFromExtension((String)extension).getFormat();
            }
            catch (MimeException e) {
                throw new RuntimeException(e);
            }
            long x = Long.valueOf(path.substring(fileNameIdx, coordSepIdx));
            long y = Long.valueOf(path.substring(1 + coordSepIdx, dotIdx));
            Long parametersId = null;
            this.quotaUsageMonitor.tileStored(this.layerName, this.gridSetId, blobFormat, parametersId, x, y, this.tileZ, length);
            ++this.stats.numTiles;
            this.stats.collectedQuota.addBytes(length);
            return true;
        }

        private static class TraversalCanceledException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private TraversalCanceledException() {
            }
        }

        private static class Stats {
            long runTimeMillis;
            long numTiles;
            Quota collectedQuota = new Quota();

            private Stats() {
            }
        }
    }
}

