/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.ApplicationContextProvider;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class ConfigLoader {
    private static final Log log = LogFactory.getLog(ConfigLoader.class);
    private static final String CONFIGURATION_FILE_NAME = "geowebcache-diskquota.xml";
    private final WebApplicationContext context;
    private final TileLayerDispatcher tileLayerDispatcher;
    private final DefaultStorageFinder storageFinder;

    public ConfigLoader(DefaultStorageFinder storageFinder, ApplicationContextProvider contextProvider, TileLayerDispatcher tld) throws IOException {
        this.storageFinder = storageFinder;
        this.context = contextProvider.getApplicationContext();
        this.tileLayerDispatcher = tld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(DiskQuotaConfig config) throws IOException, ConfigurationException {
        File rootCacheDir = this.getRootCacheDir();
        XStream xStream = ConfigLoader.getConfiguredXStream(new XStream());
        File configFile = new File(rootCacheDir, CONFIGURATION_FILE_NAME);
        File tmpConfigFile = new File(rootCacheDir, "geowebcache-diskquota.xml.tmp");
        log.debug((Object)("Saving disk quota config to " + configFile.getAbsolutePath()));
        FileOutputStream configOut = new FileOutputStream(tmpConfigFile);
        try {
            xStream.toXML((Object)config, (Writer)new OutputStreamWriter((OutputStream)configOut, "UTF-8"));
        }
        catch (RuntimeException e) {
            log.error((Object)("Error saving DiskQuota config to temp file :" + tmpConfigFile.getAbsolutePath()));
        }
        finally {
            ((OutputStream)configOut).close();
        }
        configFile.delete();
        if (!tmpConfigFile.renameTo(configFile)) {
            throw new ConfigurationException("Couldn't save disk quota config file " + configFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskQuotaConfig loadConfig() throws IOException, ConfigurationException {
        DiskQuotaConfig quotaConfig;
        File configFile = this.getConfigResource();
        if (!configFile.exists()) {
            log.info((Object)("DiskQuota configuration not found: " + configFile.getAbsolutePath()));
            quotaConfig = new DiskQuotaConfig();
        } else {
            log.info((Object)("Quota config is: " + configFile.getAbsolutePath()));
            FileInputStream configIn = new FileInputStream(configFile);
            try {
                quotaConfig = this.loadConfiguration(configIn);
                if (null == quotaConfig) {
                    throw new ConfigurationException("Couldn't parse configuration file " + configFile.getAbsolutePath());
                }
            }
            catch (RuntimeException e) {
                log.error((Object)("Error loading DiskQuota configuration from " + configFile.getAbsolutePath() + ": " + e.getMessage() + ". Deferring to a default (disabled) configuration"), (Throwable)e);
                quotaConfig = new DiskQuotaConfig();
            }
            finally {
                ((InputStream)configIn).close();
            }
        }
        quotaConfig.setDefaults();
        this.validateConfig(quotaConfig);
        return quotaConfig;
    }

    private File getConfigResource() throws ConfigurationException, FileNotFoundException {
        String cachePath;
        try {
            cachePath = this.storageFinder.getDefaultPath();
        }
        catch (StorageException e) {
            throw new ConfigurationException(e.getMessage());
        }
        File file = new File(cachePath, CONFIGURATION_FILE_NAME);
        return file;
    }

    private void validateConfig(DiskQuotaConfig quotaConfig) throws ConfigurationException {
        int cacheCleanUpFrequency = quotaConfig.getCacheCleanUpFrequency();
        if (cacheCleanUpFrequency <= 0) {
            throw new ConfigurationException("cacheCleanUpFrequency shall be a positive integer");
        }
        TimeUnit cacheCleanUpUnits = quotaConfig.getCacheCleanUpUnits();
        if (cacheCleanUpUnits == null) {
            throw new ConfigurationException("cacheCleanUpUnits shall be specified. Expected one of SECONDS, MINUTES, HOURS, DAYS. Got null");
        }
        int diskBlockSize = quotaConfig.getDiskBlockSize();
        if (diskBlockSize <= 0) {
            throw new ConfigurationException("Disk block size shall be specified and be a positive integer");
        }
        int maxConcurrentCleanUps = quotaConfig.getMaxConcurrentCleanUps();
        if (maxConcurrentCleanUps <= 0) {
            throw new ConfigurationException("maxConcurrentCleanUps shall be specified as a positive integer");
        }
        if (null != quotaConfig.getLayerQuotas()) {
            for (LayerQuota lq : new ArrayList<LayerQuota>(quotaConfig.getLayerQuotas())) {
                if (null == lq.getQuota()) {
                    log.info((Object)("Configured quota for layer " + lq.getLayer() + " is null. Discarding it to be attached to the global quota"));
                    quotaConfig.remove(lq);
                    continue;
                }
                this.validateLayerQuota(quotaConfig, lq);
            }
        }
    }

    private void validateLayerQuota(DiskQuotaConfig quotaConfig, LayerQuota lq) throws ConfigurationException {
        String layer = lq.getLayer();
        try {
            this.tileLayerDispatcher.getTileLayer(layer);
        }
        catch (GeoWebCacheException e) {
            log.error((Object)("LayerQuota configuration error: layer " + layer + " does not exist. Removing quota from runtime configuration."), (Throwable)e);
            quotaConfig.remove(lq);
        }
        ExpirationPolicy expirationPolicyName = lq.getExpirationPolicyName();
        if (expirationPolicyName == null) {
            if (lq.getQuota() != null) {
                throw new ConfigurationException("Layer " + lq.getLayer() + " has no expiration policy, but does have a quota defined. " + "Either both or neither should be present");
            }
            return;
        }
        Quota quota = lq.getQuota();
        try {
            this.validateQuota(quota);
        }
        catch (ConfigurationException e) {
            log.error((Object)("LayerQuota configuration error for layer " + layer + ". Error message is: " + e.getMessage() + ". Quota removed from runtime configuration."));
            quotaConfig.remove(lq);
        }
    }

    private void validateQuota(Quota quota) throws ConfigurationException {
        if (quota == null) {
            throw new IllegalArgumentException("No quota defined");
        }
        BigInteger limit = quota.getBytes();
        if (limit.compareTo(BigInteger.ZERO) < 0) {
            throw new ConfigurationException("Limit shall be >= 0: " + limit + ". " + quota);
        }
        log.debug((Object)("Quota validated: " + quota));
    }

    private DiskQuotaConfig loadConfiguration(InputStream configStream) throws XStreamException {
        InputStreamReader reader;
        XStream xstream = ConfigLoader.getConfiguredXStream(new XStream());
        try {
            reader = new InputStreamReader(configStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        DiskQuotaConfig fromXML = ConfigLoader.loadConfiguration(reader, xstream);
        return fromXML;
    }

    public static DiskQuotaConfig loadConfiguration(Reader reader, XStream xstream) {
        DiskQuotaConfig fromXML = (DiskQuotaConfig)xstream.fromXML(reader);
        return fromXML;
    }

    public static XStream getConfiguredXStream(XStream xs) {
        xs.setMode(1001);
        xs.alias("gwcQuotaConfiguration", DiskQuotaConfig.class);
        xs.alias("layerQuotas", List.class);
        xs.alias("LayerQuota", LayerQuota.class);
        xs.alias("Quota", Quota.class);
        xs.registerConverter((Converter)new QuotaXSTreamConverter());
        return xs;
    }

    public OutputStream getStorageOutputStream(String ... fileNameRelPath) throws IOException {
        File rootCacheDir = this.getFileStorageDir(fileNameRelPath);
        String fileName = fileNameRelPath[fileNameRelPath.length - 1];
        File configFile = new File(rootCacheDir, fileName);
        return new FileOutputStream(configFile);
    }

    public InputStream getStorageInputStream(String ... fileNameRelPath) throws IOException {
        File rootCacheDir = this.getFileStorageDir(fileNameRelPath);
        String fileName = fileNameRelPath[fileNameRelPath.length - 1];
        File configFile = new File(rootCacheDir, fileName);
        return new FileInputStream(configFile);
    }

    private File getFileStorageDir(String[] fileNameRelPath) throws StorageException {
        File parentDir = this.getRootCacheDir();
        for (int i = 0; i < fileNameRelPath.length - 1; ++i) {
            parentDir = new File(parentDir, fileNameRelPath[i]);
        }
        parentDir.mkdirs();
        return parentDir;
    }

    public File getRootCacheDir() throws StorageException {
        return new File(this.storageFinder.getDefaultPath());
    }

    private static final class QuotaXSTreamConverter
    implements Converter {
        private QuotaXSTreamConverter() {
        }

        public boolean canConvert(Class type) {
            return Quota.class.equals((Object)type);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Quota quota = new Quota();
            reader.moveDown();
            String nodeName = reader.getNodeName();
            Assert.isTrue((boolean)"value".equals(nodeName));
            String nodevalue = reader.getValue();
            double value = Double.parseDouble(nodevalue);
            reader.moveUp();
            reader.moveDown();
            nodeName = reader.getNodeName();
            Assert.isTrue((boolean)"units".equals(nodeName));
            nodevalue = reader.getValue();
            StorageUnit unit = StorageUnit.valueOf(nodevalue);
            reader.moveUp();
            quota.setValue(value, unit);
            return quota;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Quota quota = (Quota)source;
            BigInteger bytes = quota.getBytes();
            StorageUnit unit = StorageUnit.bestFit(bytes);
            BigDecimal value = unit.fromBytes(bytes);
            writer.startNode("value");
            writer.setValue(value.toString());
            writer.endNode();
            writer.startNode("units");
            writer.setValue(unit.toString());
            writer.endNode();
        }
    }
}

