/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.service.wms.WMSGetCapabilities;
import org.geowebcache.service.wms.WMSRequests;
import org.geowebcache.service.wms.WMSTileFuser;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class WMSService
extends Service {
    public static final String SERVICE_WMS = "wms";
    private static Log log = LogFactory.getLog(WMSService.class);
    private boolean fullWMS = false;
    private boolean proxyRequests = false;
    private boolean proxyNonTiledRequests = false;
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private RuntimeStats stats;

    public WMSService(StorageBroker sb, TileLayerDispatcher tld, RuntimeStats stats) {
        super(SERVICE_WMS);
        this.sb = sb;
        this.tld = tld;
        this.stats = stats;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        long[] tileIndex;
        BoundingBox bbox;
        MimeType mimeType;
        String encoding = request.getCharacterEncoding();
        Map requestParameterMap = request.getParameterMap();
        String[] keys = new String[]{"layers", "request", "tiled", "cached", "metatiled", "width", "height"};
        Map values = ServletUtils.selectedStringsFromMap((Map)requestParameterMap, (String)encoding, (String[])keys);
        String layers = (String)values.get("layers");
        String req = (String)values.get("request");
        if (req != null && !req.equalsIgnoreCase("getmap")) {
            if (layers == null || layers.length() == 0) {
                layers = ServletUtils.stringFromMap((Map)requestParameterMap, (String)encoding, (String)"layer");
                values.put("LAYERS", layers);
            }
            ConveyorTile tile = new ConveyorTile(this.sb, layers, request, response);
            tile.setHint(req.toLowerCase());
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (layers == null) {
            throw new ServiceException("Unable to parse layers parameter from request.");
        }
        boolean tiled = Boolean.valueOf((String)values.get("tiled"));
        if (this.proxyNonTiledRequests && tiled) {
            ConveyorTile tile = new ConveyorTile(this.sb, layers, request, response);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        TileLayer tileLayer = this.tld.getTileLayer(layers);
        String[] paramKeys = new String[]{"format", "srs", "bbox"};
        Map paramValues = ServletUtils.selectedStringsFromMap((Map)requestParameterMap, (String)encoding, (String[])paramKeys);
        Map fullParameters = tileLayer.getModifiableParameters(requestParameterMap, encoding);
        String format = (String)paramValues.get("format");
        try {
            mimeType = MimeType.createFromFormat((String)format);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format, " + format);
        }
        String requestSrs = (String)paramValues.get("srs");
        if (requestSrs == null) {
            throw new ServiceException("No SRS specified");
        }
        SRS srs = SRS.getSRS((String)requestSrs);
        GridSubset gridSubset = tileLayer.getGridSubsetForSRS(srs);
        if (gridSubset == null) {
            throw new ServiceException("Unable to match requested SRS " + srs + " to those supported by layer");
        }
        String requestBbox = (String)paramValues.get("bbox");
        try {
            bbox = new BoundingBox(requestBbox);
            if (bbox == null || !bbox.isSane()) {
                throw new ServiceException("The bounding box parameter (" + requestBbox + ") is missing or not sane");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("The bounding box parameter (" + requestBbox + ") is invalid");
        }
        int tileWidth = Integer.parseInt((String)values.get("width"));
        int tileHeight = Integer.parseInt((String)values.get("height"));
        if (this.fullWMS) {
            tileIndex = null;
            try {
                tileIndex = gridSubset.closestIndex(bbox);
            }
            catch (GridMismatchException gme) {
                // empty catch block
            }
            if (tileIndex == null || gridSubset.getTileWidth() != tileWidth || gridSubset.getTileHeight() != tileHeight || !bbox.equals(gridSubset.boundsFromIndex(tileIndex), 0.02)) {
                log.debug((Object)"Recombinining tiles to respond to WMS request");
                ConveyorTile tile = new ConveyorTile(this.sb, layers, request, response);
                tile.setHint("getmap");
                tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
                return tile;
            }
        }
        tileIndex = gridSubset.closestIndex(bbox);
        gridSubset.checkTileDimensions(tileWidth, tileHeight);
        return new ConveyorTile(this.sb, layers, gridSubset.getName(), tileIndex, mimeType, fullParameters, request, response);
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        ConveyorTile tile = (ConveyorTile)conv;
        if (tile.getHint() != null) {
            if (tile.getHint().equalsIgnoreCase("getcapabilities")) {
                WMSGetCapabilities wmsCap = new WMSGetCapabilities(this.tld, tile.servletReq);
                wmsCap.writeResponse(tile.servletResp);
            } else if (tile.getHint().equalsIgnoreCase("getmap")) {
                WMSTileFuser wmsFuser = new WMSTileFuser(this.tld, this.sb, tile.servletReq);
                try {
                    wmsFuser.writeResponse(tile.servletResp, this.stats);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (tile.getHint().equalsIgnoreCase("getfeatureinfo")) {
                this.handleGetFeatureInfo(tile);
            } else {
                WMSRequests.handleProxy(this.tld, tile);
            }
        } else {
            throw new GeoWebCacheException("The WMS Service would love to help, but has no idea what you're trying to do?Please include request URL if you file a bug report.");
        }
    }

    private void handleGetFeatureInfo(ConveyorTile tile) throws GeoWebCacheException {
        int width;
        int height;
        int y;
        int x;
        MimeType mimeType;
        TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
        if (tl == null) {
            throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
        }
        String[] keys = new String[]{"x", "y", "srs", "info_format", "bbox", "height", "width"};
        Map values = ServletUtils.selectedStringsFromMap((Map)tile.servletReq.getParameterMap(), (String)tile.servletReq.getCharacterEncoding(), (String[])keys);
        GridSubset gridSubset = tl.getGridSubsetForSRS(SRS.getSRS((String)((String)values.get("srs"))));
        BoundingBox bbox = null;
        try {
            bbox = new BoundingBox((String)values.get("bbox"));
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)nfe.getMessage());
        }
        if (bbox == null || !bbox.isSane()) {
            throw new ServiceException("The bounding box parameter (" + (String)values.get("srs") + ") is missing or not sane");
        }
        try {
            mimeType = MimeType.createFromFormat((String)((String)values.get("info_format")));
        }
        catch (MimeException me) {
            throw new GeoWebCacheException("The info_format parameter (" + (String)values.get("info_format") + ")is missing or not recognized.");
        }
        ConveyorTile gfiConv = new ConveyorTile(this.sb, tl.getName(), gridSubset.getName(), null, mimeType, null, tile.servletReq, tile.servletResp);
        gfiConv.setTileLayer(tl);
        try {
            x = Integer.parseInt((String)values.get("x"));
            y = Integer.parseInt((String)values.get("y"));
        }
        catch (NumberFormatException nfe) {
            throw new GeoWebCacheException("The parameters for x and y must both be positive integers.");
        }
        try {
            height = Integer.parseInt((String)values.get("width"));
            width = Integer.parseInt((String)values.get("height"));
        }
        catch (NumberFormatException nfe) {
            throw new GeoWebCacheException("The parameters for height and width must both be positive integers.");
        }
        Resource data = tl.getFeatureInfo(gfiConv, bbox, height, width, x, y);
        try {
            tile.servletResp.setContentType(mimeType.getMimeType());
            ServletOutputStream outputStream = tile.servletResp.getOutputStream();
            data.transferTo(Channels.newChannel((OutputStream)outputStream));
            outputStream.flush();
        }
        catch (IOException ioe) {
            tile.servletResp.setStatus(500);
            log.error((Object)ioe.getMessage());
        }
    }

    public void setFullWMS(String trueFalse) {
        this.fullWMS = Boolean.parseBoolean(trueFalse);
        if (this.fullWMS) {
            log.info((Object)"Will recombine tiles for non-tiling clients.");
        } else {
            log.info((Object)"Will NOT recombine tiles for non-tiling clients.");
        }
    }

    public void setProxyRequests(String trueFalse) {
        this.proxyRequests = Boolean.parseBoolean(trueFalse);
        if (this.proxyRequests) {
            log.info((Object)"Will proxy requests to backend that are not getmap or getcapabilities.");
        } else {
            log.info((Object)"Will NOT proxy non-getMap requests to backend.");
        }
    }

    public void setProxyNonTiledRequests(String trueFalse) {
        this.proxyNonTiledRequests = Boolean.parseBoolean(trueFalse);
        if (this.proxyNonTiledRequests) {
            log.info((Object)"Will proxy requests that miss tiled=true to backend.");
        } else {
            log.info((Object)"Will NOT proxy requests that miss tiled=true to backend.");
        }
    }
}

