/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;

public class WMSRequests {
    private static Log log = LogFactory.getLog(WMSRequests.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleProxy(TileLayerDispatcher tld, ConveyorTile tile) throws GeoWebCacheException {
        WMSLayer layer = null;
        TileLayer tl = tld.getTileLayer(tile.getLayerId());
        if (tl == null) {
            throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
        }
        if (!(tl instanceof WMSLayer)) {
            throw new GeoWebCacheException(tile.getLayerId() + " is not served by a WMS backend.");
        }
        layer = (WMSLayer)tl;
        String queryStr = tile.servletReq.getQueryString();
        String serverStr = layer.getWMSurl()[0];
        GetMethod getMethod = null;
        try {
            URL url = serverStr.contains("?") ? new URL(serverStr + "&" + queryStr) : new URL(serverStr + queryStr);
            WMSSourceHelper helper = layer.getSourceHelper();
            if (!(helper instanceof WMSHttpHelper)) {
                throw new GeoWebCacheException("Can only proxy if WMS Layer is backed by an HTTP backend");
            }
            getMethod = ((WMSHttpHelper)helper).executeRequest(url, null, layer.getBackendTimeout());
            InputStream is = getMethod.getResponseBodyAsStream();
            HttpServletResponse response = tile.servletResp;
            response.setCharacterEncoding(getMethod.getResponseCharSet());
            response.setContentType(getMethod.getResponseHeader("Content-Type").getValue());
            int read = 0;
            byte[] data = new byte[1024];
            while (read > -1) {
                read = is.read(data);
                if (read <= -1) continue;
                response.getOutputStream().write(data, 0, read);
            }
        }
        catch (IOException ioe) {
            tile.servletResp.setStatus(500);
            log.error((Object)ioe.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }
}

