/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.util.List;
import org.geotools.data.wms.xml.Dimension;
import org.geotools.data.wms.xml.Extent;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.WMSDimensionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaiveWMSDimensionFilter
extends ParameterFilter
implements WMSDimensionProvider {
    private Dimension dimension;
    private Extent extent;

    public NaiveWMSDimensionFilter(Dimension dimension, Extent extent) {
        this.dimension = dimension;
        this.extent = extent;
        String keyName = dimension.getName();
        if (keyName.compareToIgnoreCase("time") != 0 && keyName.compareToIgnoreCase("elevation") != 0) {
            keyName = "dim_" + keyName;
        }
        this.key = keyName;
        this.defaultValue = extent.getDefaultValue();
    }

    public String apply(String str) throws ParameterException {
        return str;
    }

    public List<String> getLegalValues() {
        return null;
    }

    @Override
    public void appendDimensionElement(StringBuilder str, String indent) {
        str.append(indent).append("<Dimension name=\"").append(this.dimension.getName());
        str.append("\" units=\"").append(this.dimension.getUnits()).append("\"></Dimension>\n");
    }

    @Override
    public void appendExtentElement(StringBuilder str, String indent) {
        str.append(indent).append("<Extent name=\"" + this.extent.getName() + "\"");
        if (this.extent.getDefaultValue() != null) {
            str.append(" default=\"" + this.extent.getDefaultValue() + "\"");
        }
        str.append(">");
        if (this.extent.getValue() != null) {
            str.append(this.extent.getValue());
        }
        str.append("</Extent>\n");
    }
}

