/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.georss.GeoRSSPollTask;
import org.geowebcache.georss.PollDef;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.seed.TileBreeder;

public class GeoRSSPoller {
    private static final Log logger = LogFactory.getLog(GeoRSSPoller.class);
    private final TileBreeder seeder;
    private final ScheduledExecutorService schedulingPollExecutorService;
    private final List<PollDef> scheduledPolls;
    private final List<GeoRSSPollTask> scheduledTasks;

    public GeoRSSPoller(TileBreeder seeder, int startUpDelaySecs) {
        this.seeder = seeder;
        this.scheduledPolls = new ArrayList<PollDef>();
        this.scheduledTasks = new ArrayList<GeoRSSPollTask>();
        this.findEnabledPolls();
        if (this.pollCount() > 0) {
            boolean corePoolSize = true;
            this.schedulingPollExecutorService = Executors.newScheduledThreadPool(1);
            TimeUnit seconds = TimeUnit.SECONDS;
            for (PollDef poll : this.scheduledPolls) {
                GeoRSSPollTask command = new GeoRSSPollTask(poll, this.seeder);
                GeoRSSFeedDefinition pollDef = poll.getPollDef();
                long period = pollDef.getPollInterval();
                logger.info((Object)("Scheduling layer " + poll.getLayer().getName() + " to poll the GeoRSS feed " + pollDef.getFeedUrl() + " every " + pollDef.getPollIntervalStr()));
                this.schedulingPollExecutorService.scheduleAtFixedRate(command, startUpDelaySecs, period, seconds);
                this.scheduledTasks.add(command);
            }
            logger.info((Object)("Will wait " + startUpDelaySecs + " seconds before launching the " + this.pollCount() + " GeoRSS polls found"));
        } else {
            this.schedulingPollExecutorService = null;
            logger.info((Object)"No enabled GeoRSS feeds found, poller will not run.");
        }
    }

    private void findEnabledPolls() {
        logger.info((Object)"Initializing GeoRSS poller...");
        List layers = this.seeder.getLayers();
        if (layers.size() == 0) {
            logger.info((Object)"Found no layers configured, GeoRSS poller won't run");
            return;
        }
        for (TileLayer layer : layers) {
            if (layer.getUpdateSources().size() == 0) continue;
            if (!layer.isEnabled()) {
                logger.info((Object)("Ignoring polling GeoRSS update sources for layer '" + layer.getName() + "' as the layer is disabled"));
            }
            for (UpdateSourceDefinition usd : layer.getUpdateSources()) {
                if (!(usd instanceof GeoRSSFeedDefinition)) continue;
                GeoRSSFeedDefinition georssDef = (GeoRSSFeedDefinition)usd;
                String gridSetId = georssDef.getGridSetId();
                GridSubset gridSubset = layer.getGridSubset(gridSetId);
                if (gridSubset == null) {
                    throw new IllegalStateException("Layer " + layer.getName() + " has no grid subset " + gridSetId + " as configured by its GeoRSS seeding feed " + georssDef);
                }
                if (georssDef.getPollInterval() > 0) {
                    logger.info((Object)("Scheduling GeoRSS feed for layer " + layer.getName() + ":" + georssDef));
                    this.scheduledPolls.add(new PollDef(layer, georssDef));
                    continue;
                }
                logger.info((Object)("Feed disabled for layer " + layer.getName() + ", ignoring: " + georssDef));
            }
        }
    }

    public int pollCount() {
        return this.scheduledPolls.size();
    }

    public void destroy() {
        logger.info((Object)"destroy() invoked");
        if (this.schedulingPollExecutorService != null) {
            this.schedulingPollExecutorService.shutdown();
        }
        for (GeoRSSPollTask task : this.scheduledTasks) {
            task.stopSeeding(false);
        }
    }
}

