/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.PDFMapOutputFormat;
import org.geoserver.wms.map.PDFMaxSizeEnforcer;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.springframework.util.Assert;

public class PDFMapResponse
extends AbstractMapResponse {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.pdf");
    private static final int KB = 1024;
    private WMS wms;

    public PDFMapResponse(WMS wms) {
        super(PDFMapOutputFormat.PDFMap.class, "application/pdf");
        this.wms = wms;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(PDFMapOutputFormat.PDFMap.class, (Object)value);
        WMSMapContext mapContext = ((PDFMapOutputFormat.PDFMap)value).getContext();
        int width = mapContext.getMapWidth();
        int height = mapContext.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        try {
            Rectangle pageSize = new Rectangle((float)width, (float)height);
            Document document = new Document(pageSize);
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)output);
            document.open();
            DefaultFontMapper mapper = new DefaultFontMapper();
            FontFactory.registerDirectories();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PdfGraphics2D graphic = (PdfGraphics2D)tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
            if (!mapContext.isTransparent()) {
                graphic.setColor(mapContext.getBgColor());
                graphic.fillRect(0, 0, width, height);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("setting to transparent");
                }
                int type = 2;
                graphic.setComposite((Composite)AlphaComposite.getInstance(type));
                Color c = new Color(mapContext.getBgColor().getRed(), mapContext.getBgColor().getGreen(), mapContext.getBgColor().getBlue(), 0);
                graphic.setBackground(mapContext.getBgColor());
                graphic.setColor(c);
                graphic.fillRect(0, 0, width, height);
                type = 3;
                graphic.setComposite((Composite)AlphaComposite.getInstance(type));
            }
            java.awt.Rectangle paintArea = new java.awt.Rectangle(width, height);
            StreamingRenderer renderer = new StreamingRenderer();
            renderer.setContext((MapContext)mapContext);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderer.setJava2DHints(hints);
            HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
            rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
            rendererParams.put("renderingBuffer", new Integer(mapContext.getBuffer()));
            rendererParams.put("optimizeFTSRendering", Boolean.FALSE);
            rendererParams.put("vectorRenderingEnabled", Boolean.TRUE);
            if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
                rendererParams.put("lineWidthOptimization", Boolean.valueOf(true));
            }
            renderer.setRendererHints(rendererParams);
            ReferencedEnvelope dataArea = mapContext.getAreaOfInterest();
            int maxErrors = this.wms.getMaxRenderingErrors();
            MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
            RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
            renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
            int maxMemory = this.wms.getMaxRequestMemory() * 1024;
            PDFMaxSizeEnforcer memoryChecker = new PDFMaxSizeEnforcer((GTRenderer)renderer, graphic, maxMemory);
            renderer.paint((Graphics2D)graphic, paintArea, mapContext.getRenderingArea(), mapContext.getRenderingTransform());
            MapDecorationLayout.Block watermark = RenderedImageMapOutputFormat.getWatermark(this.wms.getServiceInfo());
            if (watermark != null) {
                MapDecorationLayout layout = new MapDecorationLayout();
                layout.paint((Graphics2D)graphic, paintArea, mapContext);
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                Exception renderError = nonIgnorableExceptionListener.getException();
                throw new ServiceException("Rendering process failed", (Throwable)renderError, "internalError");
            }
            if (errorChecker.exceedsMaxErrors()) {
                throw new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out", (Throwable)errorChecker.getLastException(), "internalError");
            }
            if (memoryChecker.exceedsMaxSize()) {
                long kbMax = maxMemory / 1024;
                throw new ServiceException("Rendering request used more memory than the maximum allowed:" + kbMax + "KB");
            }
            graphic.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
            writer.flush();
            writer.close();
        }
        catch (DocumentException t) {
            throw new ServiceException("Error setting up the PDF", (Throwable)t, "internalError");
        }
    }
}

