/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.opengis.feature.simple.SimpleFeature;

public class MaxErrorEnforcer {
    GTRenderer renderer;
    int maxErrors;
    int errors;
    Exception lastException;

    public MaxErrorEnforcer(GTRenderer renderer, int maxErrors) {
        this.renderer = renderer;
        this.maxErrors = maxErrors;
        this.errors = 0;
        if (maxErrors > 0) {
            renderer.addRenderListener(new RenderListener(){

                public void featureRenderer(SimpleFeature feature) {
                }

                public void errorOccurred(Exception e) {
                    ++MaxErrorEnforcer.this.errors;
                    MaxErrorEnforcer.this.lastException = e;
                    if (MaxErrorEnforcer.this.errors > MaxErrorEnforcer.this.maxErrors) {
                        MaxErrorEnforcer.this.renderer.stopRendering();
                    }
                }
            });
        }
    }

    public boolean exceedsMaxErrors() {
        return this.maxErrors > 0 && this.errors > this.maxErrors;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

