/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.ProgressListener;
import org.vfny.geoserver.util.Requests;

public class GetLegendGraphicKvpReader
extends KvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger(GetLegendGraphicKvpReader.class);
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private WMS wms;

    public GetLegendGraphicKvpReader(WMS wms) {
        super(GetLegendGraphicRequest.class);
        this.wms = wms;
    }

    public GetLegendGraphicRequest read(Object req, Map kvp, Map rawKvp) throws Exception {
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        if (request.getVersion() == null || request.getVersion().length() == 0) {
            String version = (String)rawKvp.get("WMTVER");
            if (version == null) {
                version = this.wms.getVersion();
            }
            request.setVersion(version);
        }
        String layer = (String)rawKvp.get("LAYER");
        boolean strict = rawKvp.containsKey("STRICT") ? Boolean.valueOf((String)rawKvp.get("STRICT")).booleanValue() : request.isStrict();
        request.setStrict(strict);
        if (strict && layer == null) {
            throw new ServiceException("LAYER parameter not present for GetLegendGraphic", "LayerNotDefined");
        }
        if (strict && request.getFormat() == null) {
            throw new ServiceException("Missing FORMAT parameter for GetLegendGraphic", "MissingFormat");
        }
        MapLayerInfo mli = null;
        if (layer != null) {
            LayerInfo layerInfo = this.wms.getLayerByName(layer);
            if (layerInfo == null) {
                throw new ServiceException(layer + " layer does not exist.");
            }
            mli = new MapLayerInfo(layerInfo);
            try {
                if (layerInfo.getType() == LayerInfo.Type.VECTOR) {
                    FeatureType featureType = mli.getFeature().getFeatureType();
                    request.setLayer(featureType);
                } else if (layerInfo.getType() == LayerInfo.Type.RASTER) {
                    CoverageInfo coverageInfo = mli.getCoverage();
                    AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)coverageInfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints());
                    SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, null);
                    request.setLayer(feature.getSchema());
                }
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (NoSuchElementException ne) {
                throw new ServiceException(new StringBuffer(layer).append(" layer does not exists.").toString(), (Throwable)ne);
            }
            catch (Exception te) {
                throw new ServiceException("Can't obtain the schema for the required layer.", (Throwable)te);
            }
        }
        if (request.getFormat() == null) {
            request.setFormat("image/png");
        }
        if (null == this.wms.getLegendGraphicOutputFormat(request.getFormat())) {
            throw new ServiceException(new StringBuffer("Invalid graphic format: ").append(request.getFormat()).toString(), "InvalidFormat");
        }
        try {
            this.parseOptionalParameters(request, mli, rawKvp);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return request;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, MapLayerInfo mli, Map rawKvp) throws IOException {
        this.parseStyleAndRule(req, mli, rawKvp);
        String legendOptions = (String)rawKvp.get("LEGEND_OPTIONS");
        req.setLegendOptions(Requests.parseOptionParameter((String)legendOptions));
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, MapLayerInfo layer, Map rawKvp) throws IOException {
        Style[] styles;
        String styleName = (String)rawKvp.get("STYLE");
        String sldUrl = (String)rawKvp.get("SLD");
        String sldBody = (String)rawKvp.get("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("looking for style ").append(styleName).toString());
        }
        Style sldStyle = null;
        if (sldUrl != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD parameter");
            }
            styles = this.loadRemoteStyle(sldUrl);
            sldStyle = this.findStyle(styleName, styles);
        } else if (sldBody != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD_BODY parameter");
            }
            styles = this.parseSldBody(sldBody);
            sldStyle = this.findStyle(styleName, styles);
        } else if (styleName != null && !"".equals(styleName)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from STYLE parameter");
            }
            sldStyle = this.wms.getStyleByName(styleName);
        } else {
            sldStyle = layer.getDefaultStyle();
        }
        req.setStyle(sldStyle);
        String rule = (String)rawKvp.get("RULE");
        Rule sldRule = this.extractRule(sldStyle, rule);
        if (sldRule != null) {
            req.setRule(sldRule);
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("styleName is null, request in literal mode, returning first style");
            }
            return styles[0];
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request in library mode, looking for style ").append(styleName).toString());
        }
        StringBuffer noMatchNames = new StringBuffer();
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i >= styles.length) continue;
            noMatchNames.append(", ");
        }
        throw new NoSuchElementException(styleName + " not found. Provided style names: " + noMatchNames);
    }

    private Style[] loadRemoteStyle(String sldUrl) throws ServiceException {
        InputStream in;
        try {
            URL url = new URL(sldUrl);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
        return this.parseSld(new InputStreamReader(in));
    }

    private Style[] parseSldBody(String sldBody) throws ServiceException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws ServiceException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new ServiceException((Throwable)e);
        }
        if (styles == null || styles.length == 0) {
            throw new ServiceException("Document contains no styles");
        }
        return styles;
    }

    private Rule extractRule(Style sldStyle, String rule) throws ServiceException {
        Rule sldRule = null;
        if (rule != null && !"".equals(rule)) {
            FeatureTypeStyle[] fts = sldStyle.getFeatureTypeStyles();
            block0: for (int i = 0; i < fts.length; ++i) {
                Rule[] rules = fts[i].getRules();
                for (int r = 0; r < rules.length; ++r) {
                    if (!rule.equalsIgnoreCase(rules[r].getName())) continue;
                    sldRule = rules[r];
                    if (!LOGGER.isLoggable(Level.FINE)) continue block0;
                    LOGGER.fine(new StringBuffer("found requested rule: ").append(rule).toString());
                    continue block0;
                }
            }
            if (sldRule == null) {
                throw new ServiceException("Style " + sldStyle.getName() + " does not contains a rule named " + rule);
            }
        }
        return sldRule;
    }
}

