/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.georss.AtomUtils;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class AtomGeoRSSTransformer
extends GeoRSSTransformerBase {
    private WMS wms;

    public AtomGeoRSSTransformer(WMS wms) {
        this.wms = wms;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new AtomGeoRSSTranslator(this.wms, handler);
    }

    public class AtomGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        private WMS wms;

        public AtomGeoRSSTranslator(WMS wms, ContentHandler contentHandler) {
            super(AtomGeoRSSTransformer.this, contentHandler, null, "http://www.w3.org/2005/Atom");
            this.wms = wms;
            this.nsSupport.declarePrefix("georss", "http://www.georss.org/georss");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            this.start("feed");
            this.element("title", AtomUtils.getFeedTitle(map));
            this.element("id", AtomUtils.getFeedURI(map));
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, AtomUtils.getFeedURL(map));
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("link", null, atts);
            this.element("updated", AtomUtils.dateToRFC3339(new Date()));
            try {
                this.encodeEntries(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("feed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeEntries(WMSMapContext map) throws IOException {
            List featureCollections = this.loadFeatureCollections(map);
            for (SimpleFeatureCollection features : featureCollections) {
                SimpleFeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        try {
                            this.encodeEntry(feature, map);
                        }
                        catch (Exception e) {
                            GeoRSSTransformerBase.LOGGER.warning("Encoding failed for feature: " + feature.getID());
                            GeoRSSTransformerBase.LOGGER.log(Level.FINE, "", e);
                        }
                    }
                }
                finally {
                    if (iterator == null) continue;
                    features.close((FeatureIterator)iterator);
                }
            }
        }

        void encodeEntry(SimpleFeature feature, WMSMapContext map) {
            this.start("entry");
            this.element("title", feature.getID());
            this.start("author");
            this.element("name", this.wms.getGeoServer().getGlobal().getContact().getContactPerson());
            this.end("author");
            this.element("id", AtomUtils.getEntryURI(this.wms, feature, map));
            String link = AtomUtils.getEntryURL(this.wms, feature, map);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, link);
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("link", null, atts);
            this.element("updated", AtomUtils.dateToRFC3339(new Date()));
            atts = new AttributesImpl();
            atts.addAttribute(null, "type", "type", null, "html");
            this.element("content", AtomUtils.getFeatureDescription(feature), atts);
            if (AtomGeoRSSTransformer.this.geometryEncoding == GeoRSSTransformerBase.GeometryEncoding.LATLONG || !(feature.getDefaultGeometry() instanceof GeometryCollection)) {
                this.start("georss:where");
                AtomGeoRSSTransformer.this.geometryEncoding.encode((Geometry)feature.getDefaultGeometry(), this);
                this.end("georss:where");
                this.end("entry");
            } else {
                GeometryCollection col = (GeometryCollection)feature.getDefaultGeometry();
                this.start("georss:where");
                AtomGeoRSSTransformer.this.geometryEncoding.encode(col.getGeometryN(0), this);
                this.end("georss:where");
                this.end("entry");
                for (int i = 1; i < col.getNumGeometries(); ++i) {
                    this.encodeRelatedGeometryEntry(col.getGeometryN(i), feature.getID(), link, link + "#" + i);
                }
            }
        }

        void encodeRelatedGeometryEntry(Geometry g, String title, String link, String id) {
            this.start("entry");
            this.element("id", id);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, link);
            atts.addAttribute(null, "rel", "rel", null, "related");
            this.element("link", null, atts);
            this.element("title", title);
            this.start("georss:where");
            AtomGeoRSSTransformer.this.geometryEncoding.encode(g, this);
            this.end("georss:where");
            this.end("entry");
        }
    }
}

