/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.util.Map;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geotools.util.Version;

public class CapabilitiesKvpReader
extends KvpRequestReader {
    private WMS wms;

    public CapabilitiesKvpReader(WMS wms) {
        super(GetCapabilitiesRequest.class);
        this.wms = wms;
    }

    public GetCapabilitiesRequest read(Object req, Map kvp, Map rawKvp) throws Exception {
        GetCapabilitiesRequest request = (GetCapabilitiesRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        String version = request.getVersion();
        if (null == version || version.length() == 0) {
            version = (String)rawKvp.get("WMTVER");
        }
        if (rawKvp.containsKey("VERSION") && rawKvp.containsKey("WMTVER")) {
            String ver = (String)rawKvp.get("VERSION");
            String wmtver = (String)rawKvp.get("WMTVER");
            if (WMS.version(ver, true) != null && WMS.version(wmtver, true) == null) {
                version = ver;
            } else if (WMS.version(ver, true) == null && WMS.version(wmtver, true) != null) {
                version = wmtver;
            }
        }
        Version requestedVersion = WMS.version(version);
        Version negotiatedVersion = WMS.negotiateVersion(requestedVersion);
        request.setVersion(negotiatedVersion.toString());
        return request;
    }
}

