/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.geoserver.wms.GetMapRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.map.GraphicEnhancedMapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.lite.RendererUtilities;

public class WMSMapContext
extends GraphicEnhancedMapContext {
    private int mapWidth;
    private int mapHeight;
    private Color bgColor = Color.white;
    private boolean transparent;
    private int tileSize = -1;
    private double angle;
    private int buffer;
    private InverseColorMapOp paletteInverter;
    private GetMapRequest request;

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public WMSMapContext() {
    }

    public WMSMapContext(GetMapRequest req) {
        this.request = req;
    }

    public WMSMapContext(MapLayer[] layers) {
        super(layers);
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public GetMapRequest getRequest() {
        return this.request;
    }

    public void setRequest(GetMapRequest request) {
        this.request = request;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public InverseColorMapOp getPaletteInverter() {
        return this.paletteInverter;
    }

    public void setPaletteInverter(InverseColorMapOp paletteInverter) {
        this.paletteInverter = paletteInverter;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double rotation) {
        this.angle = rotation;
    }

    public AffineTransform getRenderingTransform() {
        AffineTransform tx;
        Rectangle paintArea = new Rectangle(0, 0, this.getMapWidth(), this.getMapHeight());
        ReferencedEnvelope dataArea = this.getAreaOfInterest();
        if (this.getAngle() != 0.0) {
            tx = new AffineTransform();
            tx.translate(paintArea.width / 2, paintArea.height / 2);
            tx.rotate(Math.toRadians(this.getAngle()));
            tx.translate(-paintArea.width / 2, -paintArea.height / 2);
            tx.concatenate(RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea));
        } else {
            tx = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea);
        }
        return tx;
    }

    public ReferencedEnvelope getRenderingArea() {
        if (this.getAngle() == 0.0) {
            return this.getAreaOfInterest();
        }
        ReferencedEnvelope dataArea = this.getAreaOfInterest();
        AffineTransform tx = new AffineTransform();
        double offsetX = dataArea.getMinX() + dataArea.getWidth() / 2.0;
        double offsetY = dataArea.getMinY() + dataArea.getHeight() / 2.0;
        tx.translate(offsetX, offsetY);
        tx.rotate(Math.toRadians(this.getAngle()));
        tx.translate(-offsetX, -offsetY);
        Rectangle2D.Double dataAreaShape = new Rectangle2D.Double(dataArea.getMinX(), dataArea.getMinY(), dataArea.getWidth(), dataArea.getHeight());
        Rectangle2D transformedBounds = tx.createTransformedShape(dataAreaShape).getBounds2D();
        return new ReferencedEnvelope(transformedBounds, this.getAreaOfInterest().getCoordinateReferenceSystem());
    }
}

